/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.calculators;

import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public interface CheckSpawns {
    public static CheckSpawns getDefault() {
        return (spawner, sender, arguments) -> sender.func_197030_a((ITextComponent)new StringTextComponent("Not implemented."), false);
    }

    default public String getPermissionNode() {
        return "pixelmon.checkspawns.normal";
    }

    public void checkSpawns(AbstractSpawner var1, CommandSource var2, List<String> var3);

    default public List<IFormattableTextComponent> generateMessages(Map<String, Double> percentages, List<String> arguments) {
        ArrayList<IFormattableTextComponent> translationMessages = new ArrayList<IFormattableTextComponent>();
        ArrayList<String> messages = new ArrayList<String>();
        Predicate<String> caredAbout = null;
        for (String argument : arguments) {
            for (String key : percentages.keySet()) {
                if (!key.equalsIgnoreCase(argument)) continue;
                String needed = PixelmonSpecies.fromNameOrDex(argument).isPresent() ? PixelmonSpecies.fromNameOrDex(argument).get().getLocalizedName() : I18n.func_135052_a((String)argument, (Object[])new Object[0]);
                if (caredAbout == null) {
                    caredAbout = s -> s.equalsIgnoreCase(needed);
                    continue;
                }
                Predicate<String> pTemp = caredAbout;
                caredAbout = s -> pTemp.test((String)s) || s.equalsIgnoreCase(needed);
            }
        }
        if (caredAbout == null) {
            caredAbout = s -> true;
        }
        double greenThreshold = 10.0;
        double yellowThreshold = 2.0;
        double redThreshold = 0.5;
        double lightPurpleThreshold = 0.001;
        ArrayList<Map.Entry<String, Double>> sortedEntries = new ArrayList<Map.Entry<String, Double>>(percentages.entrySet());
        sortedEntries.sort(Map.Entry.comparingByValue());
        for (Map.Entry<String, Double> entry : sortedEntries) {
            if (!caredAbout.test(entry.getKey())) continue;
            TextFormatting colour = TextFormatting.DARK_PURPLE;
            if (entry.getValue() > 10.0) {
                colour = TextFormatting.GREEN;
            } else if (entry.getValue() > 2.0) {
                colour = TextFormatting.YELLOW;
            } else if (entry.getValue() > 0.5) {
                colour = TextFormatting.RED;
            } else if (entry.getValue() > 0.001) {
                colour = TextFormatting.LIGHT_PURPLE;
            }
            messages.add(TextFormatting.GOLD + entry.getKey() + TextFormatting.GRAY + ": " + colour + entry.getValue() + "%");
        }
        while (!messages.isEmpty()) {
            String message = (String)messages.remove(0);
            int onThisLine = 1;
            while (!messages.isEmpty() && onThisLine++ < 3) {
                message = message + TextFormatting.GOLD + ", " + (String)messages.remove(0);
            }
            translationMessages.add((IFormattableTextComponent)new StringTextComponent(message));
        }
        return translationMessages;
    }
}

