/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.pixelmonmod.pixelmon.api.recipe.QuantifiedIngredient;
import com.pixelmonmod.pixelmon.api.util.helpers.JsonHelper;
import com.pixelmonmod.pixelmon.init.registry.RecipeTypeRegistration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class InfuserRecipe
implements IRecipe<IInventory> {
    protected final NonNullList<QuantifiedIngredient> input;
    protected final ItemStack result;
    private final ResourceLocation name;

    public InfuserRecipe(ResourceLocation name, NonNullList<QuantifiedIngredient> in, ItemStack out) {
        this.input = in;
        this.result = out;
        this.name = name;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return ((QuantifiedIngredient)this.input.get(0)).matches(inv.func_70301_a(1)) && ((QuantifiedIngredient)this.input.get(1)).matches(inv.func_70301_a(2));
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.name;
    }

    @Nonnull
    public IRecipeSerializer<InfuserRecipe> func_199559_b() {
        return (IRecipeSerializer)RecipeTypeRegistration.INFUSER_RECIPES.get();
    }

    @Nonnull
    public IRecipeType<InfuserRecipe> func_222127_g() {
        return RecipeTypeRegistration.INFUSER_RECIPE_TYPE;
    }

    public NonNullList<QuantifiedIngredient> getQualifiedIngredients() {
        return this.input;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Type
    implements IRecipeType<InfuserRecipe> {
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<InfuserRecipe> {
        protected NonNullList<QuantifiedIngredient> input;
        protected ItemStack result;

        public InfuserRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList<QuantifiedIngredient> nonnulllist = JsonHelper.quantifiedItemsFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for crusher recipe");
            }
            ItemStack output = CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("results"), (boolean)true);
            if (output.func_190926_b()) {
                throw new JsonParseException("No results for infuser recipe");
            }
            return new InfuserRecipe(recipeId, nonnulllist, output);
        }

        @Nullable
        public InfuserRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int size = buffer.func_150792_a();
            NonNullList nonnulllist = NonNullList.func_191197_a((int)size, (Object)new QuantifiedIngredient(Ingredient.field_193370_a, 0));
            for (int i = 0; i < size; ++i) {
                nonnulllist.set(i, (Object)new QuantifiedIngredient(Ingredient.func_199566_b((PacketBuffer)buffer), buffer.readInt()));
            }
            ItemStack output = buffer.func_150791_c();
            return new InfuserRecipe(recipeId, (NonNullList<QuantifiedIngredient>)nonnulllist, output);
        }

        public void toNetwork(PacketBuffer buffer, InfuserRecipe recipe) {
            buffer.func_150787_b(recipe.input.size());
            for (QuantifiedIngredient ingredient : recipe.input) {
                ingredient.ingredient.func_199564_a(buffer);
                buffer.writeInt(ingredient.quantity);
            }
            buffer.func_150788_a(recipe.result);
        }
    }
}

