/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.flying.FlyingParameters;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.flying.LandingMaterials;
import java.lang.reflect.Type;

public class FlyingParametersTypeAdapter
implements JsonSerializer<FlyingParameters>,
JsonDeserializer<FlyingParameters> {
    public FlyingParameters deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        int flyHeightMin = jsonObject.get("flyHeightMin").getAsInt();
        int flyHeightMax = jsonObject.get("flyHeightMax").getAsInt();
        float flySpeedModifier = jsonObject.get("flySpeedModifier").getAsFloat();
        int flyRefreshRateY = jsonObject.get("flyRefreshRateY").getAsInt();
        int flyRefreshRateXZ = jsonObject.get("flyRefreshRateXZ").getAsInt();
        int flyRefreshRateSpeed = jsonObject.get("flyRefreshRateSpeed").getAsInt();
        int flightTimeMin = jsonObject.get("flightTimeMin").getAsInt();
        int flightTimeMax = jsonObject.get("flightTimeMax").getAsInt();
        int flapRate = jsonObject.get("flapRate").getAsInt();
        LandingMaterials landingMaterials = LandingMaterials.valueOf(jsonObject.get("landingMaterials").getAsString());
        return new FlyingParameters(flyHeightMin, flyHeightMax, flySpeedModifier, flyRefreshRateY, flyRefreshRateXZ, flyRefreshRateSpeed, flightTimeMin, flightTimeMax, flapRate, landingMaterials);
    }

    public JsonElement serialize(FlyingParameters src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.add("flyHeightMin", (JsonElement)new JsonPrimitive((Number)src.getFlyHeightMin()));
        object.add("flyHeightMax", (JsonElement)new JsonPrimitive((Number)src.getFlyHeightMax()));
        object.add("flySpeedModifier", (JsonElement)new JsonPrimitive((Number)Float.valueOf(src.getFlySpeedModifier())));
        object.add("flyRefreshRateY", (JsonElement)new JsonPrimitive((Number)src.getFlyRefreshRateY()));
        object.add("flyRefreshRateXZ", (JsonElement)new JsonPrimitive((Number)src.getFlyRefreshRateXZ()));
        object.add("flyRefreshRateSpeed", (JsonElement)new JsonPrimitive((Number)src.getFlyRefreshRateSpeed()));
        object.add("flightTimeMin", (JsonElement)new JsonPrimitive((Number)src.getFlightTimeMin()));
        object.add("flightTimeMax", (JsonElement)new JsonPrimitive((Number)src.getFlightTimeMax()));
        object.add("flapRate", (JsonElement)new JsonPrimitive((Number)src.getFlapRate()));
        object.add("landingMaterials", (JsonElement)new JsonPrimitive(src.getLandingMaterials().name()));
        return object;
    }
}

