/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ribbon;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.Ribbon;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.type.RibbonType;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.util.ResourceWithFallback;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

public class MutableRibbonData {
    protected ITextComponent prefix;
    protected ITextComponent suffix;
    protected ITextComponent title;
    protected ITextComponent description;
    protected ResourceWithFallback icon;
    protected PaletteProperties overridePalette;

    public MutableRibbonData() {
    }

    protected MutableRibbonData(ITextComponent prefix, ITextComponent suffix, ITextComponent title, ITextComponent description, ResourceWithFallback icon, PaletteProperties overridePalette) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.overridePalette = overridePalette;
    }

    public static MutableRibbonData fromType(RibbonType ribbonType, Pokemon pixelmon, Ribbon ribbon) {
        return MutableRibbonData.fromType(ribbonType, pixelmon.getOrCreatePixelmon(), ribbon);
    }

    public static MutableRibbonData fromType(RibbonType ribbonType, PixelmonEntity pixelmon, Ribbon ribbon) {
        return new MutableRibbonData().setPrefix(ribbonType.getNamePrefix(pixelmon, ribbon)).setSuffix(ribbonType.getNameSuffix(pixelmon, ribbon)).setTitle((ITextComponent)ribbonType.getTranslatedName()).setDescription(ribbonType.getDescription()).setIcon(ribbonType.getIcon(pixelmon.getPokemon(), ribbon)).setOverridePalette(ribbonType.getPaletteOverride(pixelmon, ribbon));
    }

    public ITextComponent getPrefix() {
        return this.prefix;
    }

    public MutableRibbonData setPrefix(ITextComponent prefix) {
        this.prefix = prefix;
        return this;
    }

    public ITextComponent getSuffix() {
        return this.suffix;
    }

    public MutableRibbonData setSuffix(ITextComponent suffix) {
        this.suffix = suffix;
        return this;
    }

    public ITextComponent getTitle() {
        return this.title;
    }

    public MutableRibbonData setTitle(ITextComponent title) {
        this.title = title;
        return this;
    }

    public ITextComponent getDescription() {
        return this.description;
    }

    public MutableRibbonData setDescription(ITextComponent description) {
        this.description = description;
        return this;
    }

    public ResourceWithFallback getIcon() {
        return this.icon;
    }

    public MutableRibbonData setIcon(ResourceWithFallback icon) {
        this.icon = icon;
        return this;
    }

    public PaletteProperties getOverridePalette() {
        return this.overridePalette;
    }

    public MutableRibbonData setOverridePalette(PaletteProperties overridePalette) {
        this.overridePalette = overridePalette;
        return this;
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.writeBoolean(this.prefix != null);
        if (this.prefix != null) {
            buffer.func_179256_a(this.prefix);
        }
        buffer.writeBoolean(this.suffix != null);
        if (this.suffix != null) {
            buffer.func_179256_a(this.suffix);
        }
        buffer.func_179256_a(this.title);
        buffer.func_179256_a(this.description);
        buffer.func_180714_a(RibbonRegistry.GSON.toJson((Object)this.icon));
        buffer.writeBoolean(this.overridePalette != null);
        if (this.overridePalette != null) {
            buffer.func_180714_a(RibbonRegistry.GSON.toJson((Object)this.overridePalette));
        }
    }

    public static MutableRibbonData fromBuffer(PacketBuffer buffer) {
        MutableRibbonData ribbonData = new MutableRibbonData();
        if (buffer.readBoolean()) {
            ribbonData.setPrefix(buffer.func_179258_d());
        }
        if (buffer.readBoolean()) {
            ribbonData.setSuffix(buffer.func_179258_d());
        }
        ribbonData.setTitle(buffer.func_179258_d()).setDescription(buffer.func_179258_d()).setIcon((ResourceWithFallback)RibbonRegistry.GSON.fromJson(buffer.func_218666_n(), ResourceWithFallback.class));
        if (buffer.readBoolean()) {
            ribbonData.setOverridePalette((PaletteProperties)RibbonRegistry.GSON.fromJson(buffer.func_218666_n(), PaletteProperties.class));
        }
        return ribbonData;
    }
}

