/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.custom;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.Tuple;

public class Revenant
extends AbstractAbility {
    private static final List<Supplier<HeldItem>> ITEM_POOL = Lists.newArrayList((Object[])new Supplier[]{() -> PixelmonItems.weakness_policy, () -> PixelmonItems.blunder_policy, () -> PixelmonItems.rocky_helmet, () -> PixelmonItems.red_card, () -> PixelmonItems.air_balloon, () -> PixelmonItems.focus_sash, () -> PixelmonItems.assault_vest, () -> PixelmonItems.bright_powder, () -> PixelmonItems.expert_belt, () -> PixelmonItems.kings_rock, () -> PixelmonItems.life_orb, () -> PixelmonItems.metronome, () -> PixelmonItems.protective_pads, () -> PixelmonItems.safety_goggles, () -> PixelmonItems.scope_lens, () -> PixelmonItems.white_herb, () -> PixelmonItems.wide_lens, () -> PixelmonItems.zoom_lens, () -> PixelmonItems.mental_herb, () -> PixelmonItems.power_herb});
    private static final Map<Element, AttackPool> ATTACK_POOLS = ImmutableMap.builder().put((Object)Element.DRAGON, (Object)AttackPool.of(Element.DRAGON, () -> AttackRegistry.DRAGON_CLAW, () -> AttackRegistry.OUTRAGE, () -> AttackRegistry.EARTHQUAKE, () -> AttackRegistry.FLASH_CANNON, () -> AttackRegistry.HAZE, () -> AttackRegistry.DISCHARGE, () -> AttackRegistry.DRAGON_DANCE, () -> AttackRegistry.DYNAMAX_CANNON, () -> AttackRegistry.DRAGON_ASCENT)).put((Object)Element.FIRE, (Object)AttackPool.of(Element.FIRE, () -> AttackRegistry.FIERY_DANCE, () -> AttackRegistry.FIRE_LASH, () -> AttackRegistry.APPLE_ACID, () -> AttackRegistry.POWER_WHIP, () -> AttackRegistry.EARTHQUAKE, () -> AttackRegistry.FREEZE_DRY, () -> AttackRegistry.POWER_GEM, () -> AttackRegistry.TAIL_GLOW, () -> AttackRegistry.FUSION_FLARE)).put((Object)Element.ELECTRIC, (Object)AttackPool.of(Element.ELECTRIC, () -> AttackRegistry.BOLT_BEAK, () -> AttackRegistry.THUNDERBOLT, () -> AttackRegistry.EARTHQUAKE, () -> AttackRegistry.BLIZZARD, () -> AttackRegistry.ICICLE_CRASH, () -> AttackRegistry.SHIFT_GEAR, () -> AttackRegistry.TAIL_GLOW, () -> AttackRegistry.THUNDER, () -> AttackRegistry.FUSION_BOLT)).put((Object)Element.FLYING, (Object)AttackPool.of(Element.FLYING, () -> AttackRegistry.HURRICANE, () -> AttackRegistry.ACROBATICS, () -> AttackRegistry.EARTHQUAKE, () -> AttackRegistry.AURA_SPHERE, () -> AttackRegistry.FLASH_CANNON, () -> AttackRegistry.DRAGON_DANCE, () -> AttackRegistry.QUIVER_DANCE, () -> AttackRegistry.DRAGON_ASCENT, () -> AttackRegistry.FLY)).put((Object)Element.POISON, (Object)AttackPool.of(Element.POISON, () -> AttackRegistry.SHELL_SIDE_ARM, () -> AttackRegistry.BARB_BARRAGE, () -> AttackRegistry.SUCKER_PUNCH, () -> AttackRegistry.KNOCK_OFF, () -> AttackRegistry.GRAV_APPLE, () -> AttackRegistry.EARTHQUAKE, () -> AttackRegistry.SWORDS_DANCE, () -> AttackRegistry.BANEFUL_BUNKER, () -> AttackRegistry.TOXIC)).put((Object)Element.FAIRY, (Object)AttackPool.of(Element.FAIRY, () -> AttackRegistry.GEOMANCY, () -> AttackRegistry.LANDS_WRATH, () -> AttackRegistry.SPIRIT_BREAK, () -> AttackRegistry.MOONBLAST, () -> AttackRegistry.SCORCHING_SANDS, () -> AttackRegistry.EARTHQUAKE, () -> AttackRegistry.FLARE_BLITZ, () -> AttackRegistry.WILL_O_WISP, () -> AttackRegistry.SMACK_DOWN)).put((Object)Element.WATER, (Object)AttackPool.of(Element.WATER, () -> AttackRegistry.FISHIOUS_REND, () -> AttackRegistry.BOLT_BEAK, () -> AttackRegistry.GLACIAL_LANCE, () -> AttackRegistry.WOOD_HAMMER, () -> AttackRegistry.SHIFT_GEAR, () -> AttackRegistry.HYDRO_PUMP, () -> AttackRegistry.WATERFALL, () -> AttackRegistry.DIVE, () -> AttackRegistry.SPACIAL_REND)).put((Object)Element.ICE, (Object)AttackPool.of(Element.ICE, () -> AttackRegistry.MIND_READER, () -> AttackRegistry.SHEER_COLD, () -> AttackRegistry.LOCK_ON, () -> AttackRegistry.BLIZZARD, () -> AttackRegistry.BLUE_FLARE, () -> AttackRegistry.THOUSAND_WAVES, () -> AttackRegistry.PSYSHOCK, () -> AttackRegistry.ICE_BEAM, () -> AttackRegistry.ICICLE_CRASH)).put((Object)Element.BUG, (Object)AttackPool.of(Element.BUG, () -> AttackRegistry.LUNGE, () -> AttackRegistry.FELL_STINGER, () -> AttackRegistry.MEGAHORN, () -> AttackRegistry.EARTHQUAKE, () -> AttackRegistry.KNOCK_OFF, () -> AttackRegistry.SMACK_DOWN, () -> AttackRegistry.METEOR_MASH, () -> AttackRegistry.SWORDS_DANCE, () -> AttackRegistry.THOUSAND_ARROWS)).put((Object)Element.DARK, (Object)AttackPool.of(Element.DARK, () -> AttackRegistry.NIGHT_DAZE, () -> AttackRegistry.FIERY_WRATH, () -> AttackRegistry.SLUDGE_WAVE, () -> AttackRegistry.MOONBLAST, () -> AttackRegistry.FIRE_BLAST, () -> AttackRegistry.FLASH_CANNON, () -> AttackRegistry.NASTY_PLOT, () -> AttackRegistry.DARK_VOID, () -> AttackRegistry.TAUNT)).put((Object)Element.PSYCHIC, (Object)AttackPool.of(Element.PSYCHIC, () -> AttackRegistry.FREEZING_GLARE, () -> AttackRegistry.STORED_POWER, () -> AttackRegistry.PSYSHIELD_BASH, () -> AttackRegistry.MYSTICAL_FIRE, () -> AttackRegistry.SIGNAL_BEAM, () -> AttackRegistry.PSYCHIC, () -> AttackRegistry.PSYSTRIKE, () -> AttackRegistry.PSYCHO_CUT, () -> AttackRegistry.HYPNOSIS)).put((Object)Element.GRASS, (Object)AttackPool.of(Element.GRASS, () -> AttackRegistry.APPLE_ACID, () -> AttackRegistry.POWER_WHIP, () -> AttackRegistry.SACRED_FIRE, () -> AttackRegistry.GRASS_KNOT, () -> AttackRegistry.CHLOROBLAST, () -> AttackRegistry.ICE_BEAM, () -> AttackRegistry.GROWTH, () -> AttackRegistry.SPORE, () -> AttackRegistry.WOOD_HAMMER)).put((Object)Element.ROCK, (Object)AttackPool.of(Element.ROCK, () -> AttackRegistry.DIAMOND_STORM, () -> AttackRegistry.PRECIPICE_BLADES, () -> AttackRegistry.ACCELEROCK, () -> AttackRegistry.COIL, () -> AttackRegistry.HEAT_CRASH, () -> AttackRegistry.BOLT_STRIKE, () -> AttackRegistry.BODY_PRESS, () -> AttackRegistry.ROCK_TOMB, () -> AttackRegistry.STEALTH_ROCK)).put((Object)Element.STEEL, (Object)AttackPool.of(Element.STEEL, () -> AttackRegistry.SHIFT_GEAR, () -> AttackRegistry.DOUBLE_IRON_BASH, () -> AttackRegistry.EARTHQUAKE, () -> AttackRegistry.SUNSTEEL_STRIKE, () -> AttackRegistry.POWER_WHIP, () -> AttackRegistry.DOOM_DESIRE, () -> AttackRegistry.KINGS_SHIELD, () -> AttackRegistry.BEHEMOTH_BASH, () -> AttackRegistry.BEHEMOTH_BLADE)).put((Object)Element.NORMAL, (Object)AttackPool.of(Element.NORMAL, () -> AttackRegistry.BOOMBURST, () -> AttackRegistry.EXTREME_SPEED, () -> AttackRegistry.SACRED_SWORD, () -> AttackRegistry.EARTHQUAKE, () -> AttackRegistry.SWORDS_DANCE, () -> AttackRegistry.SPECTRAL_THIEF, () -> AttackRegistry.DARKEST_LARIAT, () -> AttackRegistry.MULTI_ATTACK, () -> AttackRegistry.GIGA_IMPACT)).put((Object)Element.GHOST, (Object)AttackPool.of(Element.GHOST, () -> AttackRegistry.SPECTRAL_THIEF, () -> AttackRegistry.ASTRAL_BARRAGE, () -> AttackRegistry.NASTY_PLOT, () -> AttackRegistry.MOONBLAST, () -> AttackRegistry.POLTERGEIST, () -> AttackRegistry.CALM_MIND, () -> AttackRegistry.BLUE_FLARE, () -> AttackRegistry.SHADOW_FORCE, () -> AttackRegistry.MOONGEIST_BEAM)).put((Object)Element.FIGHTING, (Object)AttackPool.of(Element.FIGHTING, () -> AttackRegistry.SPECTRAL_THIEF, () -> AttackRegistry.THUNDEROUS_KICK, () -> AttackRegistry.FOCUS_BLAST, () -> AttackRegistry.BODY_PRESS, () -> AttackRegistry.TRIPLE_AXEL, () -> AttackRegistry.KNOCK_OFF, () -> AttackRegistry.HIGH_JUMP_KICK, () -> AttackRegistry.CLOSE_COMBAT, () -> AttackRegistry.POWER_UP_PUNCH)).put((Object)Element.GROUND, (Object)AttackPool.of(Element.GROUND, () -> AttackRegistry.THOUSAND_ARROWS, () -> AttackRegistry.CIRCLE_THROW, () -> AttackRegistry.THOUSAND_WAVES, () -> AttackRegistry.PURSUIT, () -> AttackRegistry.WOOD_HAMMER, () -> AttackRegistry.SKY_DROP, () -> AttackRegistry.EARTHQUAKE, () -> AttackRegistry.ANCIENT_POWER, () -> AttackRegistry.PRECIPICE_BLADES)).build();
    private boolean init = false;
    private int uses;
    private boolean rezzing = false;

    public Revenant() {
        this.initUses();
    }

    private void initUses() {
        this.uses = RandomHelper.getRandomNumberBetween(4, 6);
    }

    private void applyRandomMoveset(PixelmonWrapper pw) {
        List<Element> types = Element.getRandomTypes(2, false, true);
        Moveset moveset = pw.getMoveset();
        Tuple<Optional<ImmutableAttack>, Optional<ImmutableAttack>> moves12 = ATTACK_POOLS.get(types.get(0)).getTwoAttacks();
        Tuple<Optional<ImmutableAttack>, Optional<ImmutableAttack>> moves34 = ATTACK_POOLS.get(types.get(1)).getTwoAttacks();
        ((Optional)moves12.func_76341_a()).ifPresent(attack -> moveset.set(0, attack.ofMutable()));
        ((Optional)moves12.func_76340_b()).ifPresent(attack -> moveset.set(1, attack.ofMutable()));
        ((Optional)moves34.func_76341_a()).ifPresent(attack -> moveset.set(2, attack.ofMutable()));
        ((Optional)moves34.func_76340_b()).ifPresent(attack -> moveset.set(3, attack.ofMutable()));
        pw.setHeldItem(RandomHelper.getRandomElementFromCollection(ITEM_POOL).get());
        pw.setTempType(types);
    }

    @Override
    public int onHealed(PixelmonWrapper pw, int heal) {
        if (this.rezzing) {
            return heal;
        }
        if (pw.getHeldItem() == null || pw.getHeldItem() == NoItem.noItem) {
            this.sendToAll(pw, "pixelmon.abilities.revenant8", pw.getNickname());
        } else {
            this.sendToAll(pw, "pixelmon.abilities.revenant8a", pw.getNickname(), pw.getHeldItem().getLocalizedName());
        }
        pw.setHeldItem((HeldItem)null);
        Attack attack = pw.attack;
        pw.attack = null;
        pw.doBattleDamage(pw, Math.min(pw.getHealth() - 1, heal) + 1, DamageTypeEnum.ABILITY);
        pw.attack = attack;
        return 0;
    }

    @Override
    public int modifyDamage(int damage, PixelmonWrapper user, PixelmonWrapper pokemon, DamageTypeEnum type, @Nullable Attack attack, @Nullable Ability ability) {
        if (this.rezzing) {
            return 0;
        }
        if (!(this.uses <= 0 || pokemon == null || damage < pokemon.getHealth() || pokemon.getHealthDeficit() <= 0 && pokemon.getHeldItem() == PixelmonItems.focus_sash || attack != null && attack.isAttack(AttackRegistry.FALSE_SWIPE, AttackRegistry.HOLD_BACK))) {
            this.sendToAll(pokemon, "pixelmon.abilities.revenant", pokemon.getNickname());
            this.rezzing = true;
            return pokemon.getHealth() - 1;
        }
        return damage;
    }

    @Override
    public void onDamageReceived(PixelmonWrapper user, PixelmonWrapper pokemon, Attack a, int damage, DamageTypeEnum damagetype) {
        if (this.rezzing) {
            pokemon.healByPercent(100.0f);
            pokemon.removePrimaryStatus(true);
            this.applyRandomMoveset(pokemon);
            this.sendToAll(pokemon, "pixelmon.abilities.revenant3", pokemon.getNickname());
            this.sendToAll(pokemon, "pixelmon.abilities.revenant4", pokemon.getNickname(), pokemon.type.get(0).getLocalizedName(), pokemon.type.get(1).getLocalizedName());
            this.sendToAll(pokemon, "pixelmon.abilities.revenant5", pokemon.getNickname(), pokemon.getHeldItem().getLocalizedName());
            --this.uses;
            if (this.uses <= 0) {
                this.sendToAll(pokemon, "pixelmon.abilities.revenant6", pokemon.getNickname());
            }
            this.rezzing = false;
        }
    }

    @Override
    public boolean allowsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
        return this.uses <= 0 || !a.isAttack(AttackRegistry.DESTINY_BOND, AttackRegistry.PERISH_SONG, AttackRegistry.FISSURE, AttackRegistry.GUILLOTINE, AttackRegistry.HORN_DRILL, AttackRegistry.SHEER_COLD);
    }

    @Override
    public void allowsIncomingAttackMessage(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
        if (user.bc != null && this.uses > 0) {
            this.sendToAll(user, "pixelmon.abilities.revenant2", pokemon.getNickname());
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (this.init) {
            return;
        }
        this.initUses();
        this.sendToAll(newPokemon, "pixelmon.abilities.revenant7", newPokemon.getNickname());
        this.sendToAll(newPokemon, "pixelmon.abilities.pressure", newPokemon.getNickname());
        newPokemon.getStats().getIVs().fillFromArray(31, 31, 31, 31, 31, 31);
        newPokemon.getStats().getEVs().fillFromArray(252, 252, 252, 252, 252, 252);
        this.applyRandomMoveset(newPokemon);
        this.sendToAll(newPokemon, "pixelmon.abilities.revenant3a", newPokemon.getNickname());
        this.sendToAll(newPokemon, "pixelmon.abilities.revenant4a", newPokemon.getNickname(), newPokemon.type.get(0).getLocalizedName(), newPokemon.type.get(1).getLocalizedName());
        this.sendToAll(newPokemon, "pixelmon.abilities.revenant5a", newPokemon.getNickname(), newPokemon.getHeldItem().getLocalizedName());
        this.init = true;
    }

    @Override
    public void applyEndOfBattleEffect(PixelmonWrapper pokemon) {
        this.init = false;
    }

    @Override
    public void preProcessAttack(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
        if (a.pp > 1 && !user.bc.simulateMode && !user.inMultipleHit) {
            --a.pp;
        }
    }

    @Override
    public int modifyDamageTarget(int damage, PixelmonWrapper user, PixelmonWrapper pokemon, Attack a) {
        if (pokemon.getHealth() == pokemon.getMaxHealth()) {
            return damage / 2;
        }
        return damage;
    }

    @Override
    public boolean canBeIgnored() {
        return false;
    }

    @Override
    public boolean canBeCopied() {
        return false;
    }

    @Override
    public boolean alwaysConsideredDamaged(PixelmonWrapper pw) {
        return true;
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    @Override
    public boolean canPerish() {
        return false;
    }

    @Override
    public boolean needNewInstance() {
        return true;
    }

    private void sendToAll(PixelmonWrapper pw, String key, Object ... data) {
        if (pw.bc != null) {
            pw.bc.sendToAll(key, data);
        }
    }

    private static class AttackPool {
        private final Element type;
        private final List<Supplier<Optional<ImmutableAttack>>> attacks;

        @SafeVarargs
        private AttackPool(Element type, Supplier<Optional<ImmutableAttack>> ... attacks) {
            this.type = type;
            this.attacks = Lists.newArrayList((Object[])attacks);
        }

        @SafeVarargs
        public static AttackPool of(Element type, Supplier<Optional<ImmutableAttack>> ... attacks) {
            return new AttackPool(type, attacks);
        }

        public Tuple<Optional<ImmutableAttack>, Optional<ImmutableAttack>> getTwoAttacks() {
            int[] ordinals = RandomHelper.getRandomDistinctNumbersBetween(0, this.attacks.size() - 1, 2);
            return new Tuple(this.attacks.get(ordinals[0]).get(), this.attacks.get(ordinals[1]).get());
        }
    }
}

