/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Charge;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Tailwind;
import java.util.Set;

public class WindPower
extends AbstractAbility {
    private Set<String> WIND_ATTACKS = Sets.newHashSet((Object[])new String[]{"Air Cutter", "Bleakwind Storm", "Blizzard", "Fairy Wind", "Gust", "Heat Wave", "Hurricane", "Icy Wind", "Petal Blizzard", "Sandsear Storm", "Sandstorm", "Springtide Storm", "Tailwind", "Twister", "Whirlwind", "Wildbolt Storm"});

    @Override
    public void tookDamageTarget(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (this.WIND_ATTACKS.contains(a.getMove().getAttackName()) && !target.hasStatus(StatusType.Charge)) {
            target.bc.sendToAll("pixelmon.abilities.electromorphosis", a.getMove().getLocalizedName(), target.getNickname());
            target.addStatus(new Charge(), target);
        }
    }

    @Override
    public void onStatusAdded(StatusBase status, PixelmonWrapper user, PixelmonWrapper opponent) {
        if (status instanceof Tailwind) {
            user.bc.sendToAll("pixelmon.abilities.electromorphosis", status.type.getLocalizedName(), user.getNickname());
            user.addStatus(new Charge(), user);
        }
    }
}

