/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonBattleDataPacket;
import net.minecraft.entity.player.ServerPlayerEntity;

public class Illusion
extends AbstractAbility {
    public Species disguisedPokemon = null;
    public String disguisedNickname = null;
    public String disguisedTexture = null;
    public Gender disguisedGender = null;
    public String disguisedForm = null;
    public String disguisedPalette = "none";
    public String disguisedParticlesResourceLocation = null;

    @Override
    public void beforeSwitch(PixelmonWrapper newPokemon) {
        if (newPokemon.bc.simulateMode) {
            return;
        }
        BattleParticipant participant = newPokemon.getParticipant();
        if (participant instanceof WildPixelmonParticipant) {
            return;
        }
        PixelmonWrapper disguised = null;
        for (int i = participant.allPokemon.length - 1; i >= 0; --i) {
            PixelmonWrapper pw = participant.allPokemon[i];
            if (pw.isFainted()) continue;
            if (!pw.getPokemonUUID().equals(newPokemon.getPokemonUUID())) {
                disguised = pw;
                this.disguisedTexture = disguised.getRealTextureNoCheck();
                if (this.disguisedTexture.equals(newPokemon.getRealTextureNoCheck())) {
                    this.disguisedTexture = null;
                    return;
                }
                this.disguisedPokemon = disguised.getSpecies();
                this.disguisedNickname = disguised.getNickname();
                this.disguisedGender = disguised.getGender();
                this.disguisedForm = disguised.getForm().getName();
                this.disguisedPalette = disguised.getInnerLink().getPalette().getName();
                this.disguisedParticlesResourceLocation = disguised.getInnerLink().getPalette().getParticleString();
                break;
            }
            return;
        }
        if (disguised == null) {
            return;
        }
        newPokemon.entity.transformServer(disguised.getSpecies(), this.disguisedForm, this.disguisedTexture, this.disguisedParticlesResourceLocation);
        if (newPokemon.getPlayerOwner() != null) {
            this.updateOwner(newPokemon);
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (newPokemon.entity != null && newPokemon.entity.transformedTexture == null && this.disguisedPokemon != null) {
            newPokemon.entity.transformServer(this.disguisedPokemon, this.disguisedForm, this.disguisedTexture, this.disguisedParticlesResourceLocation);
        }
    }

    @Override
    public void tookDamageTarget(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        this.fade(target);
    }

    @Override
    public void onAbilityLost(PixelmonWrapper pokemon) {
        this.fade(pokemon);
    }

    private void fade(PixelmonWrapper target) {
        if (this.disguisedPokemon != null && !target.bc.simulateMode) {
            this.disguisedPokemon = null;
            this.disguisedNickname = null;
            this.disguisedTexture = null;
            this.disguisedGender = null;
            this.disguisedForm = null;
            target.bc.sendToAll("pixelmon.abilities.illusion", target.getNickname());
            if (target.entity != null) {
                target.entity.cancelTransform();
            }
            target.bc.participants.stream().filter(PlayerParticipant.class::isInstance).forEach(participant -> ((PlayerParticipant)participant).updateOpponentPokemon());
            if (target.getPlayerOwner() != null) {
                this.updateOwner(target);
            }
        }
    }

    private void updateOwner(PixelmonWrapper pokemon) {
        if (pokemon.bc == null) {
            return;
        }
        NetworkHelper.sendPacket(new SetPokemonBattleDataPacket(PixelmonClientData.convertToGUI(pokemon.getTeamPokemon()), false), pokemon.getPlayerOwner());
        pokemon.bc.spectators.forEach(spectator -> spectator.sendMessage(new SetPokemonBattleDataPacket(PixelmonClientData.convertToGUI(pokemon.getTeamPokemon()), !spectator.watchedName.equals(pokemon.getOwnerName()))));
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper oldPokemon) {
        ServerPlayerEntity player = oldPokemon.getPlayerOwner();
        if (!oldPokemon.bc.simulateMode && player != null) {
            this.updateOwner(oldPokemon);
        }
    }

    @Override
    public void applyEndOfBattleEffect(PixelmonWrapper pokemon) {
        ServerPlayerEntity player = pokemon.getPlayerOwner();
        if (player != null) {
            this.updateOwner(pokemon);
        }
    }

    @Override
    public boolean needNewInstance() {
        return true;
    }

    @Override
    public boolean canBeIgnored() {
        return false;
    }
}

