/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events.blocks;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.MysteryBoxTileEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class MysteryBoxEvent
extends Event {
    private final MysteryBoxTileEntity box;
    private final BlockState blockState;

    protected MysteryBoxEvent(MysteryBoxTileEntity box, BlockState blockState) {
        this.box = box;
        this.blockState = blockState;
    }

    public MysteryBoxTileEntity getBox() {
        return this.box;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public static abstract class Tick
    extends MysteryBoxEvent {
        protected Tick(MysteryBoxTileEntity box, BlockState blockState) {
            super(box, blockState);
        }

        @Cancelable
        public static class AboutToClose
        extends Tick {
            public AboutToClose(MysteryBoxTileEntity box, BlockState blockState) {
                super(box, blockState);
            }
        }

        @Cancelable
        public static class DoSpawn
        extends Tick {
            private final PixelmonEntity pokemon;

            public DoSpawn(MysteryBoxTileEntity box, BlockState blockState, PixelmonEntity pokemon) {
                super(box, blockState);
                this.pokemon = pokemon;
            }

            public PixelmonEntity getPokemon() {
                return this.pokemon;
            }
        }

        @Cancelable
        public static class TrySpawn
        extends Tick {
            private int chance;

            public TrySpawn(MysteryBoxTileEntity box, BlockState blockState, int chance) {
                super(box, blockState);
                this.chance = chance;
            }

            public int getChance() {
                return this.chance;
            }

            public void setChance(int chance) {
                this.chance = chance;
            }

            public boolean rollChance() {
                return RandomHelper.getRandom().nextInt(this.chance) == 0;
            }
        }

        @Cancelable
        public static class Start
        extends Tick {
            public Start(MysteryBoxTileEntity box, BlockState blockState) {
                super(box, blockState);
            }
        }
    }

    public static class ComparatorPower
    extends MysteryBoxEvent {
        private int power;

        public ComparatorPower(MysteryBoxTileEntity box, BlockState blockState, int power) {
            super(box, blockState);
            this.power = power;
        }

        public int getPower() {
            return this.power;
        }

        public void setPower(int power) {
            this.power = power;
        }
    }

    @Cancelable
    public static class Feed
    extends MysteryBoxEvent {
        private final PlayerEntity player;
        private final ItemStack itemStack;
        private int scrapsLeft;

        public Feed(MysteryBoxTileEntity box, PlayerEntity player, BlockState blockState, ItemStack itemStack, int scrapsLeft) {
            super(box, blockState);
            this.player = player;
            this.itemStack = itemStack;
            this.scrapsLeft = scrapsLeft;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public int getScrapsLeft() {
            return this.scrapsLeft;
        }

        public void setScrapsLeft(int scrapsLeft) {
            this.scrapsLeft = scrapsLeft;
        }
    }

    public static abstract class Open
    extends MysteryBoxEvent {
        private final PlayerEntity player;
        private final ItemStack itemStack;

        protected Open(MysteryBoxTileEntity box, PlayerEntity player, BlockState blockState, ItemStack itemStack) {
            super(box, blockState);
            this.player = player;
            this.itemStack = itemStack;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public static class Post
        extends Open {
            private long lastOpenTime;
            private long openUntil;
            private long nextOpenTime;
            private int scrapsTotal;
            private int scrapsLeft;

            public Post(MysteryBoxTileEntity box, PlayerEntity player, BlockState blockState, ItemStack itemStack, long lastOpenTime, long openUntil, long nextOpenTime, int scrapsTotal, int scrapsLeft) {
                super(box, player, blockState, itemStack);
                this.lastOpenTime = lastOpenTime;
                this.openUntil = openUntil;
                this.nextOpenTime = nextOpenTime;
                this.scrapsTotal = scrapsTotal;
                this.scrapsLeft = scrapsLeft;
            }

            public long getLastOpenTime() {
                return this.lastOpenTime;
            }

            public void setLastOpenTime(long lastOpenTime) {
                this.lastOpenTime = lastOpenTime;
            }

            public long getOpenUntil() {
                return this.openUntil;
            }

            public void setOpenUntil(long openUntil) {
                this.openUntil = openUntil;
            }

            public long getNextOpenTime() {
                return this.nextOpenTime;
            }

            public void setNextOpenTime(long nextOpenTime) {
                this.nextOpenTime = nextOpenTime;
            }

            public int getScrapsTotal() {
                return this.scrapsTotal;
            }

            public void setScrapsTotal(int scrapsTotal) {
                this.scrapsTotal = scrapsTotal;
            }

            public int getScrapsLeft() {
                return this.scrapsLeft;
            }

            public void setScrapsLeft(int scrapsLeft) {
                this.scrapsLeft = scrapsLeft;
            }
        }

        @Cancelable
        public static class Pre
        extends Open {
            private boolean canOpen;

            public Pre(MysteryBoxTileEntity box, PlayerEntity player, BlockState blockState, ItemStack itemStack, boolean canOpen) {
                super(box, player, blockState, itemStack);
                this.canOpen = canOpen;
            }

            public boolean canOpen() {
                return this.canOpen;
            }

            public void setCanOpen(boolean canOpen) {
                this.canOpen = canOpen;
            }
        }
    }

    @Cancelable
    public static class Activate
    extends MysteryBoxEvent {
        private final PlayerEntity player;
        private final ItemStack itemStack;
        private Item acceptedItem;

        public Activate(MysteryBoxTileEntity box, PlayerEntity player, BlockState blockState, ItemStack itemStack, Item acceptedItem) {
            super(box, blockState);
            this.player = player;
            this.itemStack = itemStack;
            this.acceptedItem = acceptedItem;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public Item getAcceptedItem() {
            return this.acceptedItem;
        }

        public void setAcceptedItem(Item acceptedItem) {
            this.acceptedItem = acceptedItem;
        }
    }
}

