/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.ai;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.gen.Heightmap;

public class FlyingGoal
extends Goal {
    private static final long OWNER_FIND_INTERVAL = TimeUnit.SECONDS.toMillis(10L);
    private static final double OWNER_DISTANCE_TO_TAKEOFF = 100.0;
    private final PixelmonEntity pixelmon;
    private long nextOwnerCheckTime;
    private BlockPos currentFlightTarget;
    private int flightTicks = 0;
    private double takeOffSpeed = 0.0;
    private int targetHeight = 0;
    private boolean takingOff = false;
    private int ticksToRefresh;
    private int nextWingBeat = 10;
    private int wingBeatTick = 0;
    boolean lastChangeDirection;

    public FlyingGoal(PixelmonEntity entity) {
        this.pixelmon = entity;
        this.nextOwnerCheckTime = System.currentTimeMillis();
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.pixelmon.func_233570_aj_() || this.pixelmon.getOwner() != null || this.pixelmon.getFlyingParameters() == null) {
            return false;
        }
        return this.checkTakeOffConditions();
    }

    private boolean checkTakeOffConditions() {
        if (this.pixelmon.grounded) {
            return false;
        }
        if (this.pixelmon.getOwner() != null && this.pixelmon.getOwner().func_70089_S() && this.pixelmon.func_70068_e((Entity)this.pixelmon.getOwner()) > 100.0) {
            return true;
        }
        PlayerEntity nearest = this.pixelmon.field_70170_p.func_217362_a((Entity)this.pixelmon, 6.0);
        return nearest != null && nearest != this.pixelmon.getOwner() || Math.random() < 0.015;
    }

    public boolean func_75253_b() {
        return !this.pixelmon.func_233570_aj_();
    }

    public void func_75249_e() {
        this.takeOff();
    }

    public void func_75246_d() {
        ++this.flightTicks;
        if (this.flightTicks > 100 && this.takingOff || this.takingOff && this.pixelmon.func_226278_cu_() >= (double)this.targetHeight) {
            this.takingOff = false;
            this.flightTicks = 0;
        }
        if (this.takingOff) {
            this.pixelmon.func_213317_d(new Vector3d((double)((float)this.pixelmon.getPokemon().getStat(BattleStatsType.SPEED) / 500.0f), 0.0, 0.0));
            this.pixelmon.func_213293_j(this.pixelmon.func_213322_ci().func_82615_a(), this.takeOffSpeed, this.pixelmon.func_213322_ci().func_82616_c());
            return;
        }
        if (this.pixelmon.getOwner() != null) {
            this.lookForOwnerEntity();
        }
        this.checkForLandingSpot();
        AxisAlignedBB box = this.pixelmon.func_174813_aQ();
        BlockRayTraceResult mop = this.pixelmon.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.pixelmon.func_226277_ct_(), box.field_72338_b, this.pixelmon.func_226281_cx_()), new Vector3d(this.pixelmon.func_226277_ct_() + this.pixelmon.func_213322_ci().func_82615_a() * 100.0, box.field_72338_b, this.pixelmon.func_226281_cx_() + this.pixelmon.func_213322_ci().func_82616_c() * 100.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)this.pixelmon));
        if (mop.func_216346_c() == RayTraceResult.Type.MISS) {
            mop = this.pixelmon.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.pixelmon.func_226277_ct_(), box.field_72337_e, this.pixelmon.func_226281_cx_()), new Vector3d(this.pixelmon.func_226277_ct_() + this.pixelmon.func_213322_ci().func_82615_a() * 100.0, box.field_72337_e, this.pixelmon.func_226281_cx_() + this.pixelmon.func_213322_ci().func_82616_c() * 100.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)this.pixelmon));
        }
        if (this.hasLandingSpot()) {
            if (mop.func_216346_c() == RayTraceResult.Type.MISS) {
                double d0 = (double)this.currentFlightTarget.func_177958_n() + 0.5 - this.pixelmon.func_226277_ct_();
                double d1 = (double)this.currentFlightTarget.func_177956_o() + 0.1 - this.pixelmon.func_226278_cu_();
                double d2 = (double)this.currentFlightTarget.func_177952_p() + 0.5 - this.pixelmon.func_226281_cx_();
                this.pixelmon.func_213293_j(this.pixelmon.func_213322_ci().func_82615_a() + (Math.signum(d0) - this.pixelmon.func_213322_ci().func_82615_a()) * (double)0.1f, this.pixelmon.func_213322_ci().func_82617_b() + (Math.signum(d1) * (double)0.7f - this.pixelmon.func_213322_ci().func_82617_b()) * (double)0.1f, this.pixelmon.func_213322_ci().func_82616_c() + (Math.signum(d2) - this.pixelmon.func_213322_ci().func_82616_c()) * (double)0.1f);
                float f = (float)(Math.atan2(this.pixelmon.func_213322_ci().func_82616_c(), this.pixelmon.func_213322_ci().func_82615_a()) * 180.0 / Math.PI) - 90.0f;
                float f1 = MathHelper.func_76142_g((float)(f - this.pixelmon.field_70177_z));
                this.pixelmon.field_70177_z += f1;
            }
        } else {
            this.maintainFlight(mop.func_216346_c() != RayTraceResult.Type.MISS);
        }
        super.func_75246_d();
    }

    private void checkForLandingSpot() {
        if (!(this.currentFlightTarget == null || this.pixelmon.field_70170_p.func_175623_d(this.currentFlightTarget) && this.currentFlightTarget.func_177956_o() >= 1)) {
            this.currentFlightTarget = null;
        }
        if (this.currentFlightTarget == null || this.pixelmon.func_70681_au().nextInt(30) == 0) {
            this.currentFlightTarget = new BlockPos((int)(this.pixelmon.func_226277_ct_() + this.pixelmon.func_213322_ci().func_82615_a() * 200.0 + (double)this.pixelmon.func_70681_au().nextInt(10) - 5.0), 0, (int)(this.pixelmon.func_226281_cx_() + this.pixelmon.func_213322_ci().func_82616_c() * 200.0 + (double)this.pixelmon.func_70681_au().nextInt(10) - 5.0));
            this.currentFlightTarget = this.pixelmon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, this.currentFlightTarget);
            BlockState state = this.pixelmon.field_70170_p.func_180495_p(this.currentFlightTarget);
            Material m = state.func_185904_a();
            this.currentFlightTarget = this.currentFlightTarget.func_177984_a();
            if (this.pixelmon.getFlyingParameters() != null && !this.pixelmon.getFlyingParameters().getLandingMaterials().willLand(m) || !this.pixelmon.field_70170_p.func_175623_d(this.currentFlightTarget)) {
                this.currentFlightTarget = null;
            }
        }
    }

    private boolean hasLandingSpot() {
        return this.currentFlightTarget != null;
    }

    private void maintainFlight(boolean hasObstacle) {
        ++this.wingBeatTick;
        if (hasObstacle || this.wingBeatTick >= this.nextWingBeat) {
            this.pickDirection(hasObstacle);
            this.nextWingBeat = this.pixelmon.getFlyingParameters().getFlapRate() + (int)(Math.random() * 0.4 * (double)this.pixelmon.getFlyingParameters().getFlapRate() - 0.2 * (double)this.pixelmon.getFlyingParameters().getFlapRate());
            this.pixelmon.func_213352_e(new Vector3d(0.0, 0.0, (double)(4.0f + (float)this.pixelmon.getPokemon().getStat(BattleStatsType.SPEED) / 100.0f * this.pixelmon.getFlyingParameters().getFlySpeedModifier())));
            this.pixelmon.func_213293_j(this.pixelmon.func_213322_ci().func_82615_a(), (double)(this.pixelmon.getFlyingParameters().getFlapRate() + 1) * 0.01, this.pixelmon.func_213322_ci().func_82616_c());
            this.wingBeatTick = 0;
        }
    }

    public void pickDirection(boolean useLastChangeDirection) {
        double rotAmt;
        if (useLastChangeDirection) {
            rotAmt = this.pixelmon.func_70681_au().nextInt(5) + 5;
            if (this.lastChangeDirection) {
                rotAmt *= -1.0;
            }
        } else {
            rotAmt = this.pixelmon.func_70681_au().nextInt(10) - 5;
            this.lastChangeDirection = rotAmt > 0.0;
        }
        this.pixelmon.field_70177_z = (float)((double)this.pixelmon.field_70177_z + rotAmt);
    }

    private void lookForOwnerEntity() {
        if (this.pixelmon.getOwner() != null && System.currentTimeMillis() > this.nextOwnerCheckTime) {
            this.nextOwnerCheckTime = System.currentTimeMillis() + OWNER_FIND_INTERVAL;
            this.currentFlightTarget = new BlockPos((int)this.pixelmon.getOwner().func_226277_ct_(), (int)this.pixelmon.getOwner().func_226278_cu_() + 1, (int)this.pixelmon.getOwner().func_226281_cx_());
        }
    }

    private void takeOff() {
        this.pixelmon.setFlying(true);
        this.takingOff = true;
        this.flightTicks = 0;
        this.targetHeight = (int)this.pixelmon.func_226278_cu_() + RandomHelper.getRandomNumberBetween(this.pixelmon.getFlyingParameters().getFlyHeightMin(), this.pixelmon.getFlyingParameters().getFlyHeightMax());
        this.pixelmon.field_70170_p.func_184148_a(null, this.pixelmon.func_226277_ct_(), this.pixelmon.func_226278_cu_(), this.pixelmon.func_226281_cx_(), (SoundEvent)SoundRegistration.TAKE_OFF.get(), SoundCategory.NEUTRAL, 0.8f, 1.0f);
        this.takeOffSpeed = 0.012 + (double)((float)this.pixelmon.getPokemon().getStat(BattleStatsType.SPEED) / 600.0f);
    }
}

