/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Lifecycle;
import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.PixelmonEventHandler;
import com.pixelmonmod.pixelmon.advancements.PixelmonAdvancements;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.daycare.PixelmonDayCare;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.events.init.PixelmonInitEvent;
import com.pixelmonmod.pixelmon.api.pokemon.egg.BreedingLogicProxy;
import com.pixelmonmod.pixelmon.api.pokemon.egg.impl.PixelmonBreedingLogic;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonTypeRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonEggGroups;
import com.pixelmonmod.pixelmon.api.registries.PixelmonTicketType;
import com.pixelmonmod.pixelmon.api.storage.PixelmonStorageManager;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.test.PixelmonUnitTesting;
import com.pixelmonmod.pixelmon.api.util.helpers.ReflectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.comm.PacketRegistry;
import com.pixelmonmod.pixelmon.command.PixelmonCommands;
import com.pixelmonmod.pixelmon.init.registry.BlockRegistration;
import com.pixelmonmod.pixelmon.init.registry.ContainerRegistration;
import com.pixelmonmod.pixelmon.init.registry.EffectRegistration;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.init.registry.ItemRegistration;
import com.pixelmonmod.pixelmon.init.registry.PaintingTypeRegistry;
import com.pixelmonmod.pixelmon.init.registry.ParticleRegistration;
import com.pixelmonmod.pixelmon.init.registry.PixelmonWoodType;
import com.pixelmonmod.pixelmon.init.registry.RecipeTypeRegistration;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.listener.UnbattleableListener;
import com.pixelmonmod.pixelmon.listener.UncatchableListener;
import com.pixelmonmod.pixelmon.listener.UndexableListener;
import com.pixelmonmod.pixelmon.network.SimpleChannel;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.storage.adapters.PixelmonFileAdapter;
import com.pixelmonmod.pixelmon.storage.schedulers.PixelmonStorageAsyncScheduler;
import com.pixelmonmod.pixelmon.storage.schedulers.PixelmonStorageStandardScheduler;
import com.pixelmonmod.pixelmon.world.dimension.DimensionRegistration;
import com.pixelmonmod.pixelmon.world.dimension.PixelmonBiomeGeneration;
import com.pixelmonmod.pixelmon.world.generation.BlockStateProviderTypes;
import com.pixelmonmod.pixelmon.world.generation.FoliageRegistration;
import com.pixelmonmod.pixelmon.world.generation.PixelmonFeature;
import com.pixelmonmod.pixelmon.world.generation.PixelmonFeatures;
import com.pixelmonmod.pixelmon.world.generation.TreeDecoratorTypes;
import com.pixelmonmod.pixelmon.world.generation.WorldGenRegistration;
import com.pixelmonmod.pixelmon.world.structure.PixelmonStructures;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.WoodType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.command.CommandSource;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.network.NetworkInstance;
import net.minecraftforge.fml.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="pixelmon")
public class Pixelmon {
    public static final String MODID = "pixelmon";
    public static final String NAME = "Pixelmon";
    public static final String VERSION = "9.1.11";
    public static final IEventBus EVENT_BUS = BusBuilder.builder().build();
    public static final Logger LOGGER = LogManager.getLogger((String)"Pixelmon");
    public static final ExecutorService POOL = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("pixelmon_common_%d").build());
    public static final boolean LOG_PACKETS = Boolean.parseBoolean(System.getProperty("pixelmon.log_packets"));
    public static final boolean LOG_BATTLE_SCREEN_MODE = Boolean.parseBoolean(System.getProperty("pixelmon.client.log_battle_mode"));
    public static Pixelmon instance;
    public static CommonProxy proxy;
    public static File modDirectory;
    public static SimpleChannel network;
    public static boolean freeze;
    public static boolean canSendOutPokemon;

    public Pixelmon() {
        Pixelmon.fixLifecycle();
        PixelmonUnitTesting.init();
        instance = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(Pixelmon::init);
        bus.addListener(CommonProxy::init);
        bus.addListener(Pixelmon::postInit);
        bus.addListener(CommonProxy::postInit);
        bus.addListener(EntityRegistration::registerAttributes);
        bus.addListener(Pixelmon::onClientLoaded);
        PixelmonTicketType.init();
        PaintingTypeRegistry.PAINTINGS.register(bus);
        ItemRegistration.ITEMS.register(bus);
        BlockRegistration.BLOCKS.register(bus);
        EffectRegistration.EFFECTS.register(bus);
        DimensionRegistration.SURFACE_BUILDERS.register(bus);
        DimensionRegistration.WORLD_CARVERS.register(bus);
        TileEntityRegistration.TILE_ENTITIES.register(bus);
        EntityRegistration.ENTITIES.register(bus);
        ParticleRegistration.PARTICLES_TYPES.register(bus);
        ContainerRegistration.CONTAINERS.register(bus);
        FoliageRegistration.FOLIAGE_PLACER_TYPES.register(bus);
        TreeDecoratorTypes.TREE_DECORATOR_TYPES.register(bus);
        BlockStateProviderTypes.BLOCK_STATE_PROVIDER_TYPE.register(bus);
        DimensionRegistration.BIOMES.register(bus);
        SoundRegistration.SOUNDS.register(bus);
        PixelmonFeature.FEATURES.register(bus);
        RecipeTypeRegistration.register(bus);
        PixelmonStructures.STRUCTURE_REGISTRY.register(bus);
        PixelmonEggGroups.init();
        new UnbattleableListener();
        new UncatchableListener();
        new UndexableListener();
        PixelmonDataSerializers.bootstrap();
        Class<PixelmonFeatures> pixelmonFeaturesClass = PixelmonFeatures.class;
        Class<WorldGenRegistration> worldGenRegistrationClass = WorldGenRegistration.class;
    }

    private static void fixLifecycle() {
        try {
            Field STABLE = Lifecycle.class.getDeclaredField("STABLE");
            Field EXPERIMENTAL = Lifecycle.class.getDeclaredField("EXPERIMENTAL");
            STABLE.setAccessible(true);
            EXPERIMENTAL.setAccessible(true);
            ReflectionHelper.flipVariableFinality(EXPERIMENTAL, () -> {
                try {
                    EXPERIMENTAL.set(null, STABLE.get(null));
                    LOGGER.info("Patched lifecycle fields.");
                }
                catch (Exception e) {
                    LOGGER.error("Failed to set lifecycle fields!");
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Failed to patch lifecycle fields!");
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        LOGGER.info("Loading Pixelmon version 9.1.11");
        try {
            Method method = NetworkRegistry.class.getDeclaredMethod("createInstance", ResourceLocation.class, Supplier.class, Predicate.class, Predicate.class);
            method.setAccessible(true);
            network = new SimpleChannel((NetworkInstance)method.invoke(null, ResourceLocationHelper.of(MODID, "main"), () -> VERSION, serverVersion -> {
                if (serverVersion.equalsIgnoreCase(NetworkRegistry.ABSENT) || serverVersion.equalsIgnoreCase(NetworkRegistry.ACCEPTVANILLA)) {
                    return true;
                }
                return VERSION.equals(serverVersion);
            }, VERSION::equals));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        MinecraftForge.EVENT_BUS.register((Object)instance);
        PacketRegistry.registerPackets();
        modDirectory = new File("");
        PixelmonConfigProxy.reload();
        PixelmonAdvancements.init();
        PixelmonEventHandler eventHandler = new PixelmonEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        EVENT_BUS.register((Object)eventHandler);
        PixelmonStorageManager storageManager = new PixelmonStorageManager(PixelmonConfigProxy.getStorage().isUseAsyncSaving() ? new PixelmonStorageAsyncScheduler() : new PixelmonStorageStandardScheduler(), new PixelmonFileAdapter());
        PixelmonBreedingLogic pixelmonBreedingLogic = new PixelmonBreedingLogic();
        PixelmonInitEvent initEvent = new PixelmonInitEvent(storageManager, pixelmonBreedingLogic);
        EVENT_BUS.post((Event)initEvent);
        RibbonTypeRegistry.bootstrap();
        if (!StorageProxy.hasImplementation()) {
            StorageProxy.setStorageManager(initEvent.getStorageManager());
        }
        if (!BankAccountProxy.hasImplementation()) {
            BankAccountProxy.setAccountManager(initEvent.getBankAccountManager());
        }
        if (!BreedingLogicProxy.hasImplementation()) {
            BreedingLogicProxy.setInstance(initEvent.getBreedingLogic());
        }
        MinecraftForge.EVENT_BUS.register((Object)storageManager);
        MinecraftForge.EVENT_BUS.register((Object)storageManager.getSaveScheduler());
        event.enqueueWork(() -> {
            PixelmonStructures.setupStuctures();
            WoodType.func_227047_a_((WoodType)PixelmonWoodType.BLUE_BERRY_WOOD);
            WoodType.func_227047_a_((WoodType)PixelmonWoodType.GREEN_BERRY_WOOD);
            WoodType.func_227047_a_((WoodType)PixelmonWoodType.PINK_BERRY_WOOD);
            WoodType.func_227047_a_((WoodType)PixelmonWoodType.PURPLE_BERRY_WOOD);
            WoodType.func_227047_a_((WoodType)PixelmonWoodType.RED_BERRY_WOOD);
            WoodType.func_227047_a_((WoodType)PixelmonWoodType.YELLOW_BERRY_WOOD);
            WoodType.func_227047_a_((WoodType)PixelmonWoodType.ULTRA_JUNGLE_WOOD);
            WoodType.func_227047_a_((WoodType)PixelmonWoodType.ULTRA_ELM_WOOD);
            WoodType.func_227047_a_((WoodType)PixelmonWoodType.ULTRA_GINGKO_WOOD);
            Atlases.field_228750_i_.put(PixelmonWoodType.ULTRA_JUNGLE_WOOD, Atlases.func_228773_a_((WoodType)PixelmonWoodType.ULTRA_JUNGLE_WOOD));
            Atlases.field_228750_i_.put(PixelmonWoodType.ULTRA_ELM_WOOD, Atlases.func_228773_a_((WoodType)PixelmonWoodType.ULTRA_ELM_WOOD));
            Atlases.field_228750_i_.put(PixelmonWoodType.ULTRA_GINGKO_WOOD, Atlases.func_228773_a_((WoodType)PixelmonWoodType.ULTRA_GINGKO_WOOD));
            PixelmonBiomeGeneration.addBiomeGeneration();
        });
    }

    private static void networkReflection() {
        try {
            Method method = NetworkRegistry.class.getDeclaredMethod("createInstance", ResourceLocation.class, Supplier.class, Predicate.class, Predicate.class);
            method.setAccessible(true);
            network = new SimpleChannel((NetworkInstance)method.invoke(null, ResourceLocationHelper.of(MODID, "main"), () -> VERSION, serverVersion -> {
                if (serverVersion.equalsIgnoreCase(NetworkRegistry.ABSENT) || serverVersion.equalsIgnoreCase(NetworkRegistry.ACCEPTVANILLA)) {
                    return true;
                }
                return VERSION.equals(serverVersion);
            }, VERSION::equals));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void postInit(FMLLoadCompleteEvent event) {
    }

    @SubscribeEvent
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> StorageProxy::clearAll);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        new PixelmonCommands((CommandDispatcher<CommandSource>)event.getDispatcher(), event.getEnvironment());
    }

    @SubscribeEvent
    public void onServerStart(FMLServerStartedEvent event) {
        if (PixelmonSpawning.coordinator == null) {
            PixelmonSpawning.startTrackingSpawner();
        }
        PixelmonDayCare.init();
        ResourcePackList resourcepacklist = event.getServer().func_195561_aH();
        resourcepacklist.func_198983_a();
        List datapacks = resourcepacklist.func_198980_d().stream().map(ResourcePackInfo::func_195790_f).collect(Collectors.toList());
        LOGGER.info("Datapacks found: " + String.join((CharSequence)",", datapacks));
    }

    @SubscribeEvent
    public void onServerStopping(FMLServerStoppingEvent event) {
        PixelmonSpawning.coordinator.deactivate();
        PixelmonSpawning.coordinator = null;
        StorageProxy.getSaveScheduler().onServerStopping(event);
    }

    @SubscribeEvent
    public static void onClientLoaded(FMLClientSetupEvent event) {
        try {
            Minecraft minecraft = (Minecraft)event.getMinecraftSupplier().get();
            InputStream inputstream = minecraft.func_195541_I().func_195746_a().func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation(MODID, "textures/icon_16x16.png"));
            InputStream inputstream1 = minecraft.func_195541_I().func_195746_a().func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation(MODID, "textures/icon_32x32.png"));
            ((Minecraft)event.getMinecraftSupplier().get()).func_228018_at_().func_216529_a(inputstream, inputstream1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getVersion() {
        return VERSION;
    }

    public static boolean isClient() {
        return Thread.currentThread().getThreadGroup() == SidedThreadGroups.CLIENT;
    }

    public static boolean isDevEnvironment() {
        return !FMLLoader.isProduction();
    }

    static {
        freeze = false;
        canSendOutPokemon = true;
    }
}

