/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.requirement;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.Specification;
import com.pixelmonmod.api.SpecificationFactory;
import com.pixelmonmod.api.requirement.Requirement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AbstractRecursiveRequirement<A, B>
implements Requirement<A, B, List<Requirement<A, B, ?>>> {
    private final Set<String> keys;
    private final Class<? extends Specification<A, B>> clazz;
    protected List<Requirement<A, B, ?>> requirements;

    public AbstractRecursiveRequirement(Class<? extends Specification<A, B>> clazz, Set<String> keys) {
        this.clazz = clazz;
        this.keys = keys;
    }

    public AbstractRecursiveRequirement(Class<? extends Specification<A, B>> clazz, Set<String> keys, List<Requirement<A, B, ?>> requirements) {
        this(clazz, keys);
        this.requirements = requirements;
    }

    @Override
    public List<String> getAliases() {
        return Lists.newArrayList(this.keys);
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public boolean shouldContinue() {
        return false;
    }

    @Override
    public boolean fits(String spec) {
        for (String key : this.keys) {
            if (!spec.contains(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Requirement<A, B, ?>> create(String spec) {
        for (String key : this.keys) {
            if (!spec.contains(key)) continue;
            String[] args = spec.split(key);
            if (args.length == 0) {
                return Collections.emptyList();
            }
            ArrayList requirements = Lists.newArrayList();
            for (String arg : args) {
                this.requirements.addAll(SpecificationFactory.requirements(this.clazz, arg));
            }
            return Collections.singletonList(this.createInstance(requirements));
        }
        return Collections.emptyList();
    }

    @Override
    public List<Requirement<A, B, ?>> getValue() {
        return this.requirements;
    }
}

