/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.loadingrequirement.v2.requirements.gui;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.LoadingRequirement;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;

public class IsGuiScaleRequirement
extends LoadingRequirement {
    public IsGuiScaleRequirement() {
        super("fancymenu_loading_requirement_is_gui_scale");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(String value) {
        List<String> l;
        if (value != null && !(l = this.parseValues(value)).isEmpty()) {
            for (String s : l) {
                if (IsGuiScaleRequirement.checkForGuiScale(s)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<String> parseValues(String value) {
        ArrayList<String> l1 = new ArrayList<String>();
        if (value.contains(",")) {
            l1.addAll(Arrays.asList(value.replace(" ", "").split(",")));
        } else if (value.length() > 0) {
            l1.add(value.replace(" ", ""));
        }
        ArrayList<String> l = new ArrayList<String>();
        for (String s : l1) {
            String v;
            if (MathUtils.isDouble((String)s)) {
                l.add("double:" + s);
                continue;
            }
            if (s.startsWith(">")) {
                v = s.split(">", 2)[1];
                if (!MathUtils.isDouble((String)v)) continue;
                l.add("biggerthan:" + v);
                continue;
            }
            if (!s.startsWith("<") || !MathUtils.isDouble((String)(v = s.split("<", 2)[1]))) continue;
            l.add("smallerthan:" + v);
        }
        return l;
    }

    protected static boolean checkForGuiScale(String condition) {
        double windowScale = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        if (condition.startsWith("double:")) {
            String value = condition.replace("double:", "");
            double valueScale = Double.parseDouble(value);
            return windowScale == valueScale;
        }
        if (condition.startsWith("biggerthan:")) {
            String value = condition.replace("biggerthan:", "");
            double valueScale = Double.parseDouble(value);
            return windowScale > valueScale;
        }
        if (condition.startsWith("smallerthan:")) {
            String value = condition.replace("smallerthan:", "");
            double valueScale = Double.parseDouble(value);
            return windowScale < valueScale;
        }
        return false;
    }

    @Override
    public String getDisplayName() {
        return Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.guiscale", (String[])new String[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.guiscale.desc", (String[])new String[0]), (String)"%n%"));
    }

    @Override
    public String getCategory() {
        return Locals.localize((String)"fancymenu.editor.loading_requirement.category.gui", (String[])new String[0]);
    }

    @Override
    public String getValueDisplayName() {
        return Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.guiscale.valuename", (String[])new String[0]);
    }

    @Override
    public String getValuePreset() {
        return ">2.0";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }
}

