/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal;

import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.LoadingRequirement;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.LoadingRequirementRegistry;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementGroup;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import java.util.ArrayList;
import java.util.List;

public class LoadingRequirementInstance {
    public LoadingRequirementContainer parent;
    public LoadingRequirement requirement;
    public String value;
    public LoadingRequirementGroup group;
    public RequirementMode mode;
    public String requirementId = MenuCustomization.generateRandomActionId();

    public LoadingRequirementInstance(LoadingRequirement requirement, String value, RequirementMode mode, LoadingRequirementContainer parent) {
        this.parent = parent;
        this.requirement = requirement;
        this.value = value;
        this.mode = mode;
    }

    public boolean requirementMet() {
        boolean met = this.requirement.isRequirementMet(this.value != null ? PlaceholderParser.replacePlaceholders(this.value) : null);
        if (this.mode == RequirementMode.IF_NOT) {
            return !met;
        }
        return met;
    }

    public static List<String> serializeRequirementInstance(LoadingRequirementInstance instance) {
        ArrayList<String> l = new ArrayList<String>();
        String key = "[loading_requirement:" + instance.requirement.getIdentifier() + "][requirement_mode:" + instance.mode.name + "]";
        if (instance.group != null) {
            key = key + "[group:" + instance.group.identifier + "]";
        }
        key = key + "[req_id:" + instance.requirementId + "]";
        l.add(key);
        if (instance.requirement.hasValue() && instance.value != null) {
            l.add(instance.value);
        } else {
            l.add("");
        }
        return l;
    }

    public static LoadingRequirementInstance deserializeRequirementInstance(String key, String value, LoadingRequirementContainer parent) {
        String modeName;
        RequirementMode mode;
        String reqId;
        LoadingRequirement req;
        if (key.startsWith("[loading_requirement:") && (req = LoadingRequirementRegistry.getRequirement(reqId = key.split(":", 2)[1].split("\\]", 2)[0])) != null && key.contains("[requirement_mode:") && (mode = RequirementMode.getByName(modeName = key.split("\\[requirement_mode:", 2)[1].split("\\]", 2)[0])) != null) {
            LoadingRequirementGroup group = null;
            if (key.contains("[group:")) {
                String groupId = key.split("\\[group:", 2)[1].split("\\]", 2)[0];
                if (!parent.groupExists(groupId)) {
                    parent.createAndAddGroup(groupId, LoadingRequirementGroup.GroupMode.AND);
                }
                group = parent.getGroup(groupId);
            }
            if (key.contains("[req_id:")) {
                String id = key.split("\\[req_id:", 2)[1].split("\\]", 2)[0];
                LoadingRequirementInstance instance = new LoadingRequirementInstance(req, value, mode, parent);
                instance.requirementId = id;
                instance.group = group;
                return instance;
            }
        }
        return null;
    }

    public static enum RequirementMode {
        IF("if"),
        IF_NOT("if_not");

        public final String name;

        private RequirementMode(String name) {
            this.name = name;
        }

        public static RequirementMode getByName(String name) {
            for (RequirementMode m : RequirementMode.values()) {
                if (!m.name.equals(name)) continue;
                return m;
            }
            return null;
        }
    }
}

