/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.items.playerentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.api.item.CustomizationItem;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationHelper;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.CapeWebTextureResourceLocation;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.PlayerEntityCustomizationItemContainer;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.PlayerEntityElementCache;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.PlayerEntityUtils;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.SkinExternalTextureResourceLocation;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.SkinWebTextureResourceLocation;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.render.PlayerEntityItemRenderer;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.render.PlayerEntityProperties;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.StringTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerEntityCustomizationItem
extends CustomizationItem {
    private static final Logger LOGGER = LogManager.getLogger();
    public PlayerEntityItemRenderer normalRenderer = new PlayerEntityItemRenderer(false);
    public PlayerEntityItemRenderer slimRenderer = new PlayerEntityItemRenderer(true);
    public volatile boolean copyClientPlayer = false;
    public volatile String playerName = "Steve";
    public boolean showPlayerName = true;
    public boolean hasParrotOnShoulder = false;
    public boolean parrotOnLeftShoulder = false;
    public boolean crouching = false;
    public boolean isBaby = false;
    public int scale = 30;
    public volatile boolean slim = false;
    public volatile boolean autoSkin = false;
    public volatile boolean autoCape = false;
    public volatile String skinUrl;
    protected volatile String oldSkinUrl = null;
    public volatile String skinPath;
    public volatile String capeUrl;
    protected volatile String oldCapeUrl = null;
    public volatile String capePath;
    protected volatile ResourceLocation currentSkinLocation = null;
    protected volatile ResourceLocation currentCapeLocation = null;
    public boolean followMouse = true;
    public float bodyRotationX;
    public float bodyRotationY;
    public float headRotationX;
    public float headRotationY;

    public PlayerEntityCustomizationItem(CustomizationItemContainer parentContainer, PropertiesSection item) {
        super(parentContainer, item);
        String bodyrotY;
        String bodyrotX;
        String rotY;
        String rotX;
        String followMouseString;
        String showName;
        String crouching;
        String isBabyString;
        String parrotLeftShoulderString;
        String hasParrotString;
        String scaleString;
        String copyClientPlayerString;
        if (PlayerEntityCustomizationItem.isEditorActive()) {
            PlayerEntityCustomizationItemContainer.ELEMENT_CACHE.clear();
        }
        if ((copyClientPlayerString = item.getEntryValue("copy_client_player")) != null && copyClientPlayerString.equals("true")) {
            this.setCopyClientPlayer(true);
        }
        if (!this.copyClientPlayer) {
            String slim;
            String autoCapeString;
            String autoSkinString;
            String playerNameString = item.getEntryValue("playername");
            if (playerNameString != null) {
                this.setPlayerName(playerNameString, true);
            }
            if ((autoSkinString = item.getEntryValue("auto_skin")) != null && autoSkinString.equalsIgnoreCase("true")) {
                this.autoSkin = true;
            }
            if ((autoCapeString = item.getEntryValue("auto_cape")) != null && autoCapeString.equalsIgnoreCase("true")) {
                this.autoCape = true;
            }
            if ((slim = item.getEntryValue("slim")) != null && slim.replace(" ", "").equalsIgnoreCase("true")) {
                this.slim = true;
            }
            if (!this.autoSkin) {
                this.skinUrl = item.getEntryValue("skinurl");
                if (this.skinUrl != null) {
                    this.setSkinTextureBySource(this.skinUrl, true);
                }
                this.skinPath = PlayerEntityCustomizationItem.fixBackslashPath(item.getEntryValue("skinpath"));
                if (this.skinPath != null && this.skinUrl == null) {
                    this.setSkinTextureBySource(this.skinPath, false);
                }
            } else {
                this.setSkinByPlayerName();
            }
            if (!this.autoCape) {
                this.capeUrl = item.getEntryValue("capeurl");
                if (this.capeUrl != null) {
                    this.setCapeTextureBySource(this.capeUrl, true);
                }
                this.capePath = PlayerEntityCustomizationItem.fixBackslashPath(item.getEntryValue("capepath"));
                if (this.capePath != null && this.capeUrl == null) {
                    this.setCapeTextureBySource(this.capePath, false);
                }
            } else {
                this.setCapeByPlayerName();
            }
        }
        if ((scaleString = item.getEntryValue("scale")) != null && MathUtils.isDouble((String)scaleString)) {
            this.scale = (int)Double.parseDouble(scaleString);
        }
        if ((hasParrotString = item.getEntryValue("parrot")) != null && hasParrotString.replace(" ", "").equalsIgnoreCase("true")) {
            this.setHasParrotOnShoulder(true, false);
        }
        if ((parrotLeftShoulderString = item.getEntryValue("parrot_left_shoulder")) != null && parrotLeftShoulderString.replace(" ", "").equalsIgnoreCase("true")) {
            this.setHasParrotOnShoulder(this.hasParrotOnShoulder, true);
        }
        if ((isBabyString = item.getEntryValue("is_baby")) != null && isBabyString.replace(" ", "").equalsIgnoreCase("true")) {
            this.setIsBaby(true);
        }
        if ((crouching = item.getEntryValue("crouching")) != null && crouching.replace(" ", "").equalsIgnoreCase("true")) {
            this.setCrouching(true);
        }
        if ((showName = item.getEntryValue("showname")) != null && showName.replace(" ", "").equalsIgnoreCase("false")) {
            this.setShowPlayerName(false);
        }
        if ((followMouseString = item.getEntryValue("follow_mouse")) != null && followMouseString.replace(" ", "").equalsIgnoreCase("false")) {
            this.followMouse = false;
        }
        if ((rotX = item.getEntryValue("headrotationx")) != null && MathUtils.isFloat((String)(rotX = rotX.replace(" ", "")))) {
            this.headRotationX = Float.parseFloat(rotX);
        }
        if ((rotY = item.getEntryValue("headrotationy")) != null && MathUtils.isFloat((String)(rotY = rotY.replace(" ", "")))) {
            this.headRotationY = Float.parseFloat(rotY);
        }
        if ((bodyrotX = item.getEntryValue("bodyrotationx")) != null && MathUtils.isFloat((String)(bodyrotX = bodyrotX.replace(" ", "")))) {
            this.bodyRotationX = Float.parseFloat(bodyrotX);
        }
        if ((bodyrotY = item.getEntryValue("bodyrotationy")) != null && MathUtils.isFloat((String)(bodyrotY = bodyrotY.replace(" ", "")))) {
            this.bodyRotationY = Float.parseFloat(bodyrotY);
        }
        if (!PlayerEntityCustomizationItem.isEditorActive()) {
            PlayerEntityCustomizationItemContainer.ELEMENT_CACHE.put(this.actionId, this);
        }
    }

    public void setCopyClientPlayer(boolean copyClientPlayer) {
        if (copyClientPlayer) {
            this.copyClientPlayer = true;
            this.autoCape = false;
            this.autoSkin = false;
            this.slim = false;
            this.setPlayerName(Minecraft.func_71410_x().func_110432_I().func_111285_a(), true);
            this.setSkinByPlayerName();
            this.setCapeByPlayerName();
        } else {
            this.copyClientPlayer = false;
            this.setSkinTextureBySource(null, false);
        }
    }

    public void setPlayerName(String playerName, boolean updatePlayerNameField) {
        if (playerName == null) {
            playerName = "Steve";
        }
        if (updatePlayerNameField) {
            this.playerName = playerName;
        }
        playerName = PlaceholderParser.replacePlaceholders(playerName);
        this.normalRenderer.properties.displayName = new StringTextComponent(playerName);
        this.slimRenderer.properties.displayName = new StringTextComponent(playerName);
    }

    public void setShowPlayerName(boolean showName) {
        this.showPlayerName = showName;
        this.normalRenderer.properties.showDisplayName = showName;
        this.slimRenderer.properties.showDisplayName = showName;
    }

    public void setHasParrotOnShoulder(boolean hasParrot, boolean onLeftShoulder) {
        this.hasParrotOnShoulder = hasParrot;
        this.parrotOnLeftShoulder = onLeftShoulder;
        this.normalRenderer.properties.hasParrotOnShoulder = hasParrot;
        this.slimRenderer.properties.hasParrotOnShoulder = hasParrot;
        this.normalRenderer.properties.parrotOnLeftShoulder = onLeftShoulder;
        this.slimRenderer.properties.parrotOnLeftShoulder = onLeftShoulder;
    }

    public void setCrouching(boolean crouching) {
        this.crouching = crouching;
        this.normalRenderer.properties.crouching = crouching;
        this.slimRenderer.properties.crouching = crouching;
    }

    public void setIsBaby(boolean isBaby) {
        this.isBaby = isBaby;
        this.normalRenderer.properties.isBaby = isBaby;
        this.slimRenderer.properties.isBaby = isBaby;
    }

    public void setCapeByPlayerName() {
        PlayerEntityCustomizationItem cachedInstance = PlayerEntityCustomizationItemContainer.ELEMENT_CACHE.get(this.actionId);
        if (cachedInstance != null && cachedInstance.currentCapeLocation != null) {
            this.setCapeTextureLocation(cachedInstance.currentCapeLocation);
            return;
        }
        new Thread(() -> {
            try {
                if (this.playerName != null) {
                    String playerCapeUrl = PlayerEntityUtils.getCapeURL(this.playerName);
                    if (playerCapeUrl != null) {
                        this.setCapeTextureBySource(playerCapeUrl, true);
                    } else {
                        this.setCapeTextureBySource(null, false);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void setSkinByPlayerName() {
        PlayerEntityCustomizationItem cachedInstance = PlayerEntityCustomizationItemContainer.ELEMENT_CACHE.get(this.actionId);
        if (cachedInstance != null && cachedInstance.currentSkinLocation != null) {
            this.setSkinTextureLocation(cachedInstance.currentSkinLocation);
            return;
        }
        new Thread(() -> {
            try {
                if (this.playerName != null) {
                    String playerSkinUrl = PlayerEntityUtils.getSkinURL(this.playerName);
                    if (playerSkinUrl != null) {
                        this.setSkinTextureBySource(playerSkinUrl, true);
                        if (!PlayerEntityElementCache.isSlimSkinInfoCached(this.playerName)) {
                            this.slim = PlayerEntityUtils.hasSlimSkin(this.playerName);
                            PlayerEntityElementCache.cacheIsSlimSkin(this.playerName, this.slim);
                        } else {
                            this.slim = PlayerEntityElementCache.getIsSlimSkin(this.playerName);
                        }
                    } else {
                        this.setSkinTextureBySource(null, false);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void setSkinTextureBySource(String sourcePathOrLink, boolean web) {
        PlayerEntityCustomizationItem cachedInstance = PlayerEntityCustomizationItemContainer.ELEMENT_CACHE.get(this.actionId);
        if (cachedInstance != null && cachedInstance.currentSkinLocation != null) {
            this.setSkinTextureLocation(cachedInstance.currentSkinLocation);
            return;
        }
        if (sourcePathOrLink != null) {
            if (web) {
                new Thread(() -> {
                    try {
                        String url = StringUtils.convertFormatCodes((String)PlaceholderParser.replacePlaceholders(sourcePathOrLink), (String)"\u00a7", (String)"&");
                        this.skinUrl = sourcePathOrLink;
                        this.oldSkinUrl = url;
                        this.skinPath = null;
                        String sha1 = PlayerEntityElementCache.calculateWebSourceSHA1(url);
                        if (sha1 != null) {
                            if (!PlayerEntityElementCache.isSkinCached(sha1)) {
                                SkinWebTextureResourceLocation sr = new SkinWebTextureResourceLocation(url);
                                sr.downloadTexture();
                                if (sr.getDownloadedTexture() == null) {
                                    return;
                                }
                                CustomizationHelper.runTaskInMainThread(() -> sr.loadTexture());
                                long start = System.currentTimeMillis();
                                while (sr.getResourceLocation() == null) {
                                    long now = System.currentTimeMillis();
                                    if (start + 15000L <= now) {
                                        LOGGER.error("[FANCYMENU] Failed to load web skin texture for Player Entity element!");
                                        return;
                                    }
                                    Thread.sleep(100L);
                                }
                                PlayerEntityElementCache.cacheSkin(sha1, sr.getResourceLocation());
                                this.setSkinTextureLocation(sr.getResourceLocation());
                            } else {
                                this.setSkinTextureLocation(PlayerEntityElementCache.getSkin(sha1));
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }).start();
            } else {
                new Thread(() -> {
                    try {
                        String sha1;
                        String path = MenuCustomization.getAbsoluteGameDirectoryPath(sourcePathOrLink);
                        File f = new File(path);
                        if (f.isFile() && (f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png")) && (sha1 = PlayerEntityElementCache.calculateSHA1(f)) != null) {
                            if (!PlayerEntityElementCache.isSkinCached(sha1)) {
                                SkinExternalTextureResourceLocation sr = new SkinExternalTextureResourceLocation(path);
                                CustomizationHelper.runTaskInMainThread(() -> sr.loadTexture());
                                long start = System.currentTimeMillis();
                                while (sr.getResourceLocation() == null) {
                                    long now = System.currentTimeMillis();
                                    if (start + 15000L <= now) {
                                        LOGGER.error("[FANCYMENU] Failed to load local skin texture for Player Entity element!");
                                        return;
                                    }
                                    Thread.sleep(100L);
                                }
                                PlayerEntityElementCache.cacheSkin(sha1, sr.getResourceLocation());
                                this.setSkinTextureLocation(sr.getResourceLocation());
                            } else {
                                this.setSkinTextureLocation(PlayerEntityElementCache.getSkin(sha1));
                            }
                            this.skinUrl = null;
                            this.skinPath = sourcePathOrLink;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }).start();
            }
        } else {
            this.setSkinTextureLocation(null);
            this.skinUrl = null;
            this.skinPath = null;
            this.oldSkinUrl = null;
        }
    }

    public void setCapeTextureBySource(String sourcePathOrLink, boolean web) {
        PlayerEntityCustomizationItem cachedInstance = PlayerEntityCustomizationItemContainer.ELEMENT_CACHE.get(this.actionId);
        if (cachedInstance != null && cachedInstance.currentCapeLocation != null) {
            this.setCapeTextureLocation(cachedInstance.currentCapeLocation);
            return;
        }
        if (sourcePathOrLink != null) {
            if (web) {
                new Thread(() -> {
                    try {
                        String url = StringUtils.convertFormatCodes((String)PlaceholderParser.replacePlaceholders(sourcePathOrLink), (String)"\u00a7", (String)"&");
                        this.capeUrl = sourcePathOrLink;
                        this.oldCapeUrl = url;
                        this.capePath = null;
                        String sha1 = PlayerEntityElementCache.calculateWebSourceSHA1(url);
                        if (sha1 != null) {
                            if (!PlayerEntityElementCache.isCapeCached(sha1)) {
                                CapeWebTextureResourceLocation sr = new CapeWebTextureResourceLocation(url);
                                sr.downloadTexture();
                                if (sr.getDownloadedTexture() == null) {
                                    return;
                                }
                                CustomizationHelper.runTaskInMainThread(() -> sr.loadTexture());
                                long start = System.currentTimeMillis();
                                while (sr.getResourceLocation() == null) {
                                    long now = System.currentTimeMillis();
                                    if (start + 15000L <= now) {
                                        LOGGER.error("[FANCYMENU] Failed to load web cape texture for Player Entity element!");
                                        return;
                                    }
                                    Thread.sleep(100L);
                                }
                                PlayerEntityElementCache.cacheCape(sha1, sr.getResourceLocation());
                                this.setCapeTextureLocation(sr.getResourceLocation());
                            } else {
                                this.setCapeTextureLocation(PlayerEntityElementCache.getCape(sha1));
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }).start();
            } else {
                new Thread(() -> {
                    try {
                        String sha1;
                        String path = MenuCustomization.getAbsoluteGameDirectoryPath(sourcePathOrLink);
                        File f = new File(path);
                        if (f.isFile() && (f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png")) && (sha1 = PlayerEntityElementCache.calculateSHA1(f)) != null) {
                            if (!PlayerEntityElementCache.isCapeCached(sha1)) {
                                ExternalTextureResourceLocation er = new ExternalTextureResourceLocation(path);
                                CustomizationHelper.runTaskInMainThread(() -> er.loadTexture());
                                long start = System.currentTimeMillis();
                                while (er.getResourceLocation() == null) {
                                    long now = System.currentTimeMillis();
                                    if (start + 15000L <= now) {
                                        LOGGER.error("[FANCYMENU] Failed to load local cape texture for Player Entity element!");
                                        return;
                                    }
                                    Thread.sleep(100L);
                                }
                                PlayerEntityElementCache.cacheCape(sha1, er.getResourceLocation());
                                this.setCapeTextureLocation(er.getResourceLocation());
                            } else {
                                this.setCapeTextureLocation(PlayerEntityElementCache.getCape(sha1));
                            }
                            this.capeUrl = null;
                            this.capePath = sourcePathOrLink;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }).start();
            }
        } else {
            this.setCapeTextureLocation(null);
            this.capeUrl = null;
            this.capePath = null;
            this.oldCapeUrl = null;
        }
    }

    protected void setSkinTextureLocation(ResourceLocation loc) {
        this.currentSkinLocation = loc;
        this.normalRenderer.properties.setSkinTextureLocation(loc);
        this.slimRenderer.properties.setSkinTextureLocation(loc);
    }

    protected void setCapeTextureLocation(ResourceLocation loc) {
        this.currentCapeLocation = loc;
        this.normalRenderer.properties.setCapeTextureLocation(loc);
        this.slimRenderer.properties.setCapeTextureLocation(loc);
    }

    public PlayerEntityItemRenderer getActiveRenderer() {
        if (this.slim) {
            return this.slimRenderer;
        }
        return this.normalRenderer;
    }

    public PlayerEntityProperties getActiveEntityProperties() {
        return this.getActiveRenderer().properties;
    }

    @Override
    public void render(MatrixStack matrix, Screen menu) {
        if (this.shouldRender()) {
            String currentCapeUrl;
            String currentSkinUrl;
            if (this.skinUrl != null && !(currentSkinUrl = StringUtils.convertFormatCodes((String)PlaceholderParser.replacePlaceholders(this.skinUrl), (String)"\u00a7", (String)"&")).equals(this.oldSkinUrl)) {
                this.oldSkinUrl = currentSkinUrl;
                this.setSkinTextureBySource(this.skinUrl, true);
            }
            if (this.capeUrl != null && !(currentCapeUrl = StringUtils.convertFormatCodes((String)PlaceholderParser.replacePlaceholders(this.capeUrl), (String)"\u00a7", (String)"&")).equals(this.oldCapeUrl)) {
                this.oldCapeUrl = currentCapeUrl;
                this.setCapeTextureBySource(this.capeUrl, true);
            }
            this.setPlayerName(this.playerName, false);
            this.setWidth((int)(this.getActiveEntityProperties().getDimensions().field_220315_a * (float)this.scale));
            this.setHeight((int)(this.getActiveEntityProperties().getDimensions().field_220316_b * (float)this.scale));
            this.value = this.playerName != null ? this.playerName : "Player Entity";
            RenderSystem.enableBlend();
            int x = this.getPosX(menu);
            int y = this.getPosY(menu);
            this.renderPlayerEntity(x, y, this.scale, (float)x - (float)MouseInput.getMouseX(), (float)(y - 50) - (float)MouseInput.getMouseY());
        }
    }

    protected void renderPlayerEntity(int i11, int i12, int i13, float angleXComponent, float angleYComponent) {
        float f = (float)Math.atan(angleXComponent / 40.0f);
        float f1 = (float)Math.atan(angleYComponent / 40.0f);
        this.innerRenderPlayerEntity(i11, i12, i13, f, f1, this.getActiveEntityProperties(), this.getActiveRenderer());
    }

    protected void innerRenderPlayerEntity(int posX, int posY, int scale, float angleXComponent, float angleYComponent, PlayerEntityProperties props, PlayerEntityItemRenderer renderer) {
        Quaternion quat2;
        float angleX = angleXComponent;
        float angleY = angleYComponent;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)posX + this.getActiveEntityProperties().getDimensions().field_220315_a / 2.0f * (float)scale), (float)((float)posY + this.getActiveEntityProperties().getDimensions().field_220316_b * (float)this.scale), (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack innerMatrix = new MatrixStack();
        innerMatrix.func_227861_a_(0.0, 0.0, 1000.0);
        innerMatrix.func_227862_a_((float)scale, (float)scale, (float)scale);
        if (this.followMouse) {
            Quaternion quat1 = Vector3f.field_229183_f_.func_229187_a_(180.0f);
            quat2 = Vector3f.field_229179_b_.func_229187_a_(angleY * 20.0f);
            quat1.func_195890_a(quat2);
            innerMatrix.func_227863_a_(quat1);
            props.yBodyRot = 180.0f + angleX * 20.0f;
            props.yRot = 180.0f + angleX * 40.0f;
            props.xRot = -angleY * 20.0f;
            props.yHeadRot = props.yRot;
            props.yHeadRotO = props.yRot;
        } else {
            Quaternion quat1 = Vector3f.field_229183_f_.func_229187_a_(180.0f);
            quat2 = Vector3f.field_229179_b_.func_229187_a_(this.bodyRotationY);
            quat1.func_195890_a(quat2);
            innerMatrix.func_227863_a_(quat1);
            props.yBodyRot = 180.0f + this.bodyRotationX;
            props.xRot = this.headRotationY;
            props.yHeadRot = 180.0f + this.headRotationX;
            props.yHeadRotO = 180.0f + this.headRotationX;
        }
        EntityRendererManager dispatcher = Minecraft.func_71410_x().func_175598_ae();
        quat2.func_195892_e();
        dispatcher.func_229089_a_(quat2);
        dispatcher.func_178633_a(false);
        IRenderTypeBuffer.Impl bufferSource = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> renderer.renderPlayerEntityItem(0.0, 0.0, 0.0, 0.0f, 1.0f, innerMatrix, (IRenderTypeBuffer)bufferSource, 0xF000F0));
        bufferSource.func_228461_a_();
        dispatcher.func_178633_a(true);
        RenderSystem.popMatrix();
    }
}

