/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.button.ButtonScriptEngine;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.fancy.item.items.IActionExecutorItem;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.sound.SoundHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public class ButtonCustomizationItem
extends CustomizationItemBase
implements IActionExecutorItem {
    public AdvancedButton button;
    private String hoverLabel;
    private String hoverSound;
    private boolean hover = false;
    private boolean onlyMultiplayer = false;
    private boolean onlySingleplayer = false;
    private boolean onlyOutgame = false;
    public String hoverLabelRaw;
    public String labelRaw;
    public String tooltip;
    public List<ButtonScriptEngine.ActionContainer> actions = new ArrayList<ButtonScriptEngine.ActionContainer>();

    public ButtonCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addbutton")) {
            this.labelRaw = item.getEntryValue("label");
            if (this.labelRaw == null) {
                this.labelRaw = "";
            }
            String buttonaction = item.getEntryValue("buttonaction");
            String actionvalue = item.getEntryValue("value");
            if (actionvalue == null) {
                actionvalue = "";
            }
            this.hoverSound = item.getEntryValue("hoversound");
            if (this.hoverSound != null) {
                this.hoverSound = this.hoverSound.replace("\\", "/");
                File f = new File(MenuCustomization.getAbsoluteGameDirectoryPath(this.hoverSound));
                if (f.exists() && f.isFile() && f.getName().endsWith(".wav")) {
                    MenuCustomization.registerSound(this.hoverSound, this.hoverSound);
                } else {
                    this.hoverSound = null;
                }
            }
            this.hoverLabelRaw = item.getEntryValue("hoverlabel");
            String onlyX = item.getEntryValue("onlydisplayin");
            if (onlyX != null) {
                if (onlyX.equalsIgnoreCase("outgame")) {
                    this.onlyOutgame = true;
                }
                if (onlyX.equalsIgnoreCase("multiplayer")) {
                    this.onlyMultiplayer = true;
                }
                if (onlyX.equalsIgnoreCase("singleplayer")) {
                    this.onlySingleplayer = true;
                }
            }
            if (buttonaction != null) {
                if (buttonaction.contains("%btnaction_splitter_fm%")) {
                    for (String s : StringUtils.splitLines((String)buttonaction, (String)"%btnaction_splitter_fm%")) {
                        if (s.length() <= 0) continue;
                        String action = s;
                        String value = null;
                        if (s.contains(";")) {
                            action = s.split(";", 2)[0];
                            value = s.split(";", 2)[1];
                        }
                        this.actions.add(new ButtonScriptEngine.ActionContainer(action, value));
                    }
                } else {
                    this.actions.add(new ButtonScriptEngine.ActionContainer(buttonaction, actionvalue));
                }
            }
            this.button = new AdvancedButton(0, 0, this.getWidth(), this.getHeight(), "", true, press -> {
                for (ButtonScriptEngine.ActionContainer c : this.actions) {
                    c.execute();
                }
            });
            String click = item.getEntryValue("clicksound");
            if (click != null) {
                click.replace("\\", "/");
                File f = new File(click);
                if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("\\", "/"))) {
                    f = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("\\", "/") + "/" + click);
                }
                if (f.exists() && f.isFile() && f.getPath().toLowerCase().endsWith(".wav")) {
                    SoundHandler.registerSound((String)f.getPath(), (String)f.getPath());
                    this.button.setClickSound(f.getPath());
                }
            }
            this.tooltip = item.getEntryValue("description");
            if (this.tooltip != null) {
                this.button.setDescription(StringUtils.splitLines((String)PlaceholderParser.replacePlaceholders(this.tooltip), (String)"%n%"));
            }
            String backNormal = ButtonCustomizationItem.fixBackslashPath(item.getEntryValue("backgroundnormal"));
            String backHover = ButtonCustomizationItem.fixBackslashPath(item.getEntryValue("backgroundhovered"));
            String loopBackAnimations = item.getEntryValue("loopbackgroundanimations");
            String restartBackAnimationsOnHover = item.getEntryValue("restartbackgroundanimations");
            String backAnimationNormal = item.getEntryValue("backgroundanimationnormal");
            String backAnimationHover = item.getEntryValue("backgroundanimationhovered");
            if (this.button != null) {
                ExternalTextureResourceLocation back;
                File f;
                if (loopBackAnimations != null && loopBackAnimations.equalsIgnoreCase("false")) {
                    this.button.loopBackgroundAnimations = false;
                }
                if (restartBackAnimationsOnHover != null && restartBackAnimationsOnHover.equalsIgnoreCase("false")) {
                    this.button.restartBackgroundAnimationsOnHover = false;
                }
                if (backNormal != null) {
                    f = new File(backNormal.replace("\\", "/"));
                    if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("\\", "/"))) {
                        f = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("\\", "/") + "/" + backNormal);
                    }
                    if (f.isFile()) {
                        if (f.getPath().toLowerCase().endsWith(".gif")) {
                            this.button.setBackgroundNormal((IAnimationRenderer)TextureHandler.getGifResource((String)f.getPath()));
                        } else if ((f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png")) && (back = TextureHandler.getResource((String)f.getPath())) != null) {
                            if (!back.isReady()) {
                                back.loadTexture();
                            }
                            this.button.setBackgroundNormal(back.getResourceLocation());
                        }
                    }
                } else if (backAnimationNormal != null && AnimationHandler.animationExists(backAnimationNormal)) {
                    this.button.setBackgroundNormal(AnimationHandler.getAnimation(backAnimationNormal));
                }
                if (backHover != null) {
                    f = new File(backHover.replace("\\", "/"));
                    if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("\\", "/"))) {
                        f = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("\\", "/") + "/" + backHover);
                    }
                    if (f.isFile()) {
                        if (f.getPath().toLowerCase().endsWith(".gif")) {
                            this.button.setBackgroundHover((IAnimationRenderer)TextureHandler.getGifResource((String)f.getPath()));
                        } else if ((f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png")) && (back = TextureHandler.getResource((String)f.getPath())) != null) {
                            if (!back.isReady()) {
                                back.loadTexture();
                            }
                            this.button.setBackgroundHover(back.getResourceLocation());
                        }
                    }
                } else if (backAnimationHover != null && AnimationHandler.animationExists(backAnimationHover)) {
                    this.button.setBackgroundHover(AnimationHandler.getAnimation(backAnimationHover));
                }
            }
            this.updateValues();
        }
    }

    @Override
    public void render(MatrixStack matrix, Screen menu) throws IOException {
        if (!this.shouldRender()) {
            return;
        }
        this.updateValues();
        if (this.onlyOutgame && Minecraft.func_71410_x().field_71441_e != null) {
            return;
        }
        if (this.onlyMultiplayer && (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().func_71356_B())) {
            return;
        }
        if (this.onlySingleplayer && (Minecraft.func_71410_x().field_71441_e == null || !Minecraft.func_71410_x().func_71356_B())) {
            return;
        }
        this.button.func_230986_a_(this.opacity);
        int x = this.getPosX(menu);
        int y = this.getPosY(menu);
        this.button.setX(x);
        this.button.setY(y);
        if (this.button.func_230449_g_() && this.button.field_230693_o_) {
            if (this.hoverLabel != null) {
                this.button.setMessage(this.hoverLabel);
            } else {
                this.button.setMessage(this.value);
            }
            if (this.hoverSound != null && !this.hover) {
                this.hover = true;
                SoundHandler.resetSound((String)this.hoverSound);
                SoundHandler.playSound((String)this.hoverSound);
            }
        } else {
            this.button.setMessage(this.value);
            this.hover = false;
        }
        this.button.func_230430_a_(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.func_71410_x().func_184121_ak());
    }

    protected void updateValues() {
        if (this.tooltip != null) {
            this.button.setDescription(StringUtils.splitLines((String)PlaceholderParser.replacePlaceholders(this.tooltip), (String)"%n%"));
        }
        if (this.labelRaw != null) {
            this.value = !ButtonCustomizationItem.isEditorActive() ? PlaceholderParser.replacePlaceholders(this.labelRaw) : StringUtils.convertFormatCodes((String)this.labelRaw, (String)"&", (String)"\u00a7");
        }
        if (this.hoverLabelRaw != null) {
            this.hoverLabel = !ButtonCustomizationItem.isEditorActive() ? PlaceholderParser.replacePlaceholders(this.hoverLabelRaw) : StringUtils.convertFormatCodes((String)this.hoverLabelRaw, (String)"&", (String)"\u00a7");
        }
    }

    @Override
    public boolean shouldRender() {
        if (this.button == null) {
            return false;
        }
        return super.shouldRender();
    }

    public AdvancedButton getButton() {
        return this.button;
    }

    public Long getId() {
        int ori = 0;
        if (this.orientation.equalsIgnoreCase("original")) {
            ori = 1;
        } else if (this.orientation.equalsIgnoreCase("top-left")) {
            ori = 2;
        } else if (this.orientation.equalsIgnoreCase("mid-left")) {
            ori = 3;
        } else if (this.orientation.equalsIgnoreCase("bottom-left")) {
            ori = 4;
        } else if (this.orientation.equalsIgnoreCase("top-centered")) {
            ori = 5;
        } else if (this.orientation.equalsIgnoreCase("mid-centered")) {
            ori = 6;
        } else if (this.orientation.equalsIgnoreCase("bottom-centered")) {
            ori = 7;
        } else if (this.orientation.equalsIgnoreCase("top-right")) {
            ori = 8;
        } else if (this.orientation.equalsIgnoreCase("mid-right")) {
            ori = 9;
        } else if (this.orientation.equalsIgnoreCase("bottom-right")) {
            ori = 10;
        }
        String idRaw = "00" + ori + "" + Math.abs(this.posX) + "" + Math.abs(this.posY) + "" + Math.abs(this.getWidth());
        long id = 0L;
        if (MathUtils.isLong((String)idRaw)) {
            id = Long.parseLong(idRaw);
        }
        return id;
    }

    @Override
    public List<ButtonScriptEngine.ActionContainer> getActionList() {
        return this.actions;
    }
}

