/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMPopup;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;

public class WindowSizePopup
extends FMPopup {
    private ActionType type;
    private LayoutEditorScreen parent;
    private AdvancedButton cancelButton;
    private AdvancedButton doneButton;
    private AdvancedTextField widthText;
    private AdvancedTextField heightText;

    public WindowSizePopup(LayoutEditorScreen parent, ActionType type) {
        super(240);
        this.type = type;
        this.parent = parent;
        this.cancelButton = new AdvancedButton(0, 0, 80, 20, Locals.localize((String)"popup.yesno.cancel", (String[])new String[0]), true, press -> this.setDisplayed(false));
        this.addButton(this.cancelButton);
        this.doneButton = new AdvancedButton(0, 0, 80, 20, Locals.localize((String)"popup.done", (String[])new String[0]), true, press -> this.onDoneButtonPressed());
        this.addButton(this.doneButton);
        this.widthText = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler());
        if (type == ActionType.BIGGERTHAN) {
            this.widthText.func_146180_a("" + parent.biggerThanWidth);
        } else {
            this.widthText.func_146180_a("" + parent.smallerThanWidth);
        }
        this.heightText = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler());
        if (type == ActionType.BIGGERTHAN) {
            this.heightText.func_146180_a("" + parent.biggerThanHeight);
        } else {
            this.heightText.func_146180_a("" + parent.smallerThanHeight);
        }
        KeyboardHandler.addKeyPressedListener(this::onEnterPressed);
        KeyboardHandler.addKeyPressedListener(this::onEscapePressed);
    }

    public void render(MatrixStack matrix, int mouseX, int mouseY, Screen renderIn) {
        super.render(matrix, mouseX, mouseY, renderIn);
        float partial = Minecraft.func_71410_x().func_184121_ak();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        if (this.type == ActionType.BIGGERTHAN) {
            AbstractGui.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)("\u00a7l" + Locals.localize((String)"helper.creator.windowsize.biggerthan.desc", (String[])new String[0])), (int)(renderIn.field_230708_k_ / 2), (int)(renderIn.field_230709_l_ / 2 - 110), (int)Color.WHITE.getRGB());
        } else {
            AbstractGui.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)("\u00a7l" + Locals.localize((String)"helper.creator.windowsize.smallerthan.desc", (String[])new String[0])), (int)(renderIn.field_230708_k_ / 2), (int)(renderIn.field_230709_l_ / 2 - 110), (int)Color.WHITE.getRGB());
        }
        AbstractGui.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)Locals.localize((String)"general.width", (String[])new String[0]), (int)(renderIn.field_230708_k_ / 2), (int)(renderIn.field_230709_l_ / 2 - 80), (int)Color.WHITE.getRGB());
        this.widthText.field_230690_l_ = renderIn.field_230708_k_ / 2 - this.widthText.func_230998_h_() / 2;
        this.widthText.field_230691_m_ = renderIn.field_230709_l_ / 2 - 65;
        this.widthText.func_230430_a_(matrix, mouseX, mouseY, partial);
        AbstractGui.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)Locals.localize((String)"general.height", (String[])new String[0]), (int)(renderIn.field_230708_k_ / 2), (int)(renderIn.field_230709_l_ / 2 - 37), (int)Color.WHITE.getRGB());
        this.heightText.field_230690_l_ = renderIn.field_230708_k_ / 2 - this.heightText.func_230998_h_() / 2;
        this.heightText.field_230691_m_ = renderIn.field_230709_l_ / 2 - 22;
        this.heightText.func_230430_a_(matrix, mouseX, mouseY, partial);
        AbstractGui.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)(Locals.localize((String)"helper.creator.windowsize.currentwidth", (String[])new String[0]) + ": " + Minecraft.func_71410_x().func_228018_at_().func_198105_m()), (int)(renderIn.field_230708_k_ / 2), (int)(renderIn.field_230709_l_ / 2 + 15), (int)Color.WHITE.getRGB());
        AbstractGui.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)(Locals.localize((String)"helper.creator.windowsize.currentheight", (String[])new String[0]) + ": " + Minecraft.func_71410_x().func_228018_at_().func_198083_n()), (int)(renderIn.field_230708_k_ / 2), (int)(renderIn.field_230709_l_ / 2 + 30), (int)Color.WHITE.getRGB());
        this.doneButton.field_230690_l_ = renderIn.field_230708_k_ / 2 - this.doneButton.func_230998_h_() - 5;
        this.doneButton.field_230691_m_ = renderIn.field_230709_l_ / 2 + 80;
        this.cancelButton.field_230690_l_ = renderIn.field_230708_k_ / 2 + 5;
        this.cancelButton.field_230691_m_ = renderIn.field_230709_l_ / 2 + 80;
        this.renderButtons(matrix, mouseX, mouseY);
    }

    private void onDoneButtonPressed() {
        try {
            if (MathUtils.isInteger((String)this.widthText.func_146179_b()) && MathUtils.isInteger((String)this.heightText.func_146179_b())) {
                int w = Integer.parseInt(this.widthText.func_146179_b());
                int h = Integer.parseInt(this.heightText.func_146179_b());
                if (this.type == ActionType.BIGGERTHAN) {
                    if (this.parent.biggerThanWidth != w || this.parent.biggerThanHeight != h) {
                        this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                    }
                    this.parent.biggerThanWidth = w;
                    this.parent.biggerThanHeight = h;
                } else {
                    if (this.parent.smallerThanWidth != w || this.parent.smallerThanHeight != h) {
                        this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                    }
                    this.parent.smallerThanWidth = w;
                    this.parent.smallerThanHeight = h;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDisplayed(false);
    }

    public void onEnterPressed(KeyboardData d) {
        if (d.keycode == 257 && this.isDisplayed() && this.doneButton != null && this.doneButton.field_230694_p_) {
            this.onDoneButtonPressed();
        }
    }

    public void onEscapePressed(KeyboardData d) {
        if (d.keycode == 256 && this.isDisplayed()) {
            this.setDisplayed(false);
        }
    }

    public static enum ActionType {
        BIGGERTHAN,
        SMALLERTHAN;

    }
}

