/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VanillaButtonDescriptionHandler {
    private static Map<Widget, String> descriptions = new HashMap<Widget, String>();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new VanillaButtonDescriptionHandler());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInitPre(GuiScreenEvent.InitGuiEvent.Pre e) {
        descriptions.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post e) {
        for (Map.Entry<Widget, String> m : descriptions.entrySet()) {
            if (!m.getKey().func_230449_g_()) continue;
            VanillaButtonDescriptionHandler.renderDescription(e.getMatrixStack(), e.getMouseX(), e.getMouseY(), m.getValue());
            break;
        }
    }

    public static void setDescriptionFor(Widget w, String desc) {
        descriptions.put(w, desc);
    }

    private static void renderDescriptionBackground(MatrixStack matrix, int x, int y, int width, int height) {
        IngameGui.func_238467_a_((MatrixStack)matrix, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)new Color(26, 26, 26, 250).getRGB());
    }

    private static void renderDescription(MatrixStack matrix, int mouseX, int mouseY, String desc) {
        if (desc != null) {
            String[] descArray;
            int width = 10;
            int height = 10;
            for (String s : descArray = StringUtils.splitLines((String)desc, (String)"%n%")) {
                int i = Minecraft.func_71410_x().field_71466_p.func_78256_a(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (Minecraft.func_71410_x().field_71462_r.field_230708_k_ < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (Minecraft.func_71410_x().field_71462_r.field_230709_l_ < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre((MatrixStack)matrix, (int)600);
            VanillaButtonDescriptionHandler.renderDescriptionBackground(matrix, mouseX, mouseY, width, height);
            RenderSystem.enableBlend();
            int i2 = 5;
            for (String s : descArray) {
                AbstractGui.func_238476_c_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)s, (int)(mouseX + 5), (int)(mouseY + i2), (int)Color.WHITE.getRGB());
                i2 += 10;
            }
            RenderUtils.setZLevelPost((MatrixStack)matrix);
            RenderSystem.disableBlend();
        }
    }
}

