/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mainwindow;

import de.keksuccino.fancymenu.FancyMenu;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.TextureUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class WindowHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final File ICON_DIR = new File(FancyMenu.MOD_DIR, "/minecraftwindow/icons");
    private static String windowTitle = null;

    public static void handleForceFullscreen() {
        try {
            FancyMenu.initConfig();
            if (((Boolean)FancyMenu.config.getOrDefault("forcefullscreen", (Object)false)).booleanValue() && !Minecraft.func_71410_x().func_228018_at_().func_198113_j()) {
                Minecraft.func_71410_x().func_228018_at_().func_198077_g();
                LOGGER.info("[FANCYMENU] Forced window to fullscreen!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateWindowIcon() {
        FancyMenu.initConfig();
        if (((Boolean)FancyMenu.config.getOrDefault("customwindowicon", (Object)false)).booleanValue()) {
            try {
                File i16 = new File(ICON_DIR.getPath() + "/icon16x16.png");
                File i32 = new File(ICON_DIR.getPath() + "/icon32x32.png");
                if (!i16.exists() || !i32.exists()) {
                    LOGGER.error("[FANCYMENU] Unable to set custom icons: 'icon16x16.png' or 'icon32x32.png' missing!");
                    return;
                }
                BufferedImage i16buff = ImageIO.read(i16);
                if (i16buff.getHeight() != 16 || i16buff.getWidth() != 16) {
                    LOGGER.error("[FANCYMENU] Unable to set custom icons: 'icon16x16.png' not 16x16!");
                    return;
                }
                BufferedImage i32buff = ImageIO.read(i32);
                if (i32buff.getHeight() != 32 || i32buff.getWidth() != 32) {
                    LOGGER.error("[FANCYMENU] Unable to set custom icons: 'icon32x32.png' not 32x32!");
                    return;
                }
                WindowHandler.setIcon(Files.newInputStream(i16.toPath(), new OpenOption[0]), Files.newInputStream(i32.toPath(), new OpenOption[0]));
                LOGGER.info("[FANCYMENU] Custom minecraft icon successfully loaded!");
            }
            catch (Exception e) {
                LOGGER.error("[FANCYMENU] Failed to set custom window icon!");
                e.printStackTrace();
            }
        }
    }

    private static void setIcon(InputStream p_250818_, InputStream p_249199_) {
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            GLFWImage.Buffer buffer = GLFWImage.mallocStack((int)2, (MemoryStack)memorystack);
            ByteBuffer bytebuffer = WindowHandler.readIconPixels(p_250818_, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(0);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer);
            ByteBuffer bytebuffer1 = WindowHandler.readIconPixels(p_249199_, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer1 == null) {
                STBImage.stbi_image_free((ByteBuffer)bytebuffer);
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(1);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer1);
            buffer.position(0);
            GLFW.glfwSetWindowIcon((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (GLFWImage.Buffer)buffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer1);
        }
        catch (IOException ioexception) {
            LogManager.getLogger().error("Couldn't set icon", (Throwable)ioexception);
        }
    }

    /*
     * Loose catch block
     */
    @Nullable
    private static ByteBuffer readIconPixels(InputStream p_249586_, IntBuffer p_249069_, IntBuffer p_249100_, IntBuffer p_249695_) throws IOException {
        ByteBuffer byteBuffer;
        Throwable throwable;
        InputStream inputstream;
        ByteBuffer bytebuffer;
        block16: {
            bytebuffer = null;
            inputstream = p_249586_;
            throwable = null;
            bytebuffer = TextureUtil.func_225684_a_((InputStream)inputstream);
            bytebuffer.rewind();
            byteBuffer = STBImage.stbi_load_from_memory((ByteBuffer)bytebuffer, (IntBuffer)p_249069_, (IntBuffer)p_249100_, (IntBuffer)p_249695_, (int)0);
            if (bytebuffer == null) break block16;
            MemoryUtil.memFree((Buffer)bytebuffer);
        }
        return byteBuffer;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputstream != null) {
                    if (throwable != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        inputstream.close();
                    }
                }
            }
            {
                catch (Throwable throwable4) {
                    if (bytebuffer != null) {
                        MemoryUtil.memFree(bytebuffer);
                    }
                    throw throwable4;
                }
            }
        }
    }

    public static void updateWindowTitle() {
        WindowHandler.readCustomWindowTitleFromConfig();
        Minecraft.func_71410_x().func_230150_b_();
    }

    public static void readCustomWindowTitleFromConfig() {
        FancyMenu.initConfig();
        windowTitle = (String)FancyMenu.config.getOrDefault("customwindowtitle", (Object)"");
        if (windowTitle != null && windowTitle.isEmpty()) {
            windowTitle = null;
        }
    }

    @Nullable
    public static String getCustomWindowTitle() {
        return windowTitle;
    }

    public static int getWindowGuiWidth() {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (s != null) {
            double mcScale = Minecraft.func_71410_x().func_228018_at_().func_216521_a((int)Minecraft.func_71410_x().func_228018_at_().func_198100_s(), Minecraft.func_71410_x().field_71474_y.field_211842_aO);
            float baseUIScale = 1.0f;
            float sc = (float)((double)baseUIScale * ((double)baseUIScale / mcScale));
            return (int)((float)s.field_230708_k_ / sc);
        }
        return 0;
    }

    public static int getWindowGuiHeight() {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (s != null) {
            double mcScale = Minecraft.func_71410_x().func_228018_at_().func_216521_a((int)Minecraft.func_71410_x().func_228018_at_().func_198100_s(), Minecraft.func_71410_x().field_71474_y.field_211842_aO);
            float baseUIScale = 1.0f;
            float sc = (float)((double)baseUIScale * ((double)baseUIScale / mcScale));
            return (int)((float)s.field_230709_l_ / sc);
        }
        return 0;
    }
}

