/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.keksuccino.fancymenu.commands.client.CommandUtils;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.command.execute.ExecuteCommandPacketMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;

public class ServerVariableCommand {
    public static volatile Map<String, List<String>> cachedVariableArguments = new HashMap<String, List<String>>();

    public static void register(CommandDispatcher<CommandSource> d) {
        d.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"fmvariable").then(Commands.func_197056_a((String)"action", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CommandUtils.getStringSuggestions(builder, "get", "set")).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"variable_name", (ArgumentType)StringArgumentType.string()).executes(stack -> ServerVariableCommand.getVariable((CommandSource)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"action"), StringArgumentType.getString((CommandContext)stack, (String)"variable_name")))).suggests((context, builder) -> CommandUtils.getStringSuggestions(builder, ServerVariableCommand.getVariableNameSuggestions(((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"set_to_value", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            if (StringArgumentType.getString((CommandContext)context, (String)"action").equalsIgnoreCase("set")) {
                return CommandUtils.getStringSuggestions(builder, "<set_to_value>");
            }
            return CommandUtils.getStringSuggestions(builder, new String[0]);
        }).then(Commands.func_197056_a((String)"send_chat_feedback", (ArgumentType)BoolArgumentType.bool()).executes(stack -> ServerVariableCommand.setVariable((CommandSource)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"action"), StringArgumentType.getString((CommandContext)stack, (String)"variable_name"), StringArgumentType.getString((CommandContext)stack, (String)"set_to_value"), BoolArgumentType.getBool((CommandContext)stack, (String)"send_chat_feedback"))))))));
    }

    private static String[] getVariableNameSuggestions(ServerPlayerEntity sender) {
        List<String> l = cachedVariableArguments.get(sender.func_110124_au().toString());
        if (l.isEmpty()) {
            l.add("<no_variables_found>");
        }
        return l.toArray(new String[0]);
    }

    private static int getVariable(CommandSource stack, String getOrSet, String variableName) {
        try {
            if (getOrSet.equalsIgnoreCase("get") && variableName != null) {
                ServerPlayerEntity sender = stack.func_197035_h();
                ExecuteCommandPacketMessage msg = new ExecuteCommandPacketMessage();
                msg.direction = "client";
                msg.command = "/fmvariable get " + variableName;
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), msg);
            }
        }
        catch (Exception e) {
            stack.func_197021_a((ITextComponent)new StringTextComponent("Error while executing command!"));
            e.printStackTrace();
        }
        return 1;
    }

    private static int setVariable(CommandSource stack, String getOrSet, String variableName, String setToValue, boolean sendFeedback) {
        try {
            if (getOrSet.equalsIgnoreCase("set") && variableName != null && setToValue != null) {
                ServerPlayerEntity sender = stack.func_197035_h();
                ExecuteCommandPacketMessage msg = new ExecuteCommandPacketMessage();
                msg.direction = "client";
                msg.command = "/fmvariable set " + variableName + " " + setToValue + " " + sendFeedback;
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), msg);
            }
        }
        catch (Exception e) {
            stack.func_197021_a((ITextComponent)new StringTextComponent("Error while executing command!"));
            e.printStackTrace();
        }
        return 1;
    }
}

