/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen;

import com.google.common.collect.Lists;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.api.event.FullscreenMapEvent;
import journeymap.client.api.event.forge.FullscreenDisplayEvent;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.api.impl.ThemeButtonDisplayFactory;
import journeymap.client.api.impl.ThemeToolbarDisplayFactory;
import journeymap.client.api.model.IBlockInfo;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeButton;
import journeymap.client.ui.theme.ThemeToolbar;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class FullscreenEventHandler {
    public static boolean clickEventPre(BlockPos location, RegistryKey<World> level, Point2D.Double mousePosition, int button) {
        FullscreenMapEvent.ClickEvent.Pre preClickEvent = new FullscreenMapEvent.ClickEvent.Pre(location, level, mousePosition, button);
        ClientAPI.INSTANCE.getClientEventManager().fireEvent(preClickEvent);
        return preClickEvent.isCancelled();
    }

    public static void clickEventPost(BlockPos location, RegistryKey<World> level, Point2D.Double mousePosition, int button) {
        FullscreenMapEvent.ClickEvent.Post postClickEvent = new FullscreenMapEvent.ClickEvent.Post(location, level, mousePosition, button);
        ClientAPI.INSTANCE.getClientEventManager().fireEvent(postClickEvent);
    }

    public static boolean dragEventPre(BlockPos location, RegistryKey<World> level, Point2D.Double mousePosition, int button) {
        FullscreenMapEvent.MouseDraggedEvent.Pre draggedEvent = new FullscreenMapEvent.MouseDraggedEvent.Pre(location, level, mousePosition, button);
        ClientAPI.INSTANCE.getClientEventManager().fireEvent(draggedEvent);
        return draggedEvent.isCancelled();
    }

    public static void dragEventPost(BlockPos location, RegistryKey<World> level, Point2D.Double mousePosition, int button) {
        FullscreenMapEvent.MouseDraggedEvent.Post draggedEvent = new FullscreenMapEvent.MouseDraggedEvent.Post(location, level, mousePosition, button);
        ClientAPI.INSTANCE.getClientEventManager().fireEvent(draggedEvent);
    }

    public static void moveEvent(RegistryKey<World> level, IBlockInfo info, Point2D.Double mousePosition) {
        FullscreenMapEvent.MouseMoveEvent mouseMoveEvent = new FullscreenMapEvent.MouseMoveEvent(level, info, mousePosition);
        ClientAPI.INSTANCE.getClientEventManager().fireEvent(mouseMoveEvent);
    }

    public static ThemeToolbar getMapTypeToolbar(Fullscreen fullscreen, Theme theme, Button ... buttons) {
        ThemeButtonDisplayFactory factory = new ThemeButtonDisplayFactory(theme);
        FullscreenDisplayEvent.MapTypeButtonDisplayEvent event = new FullscreenDisplayEvent.MapTypeButtonDisplayEvent(fullscreen, factory);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!factory.getThemeButtonList().isEmpty()) {
            ArrayList themeButtonList = Lists.newArrayList((Object[])buttons);
            factory.getThemeButtonList().forEach(fullscreen::addButtonWidget);
            themeButtonList.addAll(0, factory.getThemeButtonList());
            return new ThemeToolbar(theme, themeButtonList.toArray(new Button[0]));
        }
        return new ThemeToolbar(theme, buttons);
    }

    public static ThemeToolbar getAddonToolbar(Fullscreen fullscreen, Theme theme) {
        ThemeButtonDisplayFactory factory = new ThemeButtonDisplayFactory(theme);
        FullscreenDisplayEvent.AddonButtonDisplayEvent event = new FullscreenDisplayEvent.AddonButtonDisplayEvent(fullscreen, factory);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!factory.getThemeButtonList().isEmpty()) {
            factory.getThemeButtonList().forEach(fullscreen::addButtonWidget);
            return new ThemeToolbar(theme, factory.getThemeButtonList().toArray(new ThemeButton[0]));
        }
        return null;
    }

    public static List<ThemeToolbar> getCustomToolBars(Fullscreen fullscreen, Theme theme) {
        ThemeToolbarDisplayFactory factory = new ThemeToolbarDisplayFactory(theme, fullscreen);
        FullscreenDisplayEvent.CustomToolbarEvent event = new FullscreenDisplayEvent.CustomToolbarEvent(fullscreen, factory);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!factory.getToolbarList().isEmpty()) {
            factory.getToolbarList().forEach(bar -> bar.addAllButtons(fullscreen));
            return factory.getToolbarList();
        }
        return null;
    }
}

