/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.geom.Point2D;
import java.util.List;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.texture.JMTexture;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.component.DropDownButton;
import journeymap.client.ui.theme.Theme;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public class DrawUtil {
    public static double zLevel = 0.0;
    static Tessellator tessellator = Tessellator.func_178181_a();
    static BufferBuilder worldrenderer = tessellator.func_178180_c();

    public static void drawCenteredLabel(MatrixStack mStack, ITextComponent text, double x, double y, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale) {
        DrawUtil.drawLabel(mStack, text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, true, 0.0);
    }

    public static void drawCenteredLabel(MatrixStack mStack, ITextComponent text, double x, double y, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawLabel(mStack, text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    public static void drawCenteredLabel(MatrixStack mStack, ITextComponent text, double x, double y, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, double rotation) {
        DrawUtil.drawLabel(mStack, text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, false, rotation);
    }

    public static void drawLabel(MatrixStack mStack, ITextComponent text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawLabel(mStack, text, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    public static void drawLabels(MatrixStack mStack, IRenderTypeBuffer buffers, String[] lines, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        if (lines.length == 0) {
            return;
        }
        if (lines.length == 1) {
            DrawUtil.drawBatchLabel(mStack, lines[0], buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, rotation);
            return;
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        double vpad = fontRenderer.func_78260_a() ? 0.0 : (fontShadow ? 6.0 : 4.0);
        fontRenderer.getClass();
        double lineHeight = 9.0 * fontScale;
        double bgHeight = lineHeight * (double)lines.length + vpad;
        double bgWidth = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            for (String line : lines) {
                bgWidth = Math.max(bgWidth, (double)fontRenderer.func_78256_a(line) * fontScale);
            }
            if (bgWidth % 2.0 == 0.0) {
                bgWidth += 1.0;
            }
        }
        if (lines.length > 1) {
            switch (vAlign) {
                case Above: {
                    y -= lineHeight * (double)lines.length;
                    bgHeight += vpad / 2.0;
                    break;
                }
                case Middle: {
                    y -= bgHeight / 2.0;
                    break;
                }
            }
        }
        for (String line : lines) {
            DrawUtil.drawBatchLabel(mStack, line, buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, rotation);
            bgColor = null;
            y += lineHeight;
        }
    }

    public static void drawLabel(MatrixStack mStack, ITextComponent text, Theme.LabelSpec labelSpec, double x, double y, HAlign hAlign, VAlign vAlign, double fontScale, double rotation) {
        DrawUtil.drawLabel(mStack, text, x, y, hAlign, vAlign, labelSpec.background.getColor(), labelSpec.background.alpha, labelSpec.foreground.getColor(), labelSpec.foreground.alpha, fontScale, labelSpec.shadow, rotation);
    }

    public static void drawLabel(MatrixStack mStack, ITextComponent text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double bgWidth = 0.0;
        double bgHeight = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            bgWidth = fontRenderer.func_238414_a_((ITextProperties)text);
            bgHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        }
        DrawUtil.drawLabel(mStack, text, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, rotation);
    }

    public static void drawBatchLabel(MatrixStack mStack, String text, IRenderTypeBuffer buffers, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double bgWidth = 0.0;
        double bgHeight = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            bgWidth = fontRenderer.func_78256_a(text);
            bgHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        }
        DrawUtil.drawBatchLabel(mStack, text, buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, rotation);
    }

    private static void drawBatchLabel(MatrixStack mStack, String text, IRenderTypeBuffer buffers, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, double bgWidth, double bgHeight, int color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double d;
        int height;
        int n;
        if (text == null || text.length() == 0) {
            return;
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        boolean drawRect = bgColor != null && bgAlpha > 0.0f;
        double width = fontRenderer.func_78256_a(text);
        if (drawRect) {
            n = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        } else {
            fontRenderer.getClass();
            n = height = 9;
        }
        if (!drawRect && fontRenderer.func_78260_a()) {
            --height;
        }
        mStack.func_227860_a_();
        if (fontScale != 1.0) {
            x /= fontScale;
            y /= fontScale;
            mStack.func_227862_a_((float)fontScale, (float)fontScale, 0.0f);
        }
        float textX = (float)x;
        float textY = (float)y;
        double rectX = x;
        double rectY = y;
        switch (hAlign) {
            case Left: {
                textX = (float)(x - width);
                rectX = textX;
                break;
            }
            case Center: {
                textX = (float)(x - width / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                rectX = (float)(x - Math.max(1.0, bgWidth) / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                break;
            }
            case Right: {
                textX = (float)x;
                rectX = (float)x;
            }
        }
        if (drawRect) {
            fontRenderer.getClass();
            d = (double)(height - 9) / 2.0;
        } else {
            d = 0.0;
        }
        double vpad = d;
        switch (vAlign) {
            case Above: {
                rectY = y - (double)height;
                textY = (float)(rectY + vpad + (double)(!fontRenderer.func_78260_a() ? 1 : 0));
                break;
            }
            case Middle: {
                rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                textY = (float)(rectY + vpad);
                break;
            }
            case Below: {
                rectY = y;
                textY = (float)(rectY + vpad);
            }
        }
        if (rotation != 0.0) {
            mStack.func_227861_a_(x, y, 0.0);
            mStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(-rotation)));
            mStack.func_227861_a_(-x, -y, 0.0);
        }
        Matrix4f matrixPos = mStack.func_227866_c_().func_227870_a_();
        if (drawRect) {
            int backgroundColor = Minecraft.func_71410_x().field_71474_y.func_216841_b(bgAlpha);
            int hpad = 2;
            DrawUtil.drawRectangle(mStack, rectX - 2.0 - 0.5, rectY, bgWidth + 4.0, bgHeight, bgColor, bgAlpha);
        }
        if (alpha < 0.0f) {
            color = RGB.toArbg(color, alpha);
        }
        mStack.func_227861_a_((double)textX - Math.floor(textX), (double)textY - Math.floor(textY), 0.0);
        fontRenderer.func_228079_a_(text, textX, textY, color, fontShadow, matrixPos, buffers, true, 0, 0xF000F0);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        mStack.func_227865_b_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLabel(MatrixStack mStack, ITextComponent text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, double bgWidth, double bgHeight, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        int height;
        int n;
        if (text == null || text.getString().length() == 0) {
            return;
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        boolean drawRect = bgColor != null && bgAlpha > 0.0f;
        double width = fontRenderer.func_238414_a_((ITextProperties)text);
        if (drawRect) {
            n = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        } else {
            fontRenderer.getClass();
            n = height = 9;
        }
        if (!drawRect && fontRenderer.func_78260_a()) {
            --height;
        }
        GL11.glPushMatrix();
        try {
            double d;
            if (fontScale != 1.0) {
                x /= fontScale;
                y /= fontScale;
                RenderSystem.scaled((double)fontScale, (double)fontScale, (double)1.0);
            }
            float textX = (float)x;
            float textY = (float)y;
            double rectX = x;
            double rectY = y;
            switch (hAlign) {
                case Left: {
                    textX = (float)(x - width);
                    rectX = textX;
                    break;
                }
                case Center: {
                    textX = (float)(x - width / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                    rectX = (float)(x - Math.max(1.0, bgWidth) / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                    break;
                }
                case Right: {
                    textX = (float)x;
                    rectX = (float)x;
                }
            }
            if (drawRect) {
                fontRenderer.getClass();
                d = (double)(height - 9) / 2.0;
            } else {
                d = 0.0;
            }
            double vpad = d;
            switch (vAlign) {
                case Above: {
                    rectY = y - (double)height;
                    textY = (float)(rectY + vpad + (double)(!fontRenderer.func_78260_a() ? 1 : 0));
                    break;
                }
                case Middle: {
                    rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                    textY = (float)(rectY + vpad);
                    break;
                }
                case Below: {
                    rectY = y;
                    textY = (float)(rectY + vpad);
                }
            }
            if (rotation != 0.0) {
                RenderSystem.translated((double)x, (double)y, (double)0.0);
                RenderSystem.rotatef((float)((float)(-rotation)), (float)0.0f, (float)0.0f, (float)1.0f);
                RenderSystem.translated((double)(-x), (double)(-y), (double)0.0);
            }
            if (drawRect) {
                int hpad = 2;
                DrawUtil.drawRectangle(mStack, rectX - 2.0 - 0.5, rectY, bgWidth + 4.0, bgHeight, bgColor, bgAlpha);
            }
            if (alpha < 1.0f) {
                color = RGB.toArbg(color, alpha);
            }
            RenderSystem.translated((double)((double)textX - Math.floor(textX)), (double)((double)textY - Math.floor(textY)), (double)0.0);
            if (fontShadow) {
                fontRenderer.func_243246_a(mStack, text, textX, textY, color.intValue());
            } else if (DropDownButton.Glyph.isGlyph(text.getString())) {
                fontRenderer.func_243248_b(mStack, text, textX, textY, color.intValue());
            } else {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1001.0f);
                fontRenderer.func_243248_b(mStack, text, textX, textY, color.intValue());
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1001.0f);
            }
        }
        finally {
            GL11.glPopMatrix();
        }
    }

    public static int getLabelHeight(FontRenderer fr, boolean fontShadow) {
        int vpad = fr.func_78260_a() ? 0 : (fontShadow ? 6 : 4);
        fr.getClass();
        return 9 + vpad;
    }

    public static void drawImage(MatrixStack mStack, TextureImpl texture, double x, double y, boolean flip, float scale, double rotation) {
        DrawUtil.drawQuad(mStack, texture, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, flip, rotation);
    }

    public static void drawImage(MatrixStack mStack, JMTexture texture, float alpha, double x, double y, boolean flip, float scale, double rotation) {
        DrawUtil.drawQuad(mStack, texture, 0xFFFFFF, alpha, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, false, rotation);
    }

    public static void drawClampedImage(MatrixStack mStack, TextureImpl texture, double x, double y, float scale, double rotation) {
        DrawUtil.drawClampedImage(mStack, texture, 0xFFFFFF, 1.0f, x, y, scale, rotation);
    }

    public static void drawClampedImage(MatrixStack mStack, TextureImpl texture, int color, float alpha, double x, double y, float scale, double rotation) {
        DrawUtil.drawQuad(mStack, texture, color, alpha, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, false, rotation);
    }

    public static void drawColoredImage(MatrixStack mStack, JMTexture texture, int color, float alpha, double x, double y, float scale, double rotation) {
        DrawUtil.drawQuad(mStack, texture, color, alpha, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, false, rotation);
    }

    public static void drawColoredSprite(MatrixStack mStack, TextureImpl texture, double displayWidth, double displayHeight, double spriteX, double spriteY, double spriteWidth, double spriteHeight, Integer color, float alpha, double x, double y, float scale, double rotation) {
        double texWidth = texture.getWidth();
        double texHeight = texture.getHeight();
        double minU = Math.max(0.0, spriteX / texWidth);
        double minV = Math.max(0.0, spriteY / texHeight);
        double maxU = Math.min(1.0, (spriteX + spriteWidth) / texWidth);
        double maxV = Math.min(1.0, (spriteY + spriteHeight) / texHeight);
        DrawUtil.drawQuad(mStack, texture, color, alpha, x, y, displayWidth * (double)scale, displayHeight * (double)scale, minU, minV, maxU, maxV, rotation, false, true, 770, 771, false);
    }

    public static void drawColoredImage(MatrixStack mStack, TextureImpl texture, int color, float alpha, double x, double y, double rotation) {
        DrawUtil.drawQuad(mStack, texture, color, alpha, x, y, texture.getWidth(), texture.getHeight(), false, rotation);
    }

    public static void drawWaypointIcon(MatrixStack mStack, TextureImpl texture, float scale, int color, float alpha, double x, double y, double rotation) {
        if (scale > 1.0f) {
            texture = texture.getScaledImage(scale);
            scale = 1.0f;
        }
        double width = (float)texture.getWidth() * scale;
        double height = (float)texture.getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        DrawUtil.drawQuad(mStack, texture, color, alpha, drawX, drawY, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, false, rotation);
    }

    public static void drawColoredImage(MatrixStack mStack, TextureImpl texture, int color, float alpha, double x, double y, int width, int height, double rotation) {
        DrawUtil.drawQuad(mStack, texture, color, alpha, x, y, width, height, false, rotation);
    }

    public static void drawQuad(MatrixStack mStack, TextureImpl texture, double x, double y, double width, double height, boolean flip, double rotation) {
        DrawUtil.drawQuad(mStack, texture, 0xFFFFFF, 1.0f, x, y, width, height, 0.0, 0.0, 1.0, 1.0, rotation, flip, true, 770, 771, false);
    }

    public static void drawQuad(MatrixStack mStack, JMTexture texture, int color, float alpha, double x, double y, double width, double height, boolean flip, double rotation) {
        DrawUtil.drawQuad(mStack, texture, color, alpha, x, y, width, height, 0.0, 0.0, 1.0, 1.0, rotation, flip, true, 770, 771, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawQuad(MatrixStack mStack, JMTexture texture, int color, float alpha, double x, double y, double width, double height, double minU, double minV, double maxU, double maxV, double rotation, boolean flip, boolean blend, int glBlendSfactor, int glBlendDFactor, boolean clampTexture) {
        GL11.glPushMatrix();
        try {
            if (blend) {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((int)glBlendSfactor, (int)glBlendDFactor, (int)1, (int)0);
            }
            RenderSystem.enableTexture();
            RenderSystem.bindTexture((int)texture.getTextureId());
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            if (blend) {
                float[] c = RGB.floats(color);
                GL11.glColor4f((float)c[0], (float)c[1], (float)c[2], (float)alpha);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            }
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            int texEdgeBehavior = clampTexture ? 33071 : 10497;
            GL11.glTexParameteri((int)3553, (int)10242, (int)texEdgeBehavior);
            GL11.glTexParameteri((int)3553, (int)10243, (int)texEdgeBehavior);
            if (rotation != 0.0) {
                double transX = x + width / 2.0;
                double transY = y + height / 2.0;
                RenderSystem.translated((double)transX, (double)transY, (double)0.0);
                RenderSystem.rotatef((float)((float)rotation), (float)0.0f, (float)0.0f, (float)1.0f);
                RenderSystem.translated((double)(-transX), (double)(-transY), (double)0.0);
            }
            double direction = flip ? -maxU : maxU;
            DrawUtil.startDrawingQuads(false);
            DrawUtil.addVertexWithUV(x, height + y, zLevel, minU, maxV);
            DrawUtil.addVertexWithUV(x + width, height + y, zLevel, direction, maxV);
            DrawUtil.addVertexWithUV(x + width, y, zLevel, direction, minV);
            DrawUtil.addVertexWithUV(x, y, zLevel, minU, minV);
            DrawUtil.draw();
            if (blend) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (glBlendSfactor != 770 || glBlendDFactor != 771) {
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                }
            }
        }
        finally {
            GL11.glPopMatrix();
        }
    }

    public static void drawRectangle(MatrixStack mStack, double x, double y, double width, double height, int color, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        int[] rgba = RGB.ints(color, alpha);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        DrawUtil.addVertex(mStack.func_227866_c_().func_227870_a_(), worldrenderer, x, height + y, zLevel, rgba);
        DrawUtil.addVertex(mStack.func_227866_c_().func_227870_a_(), worldrenderer, x + width, height + y, zLevel, rgba);
        DrawUtil.addVertex(mStack.func_227866_c_().func_227870_a_(), worldrenderer, x + width, y, zLevel, rgba);
        DrawUtil.addVertex(mStack.func_227866_c_().func_227870_a_(), worldrenderer, x, y, zLevel, rgba);
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableTexture();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
    }

    public static void drawPolygon(MatrixStack mStack, double xOffset, double yOffset, List<Point2D.Double> fillPoints, List<List<Point2D.Double>> strokePoints, ShapeProperties shapeProperties) {
        float[] rgba;
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.enableAlphaTest();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        if (shapeProperties.getFillOpacity() >= 0.01f) {
            rgba = RGB.floats(shapeProperties.getFillColor(), shapeProperties.getFillOpacity());
            GL11.glColor4f((float)rgba[0], (float)rgba[1], (float)rgba[2], (float)rgba[3]);
            int lastIndex = fillPoints.size() - 1;
            GL11.glBegin((int)4);
            for (int i = 0; i <= lastIndex; ++i) {
                Point2D.Double point = fillPoints.get(i);
                GL11.glVertex2d((double)(point.getX() + xOffset), (double)(point.getY() + yOffset));
            }
            GL11.glEnd();
        }
        if (shapeProperties.getStrokeOpacity() >= 0.01f && shapeProperties.getStrokeWidth() > 0.0f) {
            rgba = RGB.floats(shapeProperties.getStrokeColor(), shapeProperties.getStrokeOpacity());
            GL11.glColor4f((float)rgba[0], (float)rgba[1], (float)rgba[2], (float)rgba[3]);
            float stroke = shapeProperties.getStrokeWidth();
            GL11.glLineWidth((float)stroke);
            for (List<Point2D.Double> screenPoints : strokePoints) {
                int lastIndex = screenPoints.size() - 1;
                GL11.glBegin((int)3);
                Point2D.Double point = screenPoints.get(0);
                GL11.glVertex2d((double)(point.getX() + xOffset), (double)(point.getY() + yOffset));
                for (int i = 0; i <= lastIndex; ++i) {
                    int j = i < lastIndex ? i + 1 : 0;
                    point = screenPoints.get(j);
                    GL11.glVertex2d((double)(point.getX() + xOffset), (double)(point.getY() + yOffset));
                }
                GL11.glEnd();
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableTexture();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
    }

    public static void drawGradientRect(MatrixStack mStack, double x, double y, double width, double height, int startColor, float startAlpha, int endColor, float endAlpha) {
        if (startAlpha > 1.0f) {
            startAlpha /= 255.0f;
        }
        if (endAlpha > 1.0f) {
            endAlpha /= 255.0f;
        }
        int[] rgbaStart = RGB.ints(startColor, startAlpha);
        int[] rgbaEnd = RGB.ints(endColor, endAlpha);
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.shadeModel((int)7425);
        DrawUtil.startDrawingQuads(true);
        DrawUtil.addVertexWithUV(x, height + y, zLevel, 0.0, 1.0, rgbaEnd);
        DrawUtil.addVertexWithUV(x + width, height + y, zLevel, 1.0, 1.0, rgbaEnd);
        DrawUtil.addVertexWithUV(x + width, y, zLevel, 1.0, 0.0, rgbaStart);
        DrawUtil.addVertexWithUV(x, y, zLevel, 0.0, 0.0, rgbaStart);
        DrawUtil.draw();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableTexture();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
    }

    public static void drawBoundTexture(MatrixStack mStack, double startU, double startV, double startX, double startY, double z, double endU, double endV, double endX, double endY) {
        DrawUtil.startDrawingQuads(false);
        DrawUtil.addVertexWithUV(startX, endY, z, startU, endV);
        DrawUtil.addVertexWithUV(endX, endY, z, endU, endV);
        DrawUtil.addVertexWithUV(endX, startY, z, endU, startV);
        DrawUtil.addVertexWithUV(startX, startY, z, startU, startV);
        DrawUtil.draw();
    }

    public static void drawEntity(MatrixStack mStack, double x, double y, double heading, TextureImpl texture, float scale, double rotation) {
        DrawUtil.drawEntity(mStack, x, y, heading, texture, 1.0f, scale, rotation);
    }

    public static void drawEntity(MatrixStack mStack, double x, double y, double heading, JMTexture texture, float alpha, float scale, double rotation) {
        double width = (float)texture.getWidth() * scale;
        double height = (float)texture.getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        DrawUtil.drawImage(mStack, texture, alpha, drawX, drawY, false, scale, heading);
    }

    public static void drawColoredEntity(MatrixStack mStack, double x, double y, JMTexture texture, int color, float alpha, float scale, double rotation) {
        double width = (float)texture.getWidth() * scale;
        double height = (float)texture.getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        DrawUtil.drawColoredImage(mStack, texture, color, alpha, drawX, drawY, scale, rotation);
    }

    public static void sizeDisplay(double width, double height) {
        if (width > 0.0 && height > 0.0) {
            RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
            RenderSystem.matrixMode((int)5889);
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)width, (double)height, (double)0.0, (double)100.0, (double)ForgeHooksClient.getGuiFarPlane());
            RenderSystem.matrixMode((int)5888);
            RenderSystem.loadIdentity();
            RenderSystem.translated((double)0.0, (double)0.0, (double)(1000.0f - ForgeHooksClient.getGuiFarPlane()));
        }
    }

    public static void draw() {
        tessellator.func_78381_a();
    }

    public static void startDrawingQuads(boolean useColor) {
        if (useColor) {
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        } else {
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        }
    }

    public static void addVertexWithUV(double x, double y, double z, double u, double v) {
        worldrenderer.func_225582_a_(x, y, z).func_225583_a_((float)u, (float)v).func_181675_d();
    }

    public static void addVertex(double x, double y, double z, int[] rgba) {
        worldrenderer.func_225582_a_(x, y, z).func_225583_a_(1.0f, 1.0f).func_225586_a_(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
    }

    private static void addVertex(Matrix4f mat, BufferBuilder buff, double x, double y, double z, int[] rgba) {
        buff.func_227888_a_(mat, (float)x, (float)y, (float)z).func_225586_a_(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
    }

    public static void addVertexWithUV(double x, double y, double z, double u, double v, int[] rgba) {
        worldrenderer.func_225582_a_(x, y, z).func_225583_a_((float)u, (float)v).func_225586_a_(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
    }

    public static enum VAlign {
        Above,
        Middle,
        Below;

    }

    public static enum HAlign {
        Left,
        Center,
        Right;

    }
}

