/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data.source;

import java.util.concurrent.atomic.AtomicInteger;
import net.gegy1000.terrarium.Terrarium;
import net.gegy1000.terrarium.server.TerrariumUserTracker;
import net.gegy1000.terrarium.server.message.DataFailWarningMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="terrarium")
public class ErrorBroadcastHandler {
    private static final long FAIL_NOTIFICATION_INTERVAL = 10000L;
    private static final AtomicInteger FAIL_COUNT = new AtomicInteger();
    private static long lastFailNotificationTime;

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        lastFailNotificationTime = System.currentTimeMillis();
    }

    @SubscribeEvent
    public static void onTick(TickEvent event) {
        long time = System.currentTimeMillis();
        if (time - lastFailNotificationTime > 10000L) {
            int failCount = FAIL_COUNT.get();
            if (failCount > 0) {
                ErrorBroadcastHandler.broadcastFailNotification(failCount);
                FAIL_COUNT.set(0);
            }
            lastFailNotificationTime = time;
        }
    }

    private static void broadcastFailNotification(int failCount) {
        DataFailWarningMessage message = new DataFailWarningMessage(failCount);
        for (EntityPlayer player : TerrariumUserTracker.getTerrariumUsers()) {
            Terrarium.NETWORK.sendTo((IMessage)message, (EntityPlayerMP)player);
        }
    }

    public static void recordFailure() {
        FAIL_COUNT.getAndIncrement();
    }
}

