/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.chunk.tracker;

import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import net.gegy1000.terrarium.Terrarium;
import net.gegy1000.terrarium.server.world.chunk.tracker.ChunkTrackerAccess;
import net.gegy1000.terrarium.server.world.chunk.tracker.SavedColumnTracker;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ColumnTrackerAccess
implements ChunkTrackerAccess {
    private static Field entriesWithoutChunksField;
    private final WorldServer world;
    private final LongSortedSet bufferColumns = new LongLinkedOpenHashSet();

    public ColumnTrackerAccess(WorldServer world) {
        this.world = world;
    }

    @Override
    public LongSortedSet getSortedQueuedColumns() {
        LongLinkedOpenHashSet queuedColumns = new LongLinkedOpenHashSet();
        this.bufferColumns.clear();
        List<PlayerChunkMapEntry> entriesWithoutChunks = ColumnTrackerAccess.getEntriesWithoutChunks(this.world.func_184164_w());
        for (PlayerChunkMapEntry entry : entriesWithoutChunks) {
            ChunkPos pos = entry.func_187264_a();
            boolean queued = !SavedColumnTracker.isSaved((World)this.world, pos);
            if (!queued) continue;
            queuedColumns.add(ChunkPos.func_77272_a((int)pos.field_77276_a, (int)pos.field_77275_b));
            for (int z = -6; z <= 6; ++z) {
                for (int x = -6; x <= 6; ++x) {
                    if (x == 0 && z == 0) continue;
                    this.bufferColumns.add(ChunkPos.func_77272_a((int)(x + pos.field_77276_a), (int)(z + pos.field_77275_b)));
                }
            }
        }
        queuedColumns.addAll((LongCollection)this.bufferColumns);
        return queuedColumns;
    }

    private static List<PlayerChunkMapEntry> getEntriesWithoutChunks(PlayerChunkMap chunkTracker) {
        if (entriesWithoutChunksField != null) {
            try {
                return (List)entriesWithoutChunksField.get(chunkTracker);
            }
            catch (ReflectiveOperationException e) {
                Terrarium.LOGGER.error("Failed to get entriesWithoutChunks", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    static {
        try {
            entriesWithoutChunksField = ObfuscationReflectionHelper.findField(PlayerChunkMap.class, (String)"field_187311_h");
        }
        catch (ReflectionHelper.UnableToFindFieldException e) {
            Terrarium.LOGGER.error("Failed to find entriesWithoutChunks field", (Throwable)e);
        }
    }
}

