/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.gegy1000.terrarium.Terrarium;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ProgressManager;
import org.apache.commons.io.FilenameUtils;

public class JsonDiscoverer<T> {
    private final Function<JsonObject, T> parser;

    public JsonDiscoverer(Function<JsonObject, T> parser) {
        this.parser = parser;
    }

    public List<Result<T>> discoverFiles(String dataRoot, String basePath) {
        List activeModList = Loader.instance().getActiveModList();
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Discovering files", (int)activeModList.size());
        ArrayList<Result<T>> discoveries = new ArrayList<Result<T>>();
        for (ModContainer mod : activeModList) {
            bar.step(mod.getName());
            String base = dataRoot + "/" + mod.getModId() + "/" + basePath;
            CraftingHelper.findFiles((ModContainer)mod, (String)base, root -> true, (root, path) -> {
                Path relativePath = root.relativize((Path)path);
                if (!"json".equals(FilenameUtils.getExtension((String)path.toString())) || relativePath.getNameCount() > 1) {
                    return true;
                }
                String name = FilenameUtils.removeExtension((String)relativePath.toString()).replaceAll("\\\\", "/");
                ResourceLocation key = new ResourceLocation(mod.getModId(), name);
                try (BufferedReader reader = Files.newBufferedReader(path);){
                    JsonObject rootObject = new JsonParser().parse((Reader)reader).getAsJsonObject();
                    discoveries.add(new Result(key, this.parser.apply(rootObject)));
                }
                catch (JsonParseException e) {
                    Terrarium.LOGGER.error("Couldn't parse JSON for {}", (Object)key, (Object)e);
                }
                catch (IOException e) {
                    Terrarium.LOGGER.error("Couldn't read JSON {} from {}", (Object)key, path, (Object)e);
                }
                return true;
            }, (boolean)false, (boolean)false);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        return discoveries;
    }

    public static class Result<T> {
        private final ResourceLocation key;
        private final T parsed;

        private Result(ResourceLocation key, T parsed) {
            this.key = key;
            this.parsed = parsed;
        }

        public ResourceLocation getKey() {
            return this.key;
        }

        public T getParsed() {
            return this.parsed;
        }
    }
}

