/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.client.gui.widget;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleFunction;
import net.gegy1000.terrarium.client.gui.GuiRenderUtils;
import net.gegy1000.terrarium.client.gui.widget.TooltipRenderer;
import net.gegy1000.terrarium.server.world.generator.customization.property.PropertyPair;
import net.gegy1000.terrarium.server.world.generator.customization.widget.SliderScale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SliderGuiWidget
extends GuiButtonExt
implements TooltipRenderer {
    private final PropertyPair<Number> property;
    private final DoubleFunction<String> display;
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private final SliderScale scale;
    private final double min;
    private final double max;
    private final double step;
    private final double fineStep;
    private double position;
    private boolean mouseDown;
    private float hoverTime;

    public SliderGuiWidget(PropertyPair<Number> property, double min, double max, double step, double fineStep, DoubleFunction<String> display, SliderScale scale) {
        super(0, 0, 0, 150, 20, "");
        this.property = property;
        this.display = display;
        this.scale = scale;
        this.min = min;
        this.max = max;
        this.step = step;
        this.fineStep = fineStep;
        this.setValue(((Number)property.value.get()).doubleValue());
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public void setSliderPosition(double position) {
        this.position = position;
        this.updateDisplayString(this.toValue(position));
    }

    public void setValue(double value) {
        this.position = this.toPosition(value);
        this.updateDisplayString(value);
    }

    private void updateDisplayString(double value) {
        String valueString = this.display != null ? this.display.apply(value) : String.format("%.2f", value);
        this.field_146126_j = String.format("%s: %s", this.property.key.getLocalizedName(), valueString);
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            super.func_191745_a(mc, mouseX, mouseY, partialTicks);
            this.hoverTime = super.func_146116_c(mc, mouseX, mouseY) ? (this.hoverTime += partialTicks) : 0.0f;
        }
    }

    @Override
    public void renderTooltip(int mouseX, int mouseY) {
        if (this.hoverTime >= 15.0f) {
            String name = TextFormatting.BLUE + this.property.key.getLocalizedName();
            String tooltip = TextFormatting.GRAY + this.property.key.getLocalizedTooltip();
            String defaults = TextFormatting.YELLOW + I18n.func_135052_a((String)"property.terrarium.slider_range.name", (Object[])new Object[]{this.min, this.max});
            ArrayList lines = Lists.newArrayList((Object[])new String[]{name, tooltip, defaults});
            if (Math.abs(this.step - this.fineStep) > 1.0E-6) {
                lines.add(TextFormatting.DARK_GRAY.toString() + TextFormatting.ITALIC + I18n.func_135052_a((String)"property.terrarium.slider_fine.name", (Object[])new Object[0]));
            }
            GuiRenderUtils.drawTooltip(lines, mouseX, mouseY);
        }
    }

    protected int func_146114_a(boolean mouseOver) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            if (this.mouseDown) {
                this.setSliderPosition(MathHelper.func_151237_a((double)this.getMousePosition(mouseX), (double)0.0, (double)1.0));
                this.notifyValue();
                this.hoverTime = 0.0f;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.position * (double)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.position * (double)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            this.setSliderPosition(MathHelper.func_151237_a((double)this.getMousePosition(mouseX), (double)0.0, (double)1.0));
            this.mouseDown = true;
            return true;
        }
        return false;
    }

    private double getMousePosition(int mouseX) {
        return this.stepped((double)(mouseX - (this.field_146128_h + 4)) / (double)(this.field_146120_f - 8));
    }

    public void func_146118_a(int mouseX, int mouseY) {
        if (this.mouseDown) {
            this.mouseDown = false;
            this.notifyValue();
        }
    }

    private void notifyValue() {
        double value = this.toValue(this.position);
        if (Math.abs(((Number)this.property.value.get()).doubleValue() - value) > 1.0E-6) {
            this.property.value.set(value);
            this.listeners.forEach(Runnable::run);
        }
    }

    private double stepped(double position) {
        return this.stepped(position, GuiScreen.func_146272_n() ? this.fineStep : this.step);
    }

    private double stepped(double position, double step) {
        double value = this.toValue(position);
        double stepped = value - value % step;
        return this.toPosition(stepped);
    }

    private double toPosition(double value) {
        return this.scale.reverse(SliderGuiWidget.toPosition(value, this.min, this.max));
    }

    private static double toPosition(double value, double min, double max) {
        double clampedValue = MathHelper.func_151237_a((double)value, (double)min, (double)max);
        return (clampedValue - min) / (max - min);
    }

    private double toValue(double position) {
        return SliderGuiWidget.toValue(this.scale.apply(position), this.min, this.max);
    }

    private static double toValue(double position, double min, double max) {
        double value = min + (max - min) * position;
        return MathHelper.func_151237_a((double)value, (double)min, (double)max);
    }
}

