/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.client.gui.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class ListGuiWidget
extends GuiListExtended {
    public ListGuiWidget(Minecraft client, int screenWidth, int screenHeight, int x, int y, int width, int height, int slotHeight) {
        super(client, screenWidth, screenHeight, y, y + height, slotHeight);
        this.field_148152_e = x;
        this.field_148151_d = x + width;
    }

    public int func_148124_c(int posX, int posY) {
        int scrolledY = posY - this.field_148153_b - this.field_148160_j + (int)this.field_148169_q - 4;
        int slotIndex = scrolledY / this.field_148149_f;
        if (posX >= this.field_148152_e && posX <= this.field_148151_d && slotIndex >= 0 && scrolledY >= 0 && slotIndex < this.func_148127_b() && posX < this.func_148137_d()) {
            return slotIndex;
        }
        return -1;
    }

    public boolean func_148179_a(int mouseX, int mouseY, int mouseEvent) {
        int slotIndex;
        if (this.func_148141_e(mouseY) && (slotIndex = this.func_148124_c(mouseX, mouseY)) >= 0) {
            int minEntryX = this.field_148152_e + 2;
            int minEntryY = this.field_148153_b + 4 - this.func_148148_g() + slotIndex * this.field_148149_f + this.field_148160_j;
            int localX = mouseX - minEntryX;
            int localY = mouseY - minEntryY;
            if (this.func_148180_b(slotIndex).func_148278_a(slotIndex, mouseX, mouseY, mouseEvent, localX, localY)) {
                this.func_148143_b(false);
                return true;
            }
        }
        return false;
    }

    public boolean func_148181_b(int x, int y, int mouseEvent) {
        for (int i = 0; i < this.func_148127_b(); ++i) {
            int minEntryX = this.field_148152_e + 2;
            int minEntryY = this.field_148153_b + 4 - this.func_148148_g() + i * this.field_148149_f + this.field_148160_j;
            int localX = x - minEntryX;
            int localY = y - minEntryY;
            this.func_148180_b(i).func_148277_b(i, x, y, mouseEvent, localX, localY);
        }
        this.func_148143_b(true);
        return false;
    }

    public void func_148128_a(int mouseX, int mouseY, float partialTicks) {
        if (this.field_178041_q) {
            this.field_148150_g = mouseX;
            this.field_148162_h = mouseY;
            this.func_148123_a();
            int minBarX = this.func_148137_d();
            int maxBarX = minBarX + 6;
            this.func_148121_k();
            int minEntryX = this.field_148152_e + 2;
            int minEntryY = this.field_148153_b + 4 - MathHelper.func_76141_d((float)this.field_148169_q);
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            this.drawContainerBackground(tessellator);
            if (this.field_148165_u) {
                this.func_148129_a(minEntryX, minEntryY, tessellator);
            }
            this.func_192638_a(minEntryX, minEntryY, mouseX, mouseY, partialTicks);
            GlStateManager.func_179097_i();
            this.func_148136_c(0, this.field_148153_b, 255, 255);
            this.func_148136_c(this.field_148154_c, this.field_148158_l, 255, 255);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179118_c();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179090_x();
            this.drawEdgeShadow(tessellator, builder);
            this.drawScrollbar(minBarX, maxBarX, tessellator, builder);
            this.func_148142_b(mouseX, mouseY);
            GlStateManager.func_179098_w();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
        }
    }

    private void drawEdgeShadow(Tessellator tessellator, BufferBuilder builder) {
        int shadowSize = 4;
        builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        builder.func_181662_b((double)this.field_148152_e, (double)(this.field_148153_b + shadowSize), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        builder.func_181662_b((double)this.field_148151_d, (double)(this.field_148153_b + shadowSize), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        builder.func_181662_b((double)this.field_148151_d, (double)this.field_148153_b, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        builder.func_181662_b((double)this.field_148152_e, (double)this.field_148153_b, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        tessellator.func_78381_a();
        builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        builder.func_181662_b((double)this.field_148152_e, (double)this.field_148154_c, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        builder.func_181662_b((double)this.field_148151_d, (double)this.field_148154_c, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        builder.func_181662_b((double)this.field_148151_d, (double)(this.field_148154_c - shadowSize), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        builder.func_181662_b((double)this.field_148152_e, (double)(this.field_148154_c - shadowSize), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        tessellator.func_78381_a();
    }

    private void drawScrollbar(int minBarX, int maxBarX, Tessellator tessellator, BufferBuilder builder) {
        int maxScroll = this.func_148135_f();
        if (maxScroll > 0) {
            int height = this.field_148154_c - this.field_148153_b;
            int barY = this.getBarY();
            int barSize = Math.max((int)this.field_148169_q * (height - barY) / maxScroll + this.field_148153_b, this.field_148153_b);
            builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            builder.func_181662_b((double)minBarX, (double)this.field_148154_c, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            builder.func_181662_b((double)maxBarX, (double)this.field_148154_c, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            builder.func_181662_b((double)maxBarX, (double)this.field_148153_b, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            builder.func_181662_b((double)minBarX, (double)this.field_148153_b, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            builder.func_181662_b((double)minBarX, (double)(barSize + barY), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            builder.func_181662_b((double)maxBarX, (double)(barSize + barY), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            builder.func_181662_b((double)maxBarX, (double)barSize, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            builder.func_181662_b((double)minBarX, (double)barSize, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            tessellator.func_78381_a();
            builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            builder.func_181662_b((double)minBarX, (double)(barSize + barY - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            builder.func_181662_b((double)(maxBarX - 1), (double)(barSize + barY - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            builder.func_181662_b((double)(maxBarX - 1), (double)barSize, 0.0).func_187315_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            builder.func_181662_b((double)minBarX, (double)barSize, 0.0).func_187315_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    protected void func_192638_a(int minEntryX, int minEntryY, int mouseXIn, int mouseYIn, float partialTicks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        for (int slotIndex = 0; slotIndex < this.func_148127_b(); ++slotIndex) {
            int entryY = minEntryY + slotIndex * this.field_148149_f + this.field_148160_j;
            int entryHeight = this.field_148149_f - 4;
            if (entryY > this.field_148154_c || entryY + entryHeight < this.field_148153_b) {
                this.func_192639_a(slotIndex, minEntryX, entryY, partialTicks);
            }
            if (this.field_148166_t && this.func_148131_a(slotIndex)) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179090_x();
                builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                builder.func_181662_b((double)this.field_148152_e, (double)(entryY + entryHeight + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                builder.func_181662_b((double)this.field_148151_d, (double)(entryY + entryHeight + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                builder.func_181662_b((double)this.field_148151_d, (double)(entryY - 2), 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                builder.func_181662_b((double)this.field_148152_e, (double)(entryY - 2), 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                builder.func_181662_b((double)(this.field_148152_e + 1), (double)(entryY + entryHeight + 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                builder.func_181662_b((double)(this.field_148151_d - 1), (double)(entryY + entryHeight + 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                builder.func_181662_b((double)(this.field_148151_d - 1), (double)(entryY - 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                builder.func_181662_b((double)(this.field_148152_e + 1), (double)(entryY - 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179098_w();
            }
            this.func_192637_a(slotIndex, minEntryX, entryY, entryHeight, mouseXIn, mouseYIn, partialTicks);
        }
    }

    public void func_178039_p() {
        if (this.func_148141_e(this.field_148162_h)) {
            int localY = this.field_148162_h - this.field_148153_b - this.field_148160_j + (int)this.field_148169_q - 4;
            int clickedSlot = localY / this.field_148149_f;
            if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState() && this.field_148162_h >= this.field_148153_b && this.field_148162_h <= this.field_148154_c) {
                this.handleSlotClick(localY, clickedSlot, false);
            }
            if (Mouse.isButtonDown((int)0) && this.func_148125_i()) {
                if (this.field_148157_o == -1) {
                    boolean shouldScroll = true;
                    if (this.field_148162_h >= this.field_148153_b && this.field_148162_h <= this.field_148154_c) {
                        if (!this.handleSlotClick(localY, clickedSlot, true)) {
                            shouldScroll = false;
                        }
                        int minBarX = this.func_148137_d();
                        int maxBarX = minBarX + 6;
                        if (this.field_148150_g >= minBarX && this.field_148150_g <= maxBarX) {
                            float maxScroll = Math.max(this.func_148135_f(), 1);
                            int barY = this.getBarY();
                            this.field_148170_p = -1.0f / ((float)(this.field_148154_c - this.field_148153_b - barY) / maxScroll);
                        } else {
                            this.field_148170_p = 1.0f;
                        }
                        this.field_148157_o = shouldScroll ? this.field_148162_h : -2;
                    } else {
                        this.field_148157_o = -2;
                    }
                } else if (this.field_148157_o >= 0) {
                    this.field_148169_q -= (float)(this.field_148162_h - this.field_148157_o) * this.field_148170_p;
                    this.field_148157_o = this.field_148162_h;
                }
            } else {
                this.field_148157_o = -1;
            }
            int deltaWheel = Mouse.getEventDWheel();
            if (deltaWheel != 0) {
                this.field_148169_q -= (float)(MathHelper.func_76125_a((int)deltaWheel, (int)-1, (int)1) * this.field_148149_f) / 2.0f;
            }
        }
    }

    private boolean handleSlotClick(int localY, int clickedSlot, boolean scroll) {
        if (clickedSlot < this.func_148127_b() && this.field_148150_g >= this.field_148152_e && this.field_148150_g <= this.field_148151_d && clickedSlot >= 0 && localY >= 0) {
            boolean doubleClicked = scroll && clickedSlot == this.field_148168_r && Minecraft.func_71386_F() - this.field_148167_s < 250L;
            this.func_148144_a(clickedSlot, doubleClicked, this.field_148150_g, this.field_148162_h);
            this.field_148168_r = clickedSlot;
            if (scroll) {
                this.field_148167_s = Minecraft.func_71386_F();
            }
        } else if (this.field_148150_g >= this.field_148152_e && this.field_148150_g <= this.field_148151_d && localY < 0) {
            this.func_148132_a(this.field_148150_g - this.field_148152_e, this.field_148162_h - this.field_148153_b + (int)this.field_148169_q - 4);
            return false;
        }
        return true;
    }

    private int getBarY() {
        int height = this.field_148154_c - this.field_148153_b;
        return MathHelper.func_76125_a((int)(height * height / this.func_148138_e()), (int)32, (int)(height - 8));
    }

    public int func_148139_c() {
        return this.field_148151_d - this.field_148152_e;
    }

    protected int func_148137_d() {
        return this.field_148151_d - 6;
    }
}

