/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.ecology.vegetation;

import net.gegy1000.earth.server.world.ecology.GrowthIndicator;
import net.gegy1000.earth.server.world.ecology.maxent.MaxentGrowthIndicator;
import net.gegy1000.earth.server.world.ecology.vegetation.TreeGenerators;
import net.gegy1000.earth.server.world.ecology.vegetation.Vegetation;
import net.minecraft.util.ResourceLocation;

public final class Trees {
    public static final float RADIUS = 3.0f;
    private static final TreeGenerators GENERATORS = TreeGenerators.collect();
    public static final Vegetation ACACIA = Vegetation.builder().generator(Trees.GENERATORS.acacia).growthIndicator(Indicators.ACACIA).build();
    public static final Vegetation BIRCH = Vegetation.builder().generator(Trees.GENERATORS.birch).growthIndicator(Indicators.BIRCH).build();
    public static final Vegetation OAK = Vegetation.builder().generator(Trees.GENERATORS.oak).growthIndicator(Indicators.OAK).build();
    public static final Vegetation JUNGLE = Vegetation.builder().generator(Trees.GENERATORS.jungle).growthIndicator(Indicators.JUNGLE_LIKE).build();
    public static final Vegetation BIG_JUNGLE = Vegetation.builder().generator(Trees.GENERATORS.bigJungle).growthIndicator(Indicators.JUNGLE_LIKE.pow(3.0f)).build();
    public static final Vegetation SPRUCE = Vegetation.builder().generator(Trees.GENERATORS.spruce).growthIndicator(Indicators.SPRUCE).build();
    public static final Vegetation PINE = Vegetation.builder().generator(Trees.GENERATORS.pine).growthIndicator(Indicators.PINE).build();

    public static class Indicators {
        public static final GrowthIndicator ACACIA = Indicators.maxentIndicator("acacia");
        public static final GrowthIndicator BIRCH = Indicators.maxentIndicator("birch").pow(0.7692308f);
        public static final GrowthIndicator OAK = Indicators.maxentIndicator("oak");
        public static final GrowthIndicator JUNGLE_LIKE = Indicators.maxentIndicator("jungle_like");
        public static final GrowthIndicator SPRUCE = Indicators.maxentIndicator("spruce");
        public static final GrowthIndicator PINE = Indicators.maxentIndicator("pine");

        private static GrowthIndicator maxentIndicator(String path) {
            return MaxentGrowthIndicator.tryParse(new ResourceLocation("earth", "vegetation/models/trees/" + path + ".lambdas")).orElse(GrowthIndicator.no());
        }
    }
}

