/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.ecology.soil;

import net.gegy1000.earth.server.world.Climate;
import net.gegy1000.earth.server.world.cover.Cover;
import net.gegy1000.earth.server.world.cover.CoverMarkers;
import net.gegy1000.earth.server.world.ecology.GrowthPredictors;
import net.gegy1000.earth.server.world.ecology.soil.SoilOrder;
import net.gegy1000.earth.server.world.ecology.soil.SoilSuborder;
import net.gegy1000.earth.server.world.ecology.soil.SoilTexture;
import net.gegy1000.earth.server.world.ecology.soil.SoilTextures;
import net.gegy1000.earth.server.world.geography.Landform;

public final class SoilSelector {
    private static final int VERY_GRASSY_OCC = 40;
    private static final int GRASSY_OCC = 9;

    private SoilSelector() {
    }

    public static boolean isDesertLike(GrowthPredictors predictors) {
        SoilTexture texture = SoilSelector.select(predictors);
        return texture == SoilTextures.DESERT_SAND || texture == SoilTextures.SAND || texture == SoilTextures.DESERT_RED_SAND || texture == SoilTextures.RED_SAND;
    }

    public static SoilTexture select(GrowthPredictors predictors) {
        if (predictors.landform == Landform.SEA) {
            return SoilTextures.OCEAN_FLOOR;
        }
        if (predictors.landform == Landform.BEACH) {
            return SoilTextures.BEACH;
        }
        if (predictors.landform == Landform.LAKE_OR_RIVER) {
            return SoilTextures.RIVER_BED;
        }
        if (predictors.cover == Cover.PERMANENT_SNOW || predictors.soilSuborder == SoilSuborder.ICE) {
            return SoilTextures.SNOW;
        }
        if (predictors.soilSuborder == SoilSuborder.ROCK) {
            return SoilTextures.ROCK;
        }
        if (predictors.soilSuborder == SoilSuborder.SHIFTING_SAND) {
            return SoilTextures.SAND;
        }
        SoilTexture texture = SoilSelector.selectLand(predictors);
        if (predictors.cover.is(CoverMarkers.CONSOLIDATED)) {
            texture = SoilSelector.consolidate(texture);
        }
        if (predictors.soilSuborder.order == SoilOrder.SPODOSOL && texture == SoilTextures.GRASS) {
            texture = SoilTextures.GRASS_AND_PODZOL;
        }
        if (predictors.cover.is(CoverMarkers.BARREN)) {
            if (texture == SoilTextures.SAND) {
                return SoilTextures.DESERT_SAND;
            }
            if (texture == SoilTextures.RED_SAND) {
                return SoilTextures.DESERT_RED_SAND;
            }
        }
        return texture;
    }

    private static SoilTexture selectLand(GrowthPredictors predictors) {
        boolean grassy;
        if (predictors.organicCarbonContent > 40) {
            return SoilTextures.GRASS;
        }
        boolean bl = grassy = predictors.organicCarbonContent > 9 && !Climate.isVeryDry(predictors.annualRainfall);
        if (grassy) {
            return SoilSelector.selectGrassy(predictors);
        }
        return SoilSelector.selectNotGrassy(predictors);
    }

    private static SoilTexture selectGrassy(GrowthPredictors predictors) {
        boolean sandy = SoilSelector.isSandy(predictors.soilSuborder);
        return sandy ? SoilTextures.GRASS_AND_SAND : SoilTextures.GRASS;
    }

    private static SoilTexture selectNotGrassy(GrowthPredictors predictors) {
        boolean sandy = SoilSelector.isSandy(predictors.soilSuborder);
        if (predictors.soilSuborder == SoilSuborder.ORTHENTS) {
            if (predictors.slope <= 50) {
                return SoilTextures.SAND;
            }
            return SoilTextures.MESA;
        }
        return sandy ? SoilTextures.SAND : SoilTextures.GRASS_AND_DIRT;
    }

    private static boolean isSandy(SoilSuborder suborder) {
        switch (suborder) {
            case PSAMMENTS: 
            case SALIDS: 
            case ARENTS: 
            case ARGIDS: 
            case CAMBIDS: 
            case USTEPTS: 
            case USTOX: 
            case XEREPTS: 
            case XEROLLS: 
            case XERALFS: 
            case XERANDS: {
                return true;
            }
        }
        return false;
    }

    private static SoilTexture consolidate(SoilTexture texture) {
        if (texture == SoilTextures.SAND) {
            return SoilTextures.MESA;
        }
        return SoilTextures.ROCK;
    }
}

