/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.data.source;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.gegy1000.terrarium.server.world.coordinate.CoordinateReference;
import org.tukaani.xz.SingleXZInputStream;

public final class WorldClimateRaster {
    public static final int WIDTH = 4320;
    public static final int HEIGHT = 2160;
    private static final float STANDARD_TEMPERATURE = 14.0f;
    private static final short STANDARD_RAINFALL = 600;
    private static final int PACK_RANGE = 255;
    private static final float TEMP_MIN = -40.0f;
    private static final float TEMP_MAX = 45.0f;
    private static final float TEMP_RANGE = 85.0f;
    private static final float TEMP_CURVE = 1.0f;
    private static final float RAIN_MIN = 0.0f;
    private static final float RAIN_RANGE = 7200.0f;
    private static final float RAIN_CURVE = 2.3f;
    private final float[] meanTemperature;
    private final float[] minTemperature;
    private final short[] annualRainfall;

    private WorldClimateRaster(float[] meanTemperature, float[] minTemperature, short[] annualRainfall) {
        this.meanTemperature = meanTemperature;
        this.minTemperature = minTemperature;
        this.annualRainfall = annualRainfall;
    }

    public static WorldClimateRaster parse(InputStream in) throws IOException {
        DataInputStream data = new DataInputStream(new SingleXZInputStream(in));
        byte[] meanTemperaturePacked = new byte[9331200];
        data.readFully(meanTemperaturePacked);
        float[] meanTemperature = WorldClimateRaster.unpackTemperature(meanTemperaturePacked);
        byte[] minTemperaturePacked = new byte[9331200];
        data.readFully(minTemperaturePacked);
        float[] minTemperature = WorldClimateRaster.unpackTemperature(minTemperaturePacked);
        byte[] annualRainfallPacked = new byte[9331200];
        data.readFully(annualRainfallPacked);
        short[] annualRainfall = WorldClimateRaster.unpackRainfall(annualRainfallPacked);
        return new WorldClimateRaster(meanTemperature, minTemperature, annualRainfall);
    }

    private static float[] unpackTemperature(byte[] packed) {
        float[] unpacked = new float[packed.length];
        for (int i = 0; i < unpacked.length; ++i) {
            unpacked[i] = WorldClimateRaster.unpackTemperature(packed[i]);
        }
        return unpacked;
    }

    private static float unpackTemperature(byte packed) {
        float shifted = packed & 0xFF;
        double unpacked = 85.0 * Math.pow(shifted / 255.0f, 1.0);
        return (float)(-40.0 + unpacked);
    }

    private static short[] unpackRainfall(byte[] packed) {
        short[] unpacked = new short[packed.length];
        for (int i = 0; i < unpacked.length; ++i) {
            unpacked[i] = WorldClimateRaster.unpackRainfall(packed[i]);
        }
        return unpacked;
    }

    private static short unpackRainfall(byte packed) {
        float shifted = packed & 0xFF;
        double unpacked = 7200.0 * Math.pow(shifted / 255.0f, 2.3f);
        return (short)(0.0 + unpacked);
    }

    public static CoordinateReference crs(double worldScale) {
        double scale = 9276.624305555555 / worldScale;
        return CoordinateReference.scaleAndOffset(scale, scale, -2160.0, -1080.0);
    }

    public float getMeanTemperature(int x, int y) {
        if (WorldClimateRaster.outOfBounds(x, y)) {
            return 14.0f;
        }
        return this.meanTemperature[WorldClimateRaster.index(x, y)];
    }

    public float getMinTemperature(int x, int y) {
        if (WorldClimateRaster.outOfBounds(x, y)) {
            return 14.0f;
        }
        return this.minTemperature[WorldClimateRaster.index(x, y)];
    }

    public short getAnnualRainfall(int x, int y) {
        if (WorldClimateRaster.outOfBounds(x, y)) {
            return 600;
        }
        return this.annualRainfall[WorldClimateRaster.index(x, y)];
    }

    private static int index(int x, int y) {
        return x + y * 4320;
    }

    private static boolean outOfBounds(int x, int y) {
        return x < 0 || y < 0 || x >= 4320 || y >= 2160;
    }

    public int getWidth() {
        return 4320;
    }

    public int getHeight() {
        return 2160;
    }
}

