/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.compatibility;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.gegy1000.earth.server.world.compatibility.ColumnCompatibilityWorld;
import net.gegy1000.terrarium.Terrarium;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.capabilities.Capability;

class CompatibilityChunk
extends Chunk {
    private final ColumnCompatibilityWorld compatibilityWorld;
    private final Chunk parent;

    CompatibilityChunk(ColumnCompatibilityWorld compatibilityWorld, Chunk parent) {
        super(parent.func_177412_p(), parent.field_76635_g, parent.field_76647_h);
        this.compatibilityWorld = compatibilityWorld;
        this.parent = parent;
    }

    protected void func_186034_a(IChunkGenerator generator) {
    }

    public void func_186030_a(IChunkProvider chunkProvider, IChunkGenerator chunkGenrator) {
    }

    protected void func_76590_a() {
    }

    public void func_76603_b() {
    }

    public void func_150809_p() {
    }

    public void func_76594_o() {
    }

    public void func_76613_n() {
    }

    public void func_150804_b(boolean skipRecheckGaps) {
    }

    public void func_76602_a(ExtendedBlockStorage[] newStorageArrays) {
        Terrarium.LOGGER.warn("Unsupported setStorageArrays on compatibility chunk");
    }

    public void func_76616_a(byte[] biomeArray) {
        Terrarium.LOGGER.warn("Unsupported setBiomeArray on compatibility chunk");
    }

    public void func_177420_a(int[] newHeightMap) {
        Terrarium.LOGGER.warn("Unsupported setHeightMap on compatibility chunk");
    }

    @Nullable
    public IBlockState func_177436_a(BlockPos pos, IBlockState state) {
        return this.parent.func_177436_a(this.compatibilityWorld.translatePos(pos), state);
    }

    public IBlockState func_186032_a(int x, int y, int z) {
        return this.parent.func_186032_a(x, y + this.compatibilityWorld.minY, z);
    }

    @Nullable
    public TileEntity func_177424_a(BlockPos pos, Chunk.EnumCreateEntityType mode) {
        return this.parent.func_177424_a(this.compatibilityWorld.translatePos(pos), mode);
    }

    public void func_150813_a(TileEntity tileEntity) {
        tileEntity.func_174878_a(this.compatibilityWorld.translatePos(tileEntity.func_174877_v()).func_185334_h());
        this.parent.func_150813_a(tileEntity);
    }

    public void func_177426_a(BlockPos pos, TileEntity tileEntity) {
        pos = this.compatibilityWorld.translatePos(pos).func_185334_h();
        this.parent.func_177426_a(pos, tileEntity);
    }

    public void func_177425_e(BlockPos pos) {
        this.parent.func_177425_e(this.compatibilityWorld.translatePos(pos));
    }

    public Map<BlockPos, TileEntity> func_177434_r() {
        return Collections.emptyMap();
    }

    public int func_76611_b(int x, int z) {
        return this.compatibilityWorld.untranslateY(this.parent.func_76611_b(x, z));
    }

    public BlockPos func_177440_h(BlockPos pos) {
        BlockPos parent = this.parent.func_177440_h(pos);
        int y = this.compatibilityWorld.untranslateY(parent.func_177956_o());
        return new BlockPos(parent.func_177958_n(), y, parent.func_177952_p());
    }

    public boolean func_177444_d(BlockPos pos) {
        return this.parent.func_177444_d(this.compatibilityWorld.translatePos(pos));
    }

    public int func_177413_a(EnumSkyBlock type, BlockPos pos) {
        return this.parent.func_177413_a(type, this.compatibilityWorld.translatePos(pos));
    }

    public int func_177443_a(BlockPos pos, int amount) {
        return this.parent.func_177443_a(this.compatibilityWorld.translatePos(pos), amount);
    }

    public Biome func_177411_a(BlockPos pos, BiomeProvider provider) {
        return this.parent.func_177411_a(this.compatibilityWorld.translatePos(pos), provider);
    }

    public byte[] func_76605_m() {
        if (this.parent == null) {
            return super.func_76605_m();
        }
        return this.parent.func_76605_m();
    }

    public void func_76612_a(Entity entity) {
        this.compatibilityWorld.translateEntity(entity);
        this.parent.func_76612_a(entity);
    }

    public void func_76622_b(Entity entity) {
        this.parent.func_76622_b(entity);
    }

    public void func_76608_a(Entity entity, int index) {
        if ((index -= MathHelper.func_76128_c((double)((double)this.compatibilityWorld.minY / 16.0))) < 0 || index >= 16) {
            return;
        }
        this.parent.func_76608_a(entity, index);
    }

    public <T extends Entity> void func_177430_a(Class<? extends T> entityClass, AxisAlignedBB aabb, List<T> listToFill, Predicate<? super T> filter) {
        aabb = aabb.func_72317_d(0.0, (double)this.compatibilityWorld.minY, 0.0);
        this.parent.func_177430_a(entityClass, aabb, listToFill, filter);
    }

    public void func_177414_a(@Nullable Entity entity, AxisAlignedBB aabb, List<Entity> listToFill, Predicate<? super Entity> filter) {
        aabb = aabb.func_72317_d(0.0, (double)this.compatibilityWorld.minY, 0.0);
        this.parent.func_177414_a(entity, aabb, listToFill, filter);
    }

    public boolean func_76621_g() {
        return this.parent.func_76621_g();
    }

    public boolean func_76606_c(int startY, int endY) {
        return this.parent.func_76606_c(startY + this.compatibilityWorld.minY, endY + this.compatibilityWorld.minY);
    }

    public boolean func_150802_k() {
        return this.parent.func_150802_k();
    }

    public boolean func_177419_t() {
        return this.parent.func_177419_t();
    }

    public boolean func_177423_u() {
        return this.parent.func_177423_u();
    }

    public boolean func_186035_j() {
        return this.parent.func_186035_j();
    }

    public void func_76630_e() {
        this.parent.func_76630_e();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.parent.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)this.parent.getCapability(capability, facing);
    }
}

