/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.integration.bop;

import biomesoplenty.api.biome.BOPBiomes;
import net.gegy1000.earth.server.event.ConfigureFlowersEvent;
import net.gegy1000.earth.server.event.ConfigureTreesEvent;
import net.gegy1000.earth.server.event.InitBiomeClassifierEvent;
import net.gegy1000.earth.server.integration.bop.BoPTrees;
import net.gegy1000.earth.server.world.Climate;
import net.gegy1000.earth.server.world.EarthProperties;
import net.gegy1000.earth.server.world.cover.Cover;
import net.gegy1000.earth.server.world.cover.CoverMarkers;
import net.gegy1000.earth.server.world.cover.CoverSelectors;
import net.gegy1000.earth.server.world.ecology.GrowthPredictors;
import net.gegy1000.earth.server.world.ecology.soil.SoilSelector;
import net.gegy1000.earth.server.world.ecology.vegetation.TreeDecorator;
import net.gegy1000.earth.server.world.ecology.vegetation.Trees;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.event.TerrariumInitializeGeneratorEvent;
import net.gegy1000.terrarium.server.world.generator.customization.GenerationSettings;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class BoPIntegration {
    public static void setup() {
        MinecraftForge.TERRAIN_GEN_BUS.register(BoPIntegration.class);
        MinecraftForge.EVENT_BUS.register(BoPIntegration.class);
    }

    @SubscribeEvent
    public static void onConfigureTrees(ConfigureTreesEvent event) {
        TerrariumWorld terrarium = event.getTerrarium();
        if (!terrarium.getSettings().getBoolean(EarthProperties.BOP_INTEGRATION)) {
            return;
        }
        Cover cover = event.getCover();
        TreeDecorator.Builder trees = event.getBuilder();
        if (cover.is(CoverSelectors.broadleafDeciduous())) {
            trees.addCandidate(BoPTrees.MAHOGANY);
            trees.addCandidate(BoPTrees.WILLOW);
        }
        if (cover.is(CoverSelectors.broadleafEvergreen())) {
            trees.addCandidate(BoPTrees.PALM);
            trees.addCandidate(BoPTrees.EUCALYPTUS);
            trees.addCandidate(BoPTrees.MANGROVE);
            trees.addCandidate(BoPTrees.EBONY);
        }
        if (cover.is(CoverSelectors.needleleafEvergreen())) {
            trees.addCandidate(BoPTrees.FIR);
        }
    }

    @SubscribeEvent
    public static void onConfigureFlowers(ConfigureFlowersEvent event) {
    }

    @SubscribeEvent
    public static void onInitBiomeClassifier(InitBiomeClassifierEvent event) {
        GenerationSettings settings = event.getSettings();
        if (!settings.getBoolean(EarthProperties.BOP_INTEGRATION)) {
            return;
        }
        event.modifyClassifier(standard -> predictors -> {
            Biome biome = standard.classify(predictors);
            return BoPIntegration.classifyBiome(predictors, biome);
        });
    }

    private static Biome classifyBiome(GrowthPredictors predictors, Biome biome) {
        if (biome == Biomes.field_76787_r) {
            return biome;
        }
        if (!predictors.isFrozen()) {
            float spruce;
            double mangrove;
            if (predictors.cover == Cover.LICHENS_AND_MOSSES) {
                return (Biome)BOPBiomes.tundra.or((Object)biome);
            }
            if (predictors.cover == Cover.GRASSLAND) {
                return (Biome)BOPBiomes.grassland.or((Object)biome);
            }
            if (predictors.cover.is(CoverMarkers.DENSE_SHRUBS) && Climate.isVeryDry(predictors.annualRainfall)) {
                if (predictors.isBarren() || SoilSelector.isDesertLike(predictors)) {
                    return (Biome)BOPBiomes.brushland.or((Object)biome);
                }
                return (Biome)BOPBiomes.xeric_shrubland.or((Object)biome);
            }
            if (predictors.isLand() && !predictors.cover.is(CoverMarkers.NO_VEGETATION) && (mangrove = (double)BoPTrees.Indicators.MANGROVE.evaluate(predictors)) > 0.85) {
                return (Biome)BOPBiomes.mangrove.or((Object)biome);
            }
            if (predictors.slope >= 60 && !predictors.isCold() && predictors.cover.is(CoverMarkers.FOREST)) {
                return (Biome)BOPBiomes.overgrown_cliffs.or((Object)biome);
            }
            if (predictors.isFlooded() && biome == Biomes.field_76780_h && (spruce = Trees.Indicators.SPRUCE.evaluate(predictors)) > 0.85f) {
                return (Biome)BOPBiomes.wetland.or((Object)biome);
            }
            if (predictors.isForested() && biome == Biomes.field_76782_w) {
                float jungle = Trees.Indicators.JUNGLE_LIKE.evaluate(predictors);
                float oak = Trees.Indicators.OAK.evaluate(predictors);
                float spruce2 = Trees.Indicators.SPRUCE.evaluate(predictors);
                float mahogany = BoPTrees.Indicators.MAHOGANY.evaluate(predictors);
                if (oak > jungle && oak > spruce2 && oak > mahogany) {
                    return (Biome)BOPBiomes.rainforest.or((Object)biome);
                }
                if (spruce2 > jungle && spruce2 > oak && spruce2 > mahogany) {
                    return (Biome)BOPBiomes.temperate_rainforest.or((Object)biome);
                }
                if (mahogany > jungle && mahogany > spruce2 && mahogany > oak) {
                    return (Biome)BOPBiomes.tropical_rainforest.or((Object)biome);
                }
            }
        }
        if (predictors.isForested()) {
            return BoPIntegration.classifyForest(predictors, biome);
        }
        return biome;
    }

    private static Biome classifyForest(GrowthPredictors predictors, Biome biome) {
        double fir;
        if (biome == Biomes.field_76767_f && predictors.isFrozen()) {
            return (Biome)BOPBiomes.snowy_forest.or((Object)biome);
        }
        if (!predictors.isFrozen()) {
            float eucalyptus = BoPTrees.Indicators.EUCALYPTUS.evaluate(predictors);
            if (eucalyptus > 0.85f) {
                return (Biome)BOPBiomes.eucalyptus_forest.or((Object)biome);
            }
            float birch = Trees.Indicators.BIRCH.evaluate(predictors);
            float spruce = Trees.Indicators.SPRUCE.evaluate(predictors);
            if (birch > 0.85f && spruce > 0.85f) {
                return (Biome)BOPBiomes.boreal_forest.or((Object)biome);
            }
        }
        if ((fir = (double)BoPTrees.Indicators.FIR.evaluate(predictors)) > (double)0.85f) {
            if (predictors.isFrozen()) {
                return (Biome)BOPBiomes.snowy_coniferous_forest.or((Object)biome);
            }
            return (Biome)BOPBiomes.coniferous_forest.or((Object)biome);
        }
        return biome;
    }

    @SubscribeEvent
    public static void onInitializeTerrariumGenerator(TerrariumInitializeGeneratorEvent event) {
    }
}

