/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.gengen.api;

import dev.gegy.gengen.api.generator.GenericChunkGenerator;
import dev.gegy.gengen.core.GenGen;
import dev.gegy.gengen.core.impl.vanilla.ColumnWorldTypeImpl;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface GenericWorldType {
    @Nullable
    public static GenericWorldType unwrap(WorldType worldType) {
        if (worldType instanceof ColumnWorldTypeImpl) {
            return ((ColumnWorldTypeImpl)worldType).getInner();
        }
        return null;
    }

    @Nullable
    public static <T extends GenericWorldType> T unwrapAs(WorldType worldType, Class<T> type) {
        GenericWorldType genericType = GenericWorldType.unwrap(worldType);
        if (type.isInstance(genericType)) {
            return (T)((GenericWorldType)type.cast(genericType));
        }
        return null;
    }

    default public WorldType create() {
        return GenGen.proxy().createWorldType(this);
    }

    public String getName();

    public GenericChunkGenerator createGenerator(World var1);

    public BiomeProvider createBiomeProvider(World var1);

    default public int getMinGenerationHeight(WorldServer world) {
        return 0;
    }

    default public int getMaxGenerationHeight(WorldServer world) {
        return Short.MAX_VALUE;
    }

    default public int getMinSpawnHeight(World world) {
        return world.func_181545_F() + 1;
    }

    default public double getHorizon(World world) {
        return 63.0;
    }

    default public boolean shouldReduceSlimes(World world, Random random) {
        return false;
    }

    default public int getSpawnFuzz(WorldServer world, MinecraftServer server) {
        return Math.max(0, server.func_184108_a(world));
    }

    @SideOnly(value=Side.CLIENT)
    default public void onCustomize(Minecraft client, WorldType worldType, GuiCreateWorld parent) {
    }

    default public boolean isCustomizable() {
        return false;
    }

    default public float getCloudHeight() {
        return 128.0f;
    }
}

