/*
 * Decompiled with CFR 0.152.
 */
package bletch.common.utils;

import bletch.common.utils.StringUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
public class Font {
    public static final Font small = new Font(true);
    public static final Font normal = new Font(false);
    public FontRenderer fontRenderer;

    private Font(boolean small) {
        Minecraft mc = Minecraft.func_71410_x();
        this.fontRenderer = new FontRenderer(mc.field_71474_y, new ResourceLocation("textures/font/ascii.png"), mc.func_110434_K(), small);
        ((IReloadableResourceManager)mc.func_110442_L()).func_110542_a((IResourceManagerReloadListener)this.fontRenderer);
    }

    public int getStringWidth(String text) {
        return this.fontRenderer.func_78256_a(text);
    }

    public void printLeft(Object o, int x, int y, float z) {
        this.printLeft(o, x, y, z, Color.BLACK.getRGB(), false);
    }

    public void printLeft(Object o, int x, int y, float z, int color) {
        this.printLeft(o, x, y, z, color, false);
    }

    public void printLeft(Object o, int x, int y, float z, int color, boolean shadow) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)(z + 1.0f));
        this.fontRenderer.func_175065_a(String.valueOf(o), (float)x, (float)y, color, shadow);
        GlStateManager.func_179121_F();
    }

    public void printCentered(Object o, int x, int y, float z) {
        this.printCentered(o, x, y, z, Color.BLACK.getRGB(), false);
    }

    public void printCentered(Object o, int x, int y, float z, int color) {
        this.printCentered(o, x, y, z, color, false);
    }

    public void printCentered(Object o, int x, int y, float z, int color, boolean shadow) {
        int width = this.getStringWidth(String.valueOf(o));
        int newX = x - width / 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)(z + 1.0f));
        this.fontRenderer.func_175065_a(String.valueOf(o), (float)newX, (float)y, color, shadow);
        GlStateManager.func_179121_F();
    }

    public void printRight(Object o, int x, int y, float z) {
        this.printRight(o, x, y, z, Color.BLACK.getRGB(), false);
    }

    public void printRight(Object o, int x, int y, float z, int color) {
        this.printRight(o, x, y, z, color, false);
    }

    public void printRight(Object o, int x, int y, float z, int color, boolean shadow) {
        int width = this.getStringWidth(String.valueOf(o));
        int newX = x - width;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)(z + 1.0f));
        this.fontRenderer.func_175065_a(String.valueOf(o), (float)newX, (float)y, color, shadow);
        GlStateManager.func_179121_F();
    }

    public String trimStringToWidth(String text, int width, boolean addElipse) {
        if (this.fontRenderer.func_78256_a(text) > width) {
            return this.fontRenderer.func_78269_a(text, width) + (addElipse ? "..." : "");
        }
        return text;
    }

    public List<String> splitStringToWidth(String text, int width) {
        ArrayList<String> lines = new ArrayList<String>();
        if (!StringUtils.isNullOrWhitespace(text).booleanValue()) {
            int textWidth = this.fontRenderer.func_78256_a(text);
            while (textWidth > width) {
                String textPartial = this.fontRenderer.func_78269_a(text, width);
                if (textPartial.contains(" ")) {
                    while (!textPartial.endsWith(" ")) {
                        textPartial = textPartial.substring(0, textPartial.length() - 1);
                    }
                }
                lines.add(textPartial.trim());
                text = text.replaceFirst(textPartial, "");
                textWidth = this.fontRenderer.func_78256_a(text);
            }
            if (!StringUtils.isNullOrWhitespace(text).booleanValue()) {
                lines.add(text.trim());
            }
        }
        return lines;
    }
}

