/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.placement;

import com.direwolf20.buildinggadgets.common.building.IPlacementSequence;
import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.building.placement.Wall;
import com.direwolf20.buildinggadgets.common.tools.VectorTools;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;

public final class ConnectedSurface
implements IPlacementSequence {
    private final IBlockAccess world;
    private final Region searchingRegion;
    private final Function<BlockPos, BlockPos> searching2referenceMapper;
    private final BlockPos searchingCenter;
    private final EnumFacing side;
    private final BiPredicate<IBlockState, BlockPos> predicate;

    public static ConnectedSurface create(IBlockAccess world, BlockPos searchingCenter, EnumFacing side, int range, boolean fuzzy) {
        Region searchingRegion = Wall.clickedSide(searchingCenter, side, range).getBoundingBox();
        return ConnectedSurface.create(world, searchingRegion, (BlockPos pos) -> pos.func_177972_a(side), searchingCenter, side, fuzzy);
    }

    public static ConnectedSurface create(IBlockAccess world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, @Nullable EnumFacing side, boolean fuzzy) {
        return new ConnectedSurface(world, searchingRegion, searching2referenceMapper, searchingCenter, side, fuzzy);
    }

    public static ConnectedSurface create(IBlockAccess world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, @Nullable EnumFacing side, BiPredicate<IBlockState, BlockPos> predicate) {
        return new ConnectedSurface(world, searchingRegion, searching2referenceMapper, searchingCenter, side, predicate);
    }

    @VisibleForTesting
    private ConnectedSurface(IBlockAccess world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, @Nullable EnumFacing side, boolean fuzzy) {
        this(world, searchingRegion, searching2referenceMapper, searchingCenter, side, (filter, pos) -> {
            IBlockState reference = world.func_180495_p((BlockPos)searching2referenceMapper.apply((BlockPos)pos));
            boolean isAir = reference.func_177230_c().isAir(reference, world, pos);
            return !isAir && (fuzzy || filter == reference);
        });
    }

    ConnectedSurface(IBlockAccess world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, @Nullable EnumFacing side, BiPredicate<IBlockState, BlockPos> predicate) {
        this.world = world;
        this.searchingRegion = searchingRegion;
        this.searching2referenceMapper = searching2referenceMapper;
        this.searchingCenter = searchingCenter;
        this.side = side;
        this.predicate = predicate;
    }

    @Override
    public Region getBoundingBox() {
        return this.searchingRegion;
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        return this.searchingRegion.mayContain(x, y, z);
    }

    @Override
    public IPlacementSequence copy() {
        return new ConnectedSurface(this.world, this.searchingRegion, this.searching2referenceMapper, this.searchingCenter, this.side, this.predicate);
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        final IBlockState selectedBlock = this.getReferenceFor(this.searchingCenter);
        return new AbstractIterator<BlockPos>(){
            private Queue<BlockPos> queue = new LinkedList<BlockPos>();
            private Set<BlockPos> searched = new HashSet<BlockPos>(ConnectedSurface.access$000(ConnectedSurface.this).size());
            {
                if (this.isValid(ConnectedSurface.this.searchingCenter)) {
                    this.queue.add(ConnectedSurface.this.searchingCenter);
                    this.searched.add(ConnectedSurface.this.searchingCenter);
                }
            }

            protected BlockPos computeNext() {
                if (this.queue.isEmpty()) {
                    return (BlockPos)this.endOfData();
                }
                BlockPos current = this.queue.remove();
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        if (ConnectedSurface.this.side != null) {
                            BlockPos neighbor = VectorTools.perpendicularSurfaceOffset(current, ConnectedSurface.this.side, i, j);
                            this.addNeighbour(neighbor);
                            continue;
                        }
                        for (int k = -1; k <= 1; ++k) {
                            BlockPos neighbor = current.func_177982_a(i, j, k);
                            this.addNeighbour(neighbor);
                        }
                    }
                }
                return current;
            }

            private void addNeighbour(BlockPos neighbor) {
                boolean isSearched;
                boolean bl = isSearched = !this.searched.add(neighbor);
                if (isSearched || !this.isValid(neighbor)) {
                    return;
                }
                this.queue.add(neighbor);
            }

            private boolean isValid(BlockPos pos) {
                return ConnectedSurface.this.searchingRegion.contains((Vec3i)pos) && ConnectedSurface.this.predicate.test(selectedBlock, pos);
            }
        };
    }

    private IBlockState getReferenceFor(BlockPos pos) {
        return this.world.func_180495_p(this.searching2referenceMapper.apply(pos));
    }
}

