/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item.components;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.capability.TankCapabilityItemStack;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IArmorComponent;
import zmaster587.libVulpes.client.ResourceIcon;
import zmaster587.libVulpes.items.ItemIngredient;
import zmaster587.libVulpes.util.FluidUtils;

public class ItemPressureTank
extends ItemIngredient
implements IArmorComponent {
    ResourceIcon icon;
    private int capacity;

    public ItemPressureTank(int number, int capacity) {
        super(number);
        this.capacity = capacity;
        this.field_77777_bU = 1;
    }

    public void func_77624_a(@Nonnull ItemStack stack, World player, List<String> list, ITooltipFlag bool) {
        super.func_77624_a(stack, player, list, bool);
        FluidStack fluidStack = FluidUtils.getFluidForItem((ItemStack)stack);
        if (fluidStack == null) {
            list.add(LibVulpes.proxy.getLocalizedString("msg.empty"));
        } else {
            list.add(fluidStack.getLocalizedName() + ": " + fluidStack.amount);
        }
    }

    public void onTick(World world, EntityPlayer player, @Nonnull ItemStack armorStack, IInventory inv, @Nonnull ItemStack componentStack) {
    }

    public boolean onComponentAdded(World world, @Nonnull ItemStack armorStack) {
        return true;
    }

    public void onComponentRemoved(World world, @Nonnull ItemStack armorStack) {
    }

    public void onArmorDamaged(EntityLivingBase entity, @Nonnull ItemStack armorStack, @Nonnull ItemStack componentStack, DamageSource source, int damage) {
    }

    public int getCapacity(@Nonnull ItemStack container) {
        return this.capacity * (int)Math.pow(2.0, container.func_77952_i());
    }

    public ResourceIcon getComponentIcon(@Nonnull ItemStack armorStack) {
        return null;
    }

    public boolean isAllowedInSlot(@Nonnull ItemStack stack, EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.CHEST;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderScreen(@Nonnull ItemStack componentStack, List<ItemStack> modules, RenderGameOverlayEvent event, Gui gui) {
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, NBTTagCompound nbt) {
        return new TankCapabilityItemStack(stack, this.getCapacity(stack));
    }
}

