/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.util;

import com.feed_the_beast.ftblib.events.player.ForgePlayerLoggedInEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamChangedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamCreatedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamDataEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamDeletedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamLoadedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerLeftEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamSavedEvent;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.NBTDataStorage;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.MessageChangedTeam;
import com.feed_the_beast.ftbquests.net.MessageClaimRewardResponse;
import com.feed_the_beast.ftbquests.net.MessageCreateTeamData;
import com.feed_the_beast.ftbquests.net.MessageDeleteTeamData;
import com.feed_the_beast.ftbquests.net.MessageSyncQuests;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardAutoClaim;
import com.feed_the_beast.ftbquests.quest.task.DimensionTask;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.util.FTBQuestsInventoryListener;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="ftbquests")
public class ServerQuestData
extends QuestData
implements NBTDataStorage.Data {
    public final ForgeTeam team;

    public static ServerQuestData get(ForgeTeam team) {
        return (ServerQuestData)team.getData().get("ftbquests");
    }

    @SubscribeEvent
    public static void registerTeamData(ForgeTeamDataEvent event) {
        event.register((NBTDataStorage.Data)new ServerQuestData(event.getTeam()));
    }

    @SubscribeEvent
    public static void onTeamSaved(ForgeTeamSavedEvent event) {
        NBTTagCompound nbt = new NBTTagCompound();
        ServerQuestData data = ServerQuestData.get(event.getTeam());
        data.writeData(nbt);
        File file = event.getTeam().getDataFile("ftbquests");
        if (nbt.func_82582_d()) {
            FileUtils.deleteSafe((File)file);
        } else {
            NBTUtils.writeNBTSafe((File)file, (NBTTagCompound)nbt);
        }
    }

    @SubscribeEvent
    public static void onTeamLoaded(ForgeTeamLoadedEvent event) {
        ServerQuestData data = ServerQuestData.get(event.getTeam());
        for (Chapter chapter : ServerQuestFile.INSTANCE.chapters) {
            for (Quest quest : chapter.quests) {
                for (Task task : quest.tasks) {
                    data.createTaskData(task);
                }
            }
        }
        NBTTagCompound nbt = NBTUtils.readNBT((File)event.getTeam().getDataFile("ftbquests"));
        data.readData(nbt == null ? new NBTTagCompound() : nbt);
    }

    @SubscribeEvent
    public static void onTeamCreated(ForgeTeamCreatedEvent event) {
        ServerQuestData data = ServerQuestData.get(event.getTeam());
        for (Chapter chapter : ServerQuestFile.INSTANCE.chapters) {
            for (Quest quest : chapter.quests) {
                for (Task task : quest.tasks) {
                    data.createTaskData(task);
                }
            }
        }
        new MessageCreateTeamData(event.getTeam()).sendToAll();
    }

    @SubscribeEvent
    public static void onTeamDeleted(ForgeTeamDeletedEvent event) {
        FileUtils.deleteSafe((File)event.getTeam().getDataFile("ftbquests"));
        new MessageDeleteTeamData(event.getTeam().getUID()).sendToAll();
    }

    @SubscribeEvent
    public static void onPlayerLeftTeam(ForgeTeamPlayerLeftEvent event) {
        if (event.getPlayer().isOnline()) {
            new MessageChangedTeam(event.getPlayer().getId(), 0).sendTo(event.getPlayer().getPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinedTeam(ForgeTeamPlayerJoinedEvent event) {
        if (event.getPlayer().isOnline()) {
            new MessageChangedTeam(event.getPlayer().getId(), event.getTeam().getUID()).sendTo(event.getPlayer().getPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(ForgePlayerLoggedInEvent event) {
        ServerQuestData teamData = ServerQuestData.get(event.getTeam());
        EntityPlayerMP player = event.getPlayer().getPlayer();
        MessageSyncQuests m = new MessageSyncQuests();
        m.file = ServerQuestFile.INSTANCE;
        m.team = teamData.getTeamUID();
        m.teamData = new ArrayList<MessageSyncQuests.TeamInst>();
        for (ForgeTeam team : event.getUniverse().getTeams()) {
            ServerQuestData data = ServerQuestData.get(team);
            MessageSyncQuests.TeamInst t = new MessageSyncQuests.TeamInst();
            t.uid = team.getUID();
            t.id = team.getId();
            t.name = team.getTitle();
            int size = 0;
            for (TaskData taskData : data.taskData.values()) {
                if (!taskData.isStarted()) continue;
                ++size;
            }
            t.taskKeys = new int[size];
            t.taskValues = new long[size];
            int i = 0;
            for (TaskData taskData : data.taskData.values()) {
                if (!taskData.isStarted()) continue;
                t.taskKeys[i] = ((Task)taskData.task).id;
                t.taskValues[i] = taskData.progress;
                ++i;
            }
            size = 0;
            for (Map.Entry entry : data.claimedPlayerRewards.entrySet()) {
                if (((IntOpenHashSet)entry.getValue()).isEmpty()) continue;
                ++size;
            }
            t.playerRewardUUIDs = new UUID[size];
            t.playerRewardIDs = new int[size][];
            i = 0;
            for (Map.Entry entry : data.claimedPlayerRewards.entrySet()) {
                if (((IntOpenHashSet)entry.getValue()).isEmpty()) continue;
                t.playerRewardUUIDs[i] = (UUID)entry.getKey();
                t.playerRewardIDs[i] = ((IntOpenHashSet)entry.getValue()).toIntArray();
                ++i;
            }
            t.teamRewards = data.claimedTeamRewards.toIntArray();
            m.teamData.add(t);
        }
        m.editingMode = FTBQuests.canEdit((EntityPlayer)player);
        m.playerIDs = new UUID[event.getUniverse().getPlayers().size()];
        m.playerTeams = new short[m.playerIDs.length];
        int i = 0;
        for (ForgePlayer p : event.getUniverse().getPlayers()) {
            m.playerIDs[i] = p.getId();
            m.playerTeams[i] = p.team.getUID();
            ++i;
        }
        m.favorites = NBTUtils.getPersistedData((EntityPlayer)player, (boolean)false).func_74759_k("ftbquests_pinned");
        m.sendTo(player);
        event.getPlayer().getPlayer().field_71069_bz.func_75132_a((IContainerListener)new FTBQuestsInventoryListener(event.getPlayer().getPlayer()));
        for (Chapter chapter : ServerQuestFile.INSTANCE.chapters) {
            for (Quest quest : chapter.quests) {
                teamData.checkAutoCompletion(quest);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            event.getEntityPlayer().field_71069_bz.func_75132_a((IContainerListener)new FTBQuestsInventoryListener((EntityPlayerMP)event.getEntityPlayer()));
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        QuestData data;
        if (event.player instanceof EntityPlayerMP && (data = ServerQuestFile.INSTANCE.getData((Entity)event.player)) != null) {
            for (Chapter chapter : ServerQuestFile.INSTANCE.chapters) {
                for (Quest quest : chapter.quests) {
                    for (Task task : quest.tasks) {
                        if (!(task instanceof DimensionTask)) continue;
                        data.getTaskData(task).submitTask((EntityPlayerMP)event.player);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onContainerOpened(PlayerContainerEvent.Open event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP && !(event.getContainer() instanceof ContainerPlayer)) {
            event.getContainer().func_75132_a((IContainerListener)new FTBQuestsInventoryListener((EntityPlayerMP)event.getEntityPlayer()));
        }
    }

    @SubscribeEvent
    public static void onTeamChanged(ForgeTeamChangedEvent event) {
        ServerQuestData oldData = ServerQuestData.get(event.getOldTeam());
        ServerQuestData newData = ServerQuestData.get(event.getTeam());
        newData.progressCache = null;
        newData.areDependenciesCompleteCache = null;
        for (TaskData oldTaskData : oldData.taskData.values()) {
            TaskData newTaskData = newData.getTaskData((Task)oldTaskData.task);
            newTaskData.setProgress(Math.max(oldTaskData.progress, newTaskData.progress));
        }
    }

    private ServerQuestData(ForgeTeam t) {
        this.team = t;
    }

    public String getId() {
        return "ftbquests";
    }

    @Override
    public short getTeamUID() {
        return this.team.getUID();
    }

    @Override
    public String getTeamID() {
        return this.team.getId();
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.team.getTitle();
    }

    @Override
    public QuestFile getFile() {
        return ServerQuestFile.INSTANCE;
    }

    public List<EntityPlayerMP> getOnlineMembers() {
        return this.team.getOnlineMembers();
    }

    @Override
    public void markDirty() {
        this.team.markDirty();
    }

    @Override
    public boolean setRewardClaimed(UUID player, Reward reward) {
        if (super.setRewardClaimed(player, reward)) {
            this.markDirty();
            new MessageClaimRewardResponse(this.getTeamUID(), player, reward.id).sendToAll();
            return true;
        }
        return false;
    }

    public void claimReward(EntityPlayerMP player, Reward reward, boolean notify) {
        if (this.setRewardClaimed(player.func_110124_au(), reward)) {
            reward.claim(player, notify);
        }
    }

    private void writeData(NBTTagCompound nbt) {
        NBTTagCompound nbt1 = new NBTTagCompound();
        for (TaskData taskData : this.taskData.values()) {
            if (!taskData.isStarted()) continue;
            String key = QuestObjectBase.getCodeString(taskData.task);
            if (taskData.progress <= 127L) {
                nbt1.func_74774_a(key, (byte)taskData.progress);
                continue;
            }
            if (taskData.progress <= 32767L) {
                nbt1.func_74777_a(key, (short)taskData.progress);
                continue;
            }
            if (taskData.progress <= Integer.MAX_VALUE) {
                nbt1.func_74768_a(key, (int)taskData.progress);
                continue;
            }
            nbt1.func_74772_a(key, taskData.progress);
        }
        nbt.func_74782_a("Tasks", (NBTBase)nbt1);
        if (!this.claimedTeamRewards.isEmpty()) {
            nbt.func_74783_a("ClaimedTeamRewards", this.claimedTeamRewards.toIntArray());
        }
        if (!this.claimedPlayerRewards.isEmpty()) {
            nbt1 = new NBTTagCompound();
            for (Map.Entry entry : this.claimedPlayerRewards.entrySet()) {
                if (((IntOpenHashSet)entry.getValue()).isEmpty()) continue;
                nbt1.func_74783_a(StringUtils.fromUUID((UUID)((UUID)entry.getKey())), ((IntOpenHashSet)entry.getValue()).toIntArray());
            }
            if (!nbt1.func_82582_d()) {
                nbt.func_74782_a("ClaimedPlayerRewards", (NBTBase)nbt1);
            }
        }
    }

    private void readData(NBTTagCompound nbt) {
        NBTTagCompound nbt1 = nbt.func_74775_l("Tasks");
        for (String s : nbt1.func_150296_c()) {
            Task task = ServerQuestFile.INSTANCE.getTask(ServerQuestFile.INSTANCE.getID(s));
            if (task == null) continue;
            ((TaskData)this.taskData.get(task.id)).readProgress(nbt1.func_74763_f(s));
        }
        this.claimedTeamRewards.clear();
        for (Object r : (Iterator)nbt.func_74759_k("ClaimedTeamRewards")) {
            this.claimedTeamRewards.add((int)r);
        }
        this.claimedPlayerRewards.clear();
        nbt1 = nbt.func_74775_l("ClaimedPlayerRewards");
        for (String s : nbt1.func_150296_c()) {
            int[] ar;
            UUID id = StringUtils.fromString((String)s);
            if (id == null || (ar = nbt1.func_74759_k(s)).length <= 0) continue;
            IntOpenHashSet set = new IntOpenHashSet(ar.length);
            for (int r : ar) {
                set.add(r);
            }
            this.claimedPlayerRewards.put(id, set);
        }
    }

    @Override
    public void checkAutoCompletion(Quest quest) {
        if (quest.rewards.isEmpty() || !quest.isComplete(this)) {
            return;
        }
        ArrayList<EntityPlayerMP> online = null;
        for (Reward reward : quest.rewards) {
            RewardAutoClaim auto = reward.getAutoClaimType();
            if (auto == RewardAutoClaim.DISABLED) continue;
            if (online == null) {
                online = new ArrayList<EntityPlayerMP>();
                for (EntityPlayerMP player : this.team.getMembers()) {
                    if (!player.isOnline()) continue;
                    online.add(player.getPlayer());
                }
                if (online.isEmpty()) {
                    return;
                }
            }
            for (EntityPlayerMP player : online) {
                this.claimReward(player, reward, auto == RewardAutoClaim.ENABLED);
            }
        }
    }
}

