/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.network;

import com.paneedah.weaponlib.vehicle.EntityVehicle;
import com.paneedah.weaponlib.vehicle.jimphysics.solver.VehiclePhysicsSolver;
import io.netty.buffer.ByteBuf;
import io.redstudioragnarok.redcore.vectors.Vector3D;
import java.io.IOException;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.util.math.Vec3d;

public class VehicleDataSerializer {
    public EntityVehicle vehicle;
    public Vec3d position;
    public double throttle;
    public double driftTuner;
    public boolean isBraking;
    public double forwardLean;
    public double sideLean;
    public double wheelRotationAngle;
    public double steerangle;
    public static final DataSerializer<VehicleDataSerializer> SERIALIZER = new DataSerializer<VehicleDataSerializer>(){

        public void write(PacketBuffer buf, VehicleDataSerializer value) {
            EntityVehicle v = value.vehicle;
            VehiclePhysicsSolver solver = v.solver;
            new Vector3D(v.func_174791_d()).write((ByteBuf)buf);
            buf.writeDouble(v.throttle);
            buf.writeDouble(v.driftTuner);
            buf.writeBoolean(v.isBraking);
            buf.writeDouble(v.forwardLean);
            buf.writeDouble(v.sideLean);
            buf.writeDouble((double)v.wheelRotationAngle);
            buf.writeDouble(v.steerangle);
        }

        public VehicleDataSerializer read(PacketBuffer buf) throws IOException {
            VehicleDataSerializer ds = new VehicleDataSerializer();
            Vector3D vector = new Vector3D();
            vector.read((ByteBuf)buf);
            ds.position = vector.toVec3d();
            vector.read((ByteBuf)buf);
            ds.position = vector.toVec3d();
            ds.throttle = buf.readDouble();
            ds.driftTuner = buf.readDouble();
            ds.isBraking = buf.readBoolean();
            ds.forwardLean = buf.readDouble();
            ds.sideLean = buf.readDouble();
            ds.wheelRotationAngle = buf.readDouble();
            ds.steerangle = buf.readDouble();
            return ds;
        }

        public DataParameter<VehicleDataSerializer> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public VehicleDataSerializer copyValue(VehicleDataSerializer value) {
            return value;
        }
    };

    public VehicleDataSerializer() {
    }

    public VehicleDataSerializer(EntityVehicle vehicle) {
        this.vehicle = vehicle;
    }

    public void setData(Vec3d position, double throttle, double driftTuner, boolean isBraking, double forwardLean, double sideLean, double wheelRotationAngle, double steerangle) {
        this.position = position;
        this.throttle = throttle;
        this.driftTuner = driftTuner;
        this.forwardLean = forwardLean;
        this.sideLean = sideLean;
        this.wheelRotationAngle = wheelRotationAngle;
        this.steerangle = steerangle;
    }

    public void updateVehicle(EntityVehicle v) {
        v.throttle = this.throttle;
        v.driftTuner = this.driftTuner;
        v.forwardLean = this.forwardLean;
        v.sideLean = this.sideLean;
        v.wheelRotationAngle = (float)this.wheelRotationAngle;
        v.steerangle = this.steerangle;
        v.field_70165_t = this.position.field_72450_a;
        v.field_70163_u = this.position.field_72448_b;
        v.field_70161_v = this.position.field_72449_c;
    }
}

