/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.jimphysics.solver;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.KeyBindings;
import com.paneedah.weaponlib.vehicle.collisions.InertiaKit;
import com.paneedah.weaponlib.vehicle.jimphysics.InterpolationKit;
import com.paneedah.weaponlib.vehicle.jimphysics.TyreSize;
import com.paneedah.weaponlib.vehicle.jimphysics.VehiclePhysUtil;
import com.paneedah.weaponlib.vehicle.jimphysics.solver.SuspensionSolver;
import com.paneedah.weaponlib.vehicle.jimphysics.solver.VehiclePhysicsSolver;
import com.paneedah.weaponlib.vehicle.jimphysics.solver.WheelAxel;
import com.paneedah.weaponlib.vehicle.jimphysics.stability.numerical.vehicle.WheelSolutionVector;
import javax.vecmath.Vector3d;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.Vec3d;

public class WheelSolver {
    public double actualRideHeight = 0.0;
    public double springRate = 271.0;
    VehiclePhysicsSolver solver;
    public SuspensionSolver suspension;
    public WheelAxel axel;
    public double wheelAngularVelocity = 0.0;
    double wheelAngularAcceleration = 0.0;
    public double wheelAngle = 0.0;
    double wheelInertia = 0.0;
    double loadOnWheel = 0.0;
    Vec3d wheelOreintation = new Vec3d(0.0, 0.0, 1.0);
    double driveTorque;
    double tractionTorque;
    double lateralForce = 0.0;
    double longForce = 0.0;
    boolean isDrive;
    public Vec3d longitudinalForce = new Vec3d(0.0, 0.0, 0.0);
    public Vec3d lateralForceVec = new Vec3d(0.0, 0.0, 0.0);
    public Vec3d relativePosition = Vec3d.field_186680_a;
    public double rideHeight;
    public double wheelRot = 0.0;
    public double prevWheelRot = 0.0;
    public WheelSolutionVector state = new WheelSolutionVector();
    public double wheelMass = 0.0;
    public TyreSize tyreSize;
    public double grassCoef = 0.5;
    double oldWheelVel = 0.0;
    public double slipRatio = 0.0;

    public WheelSolver(TyreSize tyreSize, double mass, boolean isDrive) {
        this.suspension = new SuspensionSolver(this.springRate, 1.0);
        this.tyreSize = tyreSize;
        this.solver = this.solver;
        this.wheelMass = mass;
        this.wheelInertia = InertiaKit.inertiaTensorCylinder((float)((float)mass), (float)((float)this.getRadius()), (float)((float)this.getWidth())).m22;
        this.isDrive = isDrive;
    }

    public WheelSolver(TyreSize tyreSize, double mass, boolean isDrive, double grassCoef) {
        this.suspension = new SuspensionSolver(this.springRate, 1.0);
        this.tyreSize = tyreSize;
        this.solver = this.solver;
        this.wheelMass = mass;
        this.wheelInertia = InertiaKit.inertiaTensorCylinder((float)((float)mass), (float)((float)this.getRadius()), (float)((float)this.getWidth())).m22;
        this.isDrive = isDrive;
        this.grassCoef = grassCoef;
    }

    public void assignSolver(VehiclePhysicsSolver solver) {
        this.solver = solver;
    }

    public double getRadius() {
        return this.tyreSize.getRadius();
    }

    public double getWidth() {
        return this.tyreSize.getWidth();
    }

    public double getInterpolatedWheelRotation() {
        return Math.toDegrees(InterpolationKit.interpolateValue(this.prevWheelRot, this.wheelRot, ClientProxy.MC.func_184121_ak()));
    }

    public Vec3d getSuspensionPosition() {
        Vec3d relative = this.relativePosition;
        relative = relative.func_72441_c(0.0, this.getSuspension().getStretch() * -0.15, 0.0);
        return relative;
    }

    public void setRelativePosition(Vec3d rP) {
        this.relativePosition = rP;
    }

    public boolean isDriveWheel() {
        return this.axel.isDriveWheel;
    }

    public void applySuspensionLoad(double force) {
        this.suspension.applyForce(force);
    }

    public SuspensionSolver getSuspension() {
        return this.suspension;
    }

    public double getRenderRideHeight() {
        double d = this.rideHeight;
        if (this.axel.solver.vehicle.rideOffset < 0.0) {
            d += this.axel.solver.vehicle.rideOffset * 1.75;
        }
        return d;
    }

    public void applyBrake(double magnitude) {
    }

    public void doPhysics() {
        double radius = this.getRadius();
        Vec3d vM = this.solver.velocity.func_72432_b();
        Vec3d oM = this.solver.getOreintationVector();
        Vector3d oreintation = new Vector3d(oM.field_72450_a, oM.field_72448_b, oM.field_72449_c);
        Vector3d velocity = new Vector3d(vM.field_72450_a, vM.field_72448_b, vM.field_72449_c);
        this.wheelAngularVelocity += this.wheelAngularAcceleration * this.solver.timeStep;
        if (this.solver.vehicle.throttle != 1.0) {
            this.wheelAngularVelocity *= 0.995;
        }
        if (this.axel.COGoffset < 0.5) {
            // empty if block
        }
        if (this.solver.getLongitudinalSpeed() == 0.0) {
            this.wheelAngularVelocity = 0.0;
        }
        if (this.solver.transmission.isReverseGear && this.wheelAngularVelocity > 20.0) {
            this.wheelAngularVelocity = 20.0;
        }
        this.wheelAngularAcceleration = 0.0;
        this.wheelRot += this.wheelAngularVelocity * this.solver.timeStep;
        Vec3d omega = this.wheelOreintation.func_178785_b((float)this.wheelAngle);
        double B = 0.91;
        double ls = this.solver.getLongitudinalSpeed();
        double rm = this.solver.timeStep / 2.0;
        double cx = 75000.0;
        double n = 1.1;
        double m = this.loadOnWheel / 9.81;
        double lamdaR = -(cx / ls) * (1.0 / m + radius * radius / this.wheelInertia);
        double r = -1.0 / lamdaR;
        double umx = rm * cx * (radius * radius / this.wheelInertia + 1.0 / m);
        this.slipRatio = (this.wheelAngularVelocity * radius - ls) / Math.max(Math.abs(ls), n * umx);
        if (this.wheelAngularVelocity < 0.0 && !this.solver.transmission.isReverseGear) {
            this.wheelAngularVelocity = 0.0;
        }
        if (this.solver.vehicle.getRealSpeed() < 1.0 && KeyBindings.vehicleBrake.func_151470_d() && !this.solver.transmission.isReverseGear) {
            this.solver.velocity = Vec3d.field_186680_a;
            this.wheelAngularVelocity = 0.0;
            this.wheelAngularAcceleration = 0.0;
            this.slipRatio = 0.0;
        }
        if (Double.isNaN(this.slipRatio)) {
            this.slipRatio = 0.0;
        }
        if (Double.isNaN(this.slipRatio)) {
            this.longitudinalForce = Vec3d.field_186680_a;
            return;
        }
        double peak = 1.0;
        if (this.solver.transmission.getClutch().getSlippage() == 1.0) {
            peak = 1.9;
        }
        this.longForce = VehiclePhysUtil.pacejkaLong(this.loadOnWheel, this.slipRatio, 1.65, peak, 0.97, 10.0);
        if (Math.abs(Math.toDegrees(oreintation.angle(velocity))) > 150.0 && !this.solver.transmission.isReverseGear && this.solver.vehicle.throttle < 0.5) {
            this.axel.applyBrakingForce(8000.0);
            this.longForce *= -1.0;
        }
        if (this.solver.vehicle.isBraking) {
            // empty if block
        }
        this.longitudinalForce = omega.func_186678_a(this.longForce);
        if (this.axel.solver.materialBelow != Material.field_151576_e) {
            this.longitudinalForce = this.longitudinalForce.func_186678_a(0.5);
        }
        this.tractionTorque = this.longForce * radius * -1.0;
        double yawspeed = this.solver.wheelBase * this.axel.COGoffset * this.solver.angularVelocity;
        double rot_angle = Math.atan(yawspeed / this.solver.getLongitudinalSpeed());
        double sideSlip = this.solver.getSideSlipAngle();
        double slipAngleTire = this.axel.COGoffset < 0.0 ? sideSlip - rot_angle - this.wheelAngle : sideSlip + rot_angle - this.wheelAngle;
        slipAngleTire = Math.toDegrees(slipAngleTire);
        double cy = 100000.0;
        double uym = rm * (cy / m);
        Vec3d lateralVector = this.solver.getOreintationVector().func_178785_b((float)Math.toRadians(-90.0));
        double dotter = lateralVector.func_72430_b(this.solver.velocity);
        double lateralSlipRatio = dotter / Math.max(Math.abs(ls), n * uym);
        if ((lateralSlipRatio *= 100000.0) == 0.0) {
            lateralSlipRatio = 90.0;
        }
        this.lateralForce = VehiclePhysUtil.pacejkaLong(this.loadOnWheel, slipAngleTire, 1.3, 1.3, 1.0, 4.0);
        if (this.axel.isHandbraking) {
            if (!(Math.abs(Math.toDegrees(this.solver.vehicle.steerangle)) > 4.0)) {
                if (this.axel.solver.materialBelow == Material.field_151576_e) {
                    this.axel.applyBrakingForce(40.0);
                } else {
                    this.axel.applyBrakingForce(10.0);
                }
            }
            this.lateralForce *= 0.15;
        }
        if (this.axel.COGoffset < 0.0 && this.axel.solver.materialBelow != Material.field_151576_e) {
            this.lateralForce *= this.grassCoef;
        }
        if (Double.isNaN(this.lateralForce)) {
            this.lateralForce = 0.0;
            this.lateralForceVec = Vec3d.field_186680_a;
        } else {
            this.lateralForceVec = this.wheelOreintation.func_178785_b((float)Math.toRadians(-90.0)).func_186678_a(this.lateralForce);
        }
    }

    public WheelSolver newInstance() {
        WheelSolver newSolve = new WheelSolver(this.tyreSize, this.wheelMass, this.isDrive, this.grassCoef).withRelativePosition(this.relativePosition);
        return newSolve;
    }

    public WheelSolver withRelativePosition(Vec3d vec) {
        this.setRelativePosition(vec);
        return this;
    }
}

