/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.jimphysics.solver;

import com.paneedah.weaponlib.vehicle.jimphysics.solver.VehiclePhysicsSolver;
import com.paneedah.weaponlib.vehicle.jimphysics.solver.WheelSolver;
import net.minecraft.util.math.Vec3d;

public class WheelAxel {
    public VehiclePhysicsSolver solver;
    public WheelSolver leftWheel;
    public WheelSolver rightWheel;
    double loadOnAxel;
    public boolean isDriveWheel;
    public double COGoffset;
    public boolean isHandbraking;
    public double tractionTorque;

    public WheelAxel(double offsetFromCOG, boolean isDriveWheel) {
        this.isDriveWheel = isDriveWheel;
        this.COGoffset = offsetFromCOG;
    }

    public WheelAxel newInstance() {
        WheelAxel newAxel = new WheelAxel(this.COGoffset, this.isDriveWheel);
        newAxel.withWheels(this.leftWheel.newInstance(), this.rightWheel.newInstance());
        return newAxel;
    }

    public void addWheels(WheelSolver left, WheelSolver right) {
        this.leftWheel = left;
        this.rightWheel = right;
    }

    public void assignSolver(VehiclePhysicsSolver solver) {
        this.solver = solver;
        this.leftWheel.assignSolver(solver);
        this.rightWheel.assignSolver(solver);
        this.solver.wheels.add(this.leftWheel);
        this.solver.wheels.add(this.rightWheel);
    }

    public void applyHandbrake() {
        this.isHandbraking = true;
    }

    public void releaseHandbrake() {
        this.isHandbraking = false;
    }

    public void applyBrakingForce(double magnitude) {
        this.leftWheel.driveTorque += -magnitude;
        this.rightWheel.driveTorque += -magnitude;
    }

    public void setSteeringAngle(double angle) {
        this.leftWheel.wheelAngle = -angle;
        this.rightWheel.wheelAngle = -angle;
    }

    public Vec3d getLongitudinalForce() {
        return this.leftWheel.longitudinalForce.func_178787_e(this.rightWheel.longitudinalForce);
    }

    public double latNonVec() {
        return this.leftWheel.lateralForce + this.rightWheel.lateralForce;
    }

    public double longNonVec() {
        return this.leftWheel.longForce + this.rightWheel.longForce;
    }

    public Vec3d getLateralForce() {
        return this.leftWheel.lateralForceVec.func_178787_e(this.rightWheel.lateralForceVec);
    }

    public Vec3d adjLateralForce() {
        return this.getLateralForce().func_178785_b((float)Math.toRadians((double)(-this.solver.vehicle.field_70177_z) + this.solver.vehicle.driftTuner));
    }

    public double getWheelAngularVelocity() {
        return this.leftWheel.wheelAngularVelocity;
    }

    public void applyDriveTorque(double torque) {
        this.leftWheel.driveTorque += torque;
        this.rightWheel.driveTorque += torque;
    }

    public void applySuspensionLoad(double load) {
        this.leftWheel.applySuspensionLoad(load);
        this.rightWheel.applySuspensionLoad(load);
    }

    public void distributeLoad(double load) {
        this.loadOnAxel = load;
        this.leftWheel.loadOnWheel = load;
        this.rightWheel.loadOnWheel = load;
    }

    public void doPhysics() {
        double angularAccel;
        this.leftWheel.doPhysics();
        this.rightWheel.doPhysics();
        double drTorque = this.leftWheel.driveTorque + this.rightWheel.driveTorque;
        this.tractionTorque = this.leftWheel.tractionTorque + this.rightWheel.tractionTorque;
        double totalTorque = drTorque + this.tractionTorque;
        double inertia = this.leftWheel.wheelInertia + this.rightWheel.wheelInertia;
        this.leftWheel.wheelAngularAcceleration = angularAccel = totalTorque / inertia;
        this.rightWheel.wheelAngularAcceleration = angularAccel;
        this.leftWheel.driveTorque = 0.0;
        this.rightWheel.driveTorque = 0.0;
    }

    public WheelAxel withWheels(WheelSolver left, WheelSolver right) {
        left.axel = this;
        right.axel = this;
        this.addWheels(left, right);
        return this;
    }
}

