/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.jimphysics;

import net.minecraft.util.math.Vec3d;

public class VehiclePhysUtil {
    public static double springEnergy(double k, double x) {
        return 0.5 * k * x * x;
    }

    public static double springForce(double k, double x) {
        return k * x;
    }

    public static double springStretchFromEnergy(double k, double energy) {
        return Math.sqrt(2.0 * energy / k);
    }

    public static Vec3d simpleTractionForce(Vec3d oreintation, double engineForce) {
        return oreintation.func_186678_a(engineForce);
    }

    public static double calculateLift(float coF, double longitudinalSpeed, double areaOfCar) {
        return 0.6125 * areaOfCar * (double)coF * (longitudinalSpeed * longitudinalSpeed);
    }

    public static Vec3d realDrag(float coF, Vec3d speed, double areaOfCar) {
        return speed.func_186678_a(0.5).func_186678_a((double)(-coF)).func_186678_a(0.2).func_186678_a(speed.func_189985_c());
    }

    public static Vec3d simpleDragForce(float dragC, Vec3d motionVector) {
        return motionVector.func_186678_a((double)(-dragC)).func_186678_a(motionVector.func_72433_c() * 100.0);
    }

    public static Vec3d rollingResistance(float cR, Vec3d motionVector) {
        return motionVector.func_186678_a((double)(-cR));
    }

    public static Vec3d brakingForce(float brakingC, Vec3d motionVector) {
        return motionVector.func_186678_a((double)(-brakingC));
    }

    public static double getAcceleration(double netForce, double weight) {
        return netForce / weight;
    }

    public static double getMaxForce(float mu, double mass) {
        return (double)mu * (mass * 9.81);
    }

    public static double getTotalWeightOfCar(double mass) {
        return mass * 9.81;
    }

    public static double frontWheelForce(double h, double weight, double wheelBase, double acceleration, double mass) {
        return 0.5 * weight - h / wheelBase * mass * acceleration;
    }

    public static double rearWheelForce(double h, double weight, double wheelBase, double acceleration, double mass) {
        return 0.5 * weight + h / wheelBase * mass * acceleration;
    }

    public static double getHorsePower(double torque, double rpm) {
        return torque * rpm / 5252.0;
    }

    public static double getDriveTorque(double engineTorque, double gearRatio, double finalDriveRatio, double tEf) {
        return engineTorque * gearRatio * finalDriveRatio * tEf;
    }

    public static double getDrF(double engineTorque, double gearRatio, double finalDriveRatio, double wheelRadius) {
        return engineTorque * gearRatio * finalDriveRatio / wheelRadius;
    }

    public static double getEngineRPM(double wheelRotationRate, double gearRatio, double finalDriveRatio) {
        return wheelRotationRate * gearRatio * finalDriveRatio * 60.0 / (Math.PI * 2);
    }

    public static double quickWheelSpeed(double carVelocity, double wheelRadius) {
        return carVelocity / wheelRadius;
    }

    public static double angularVelocityOfEngine(int rpm) {
        return Math.PI * 2 * (double)rpm / 60.0;
    }

    public static double wheelAngularVelocity(int rpm, double gearRatio, double finalDriveRatio) {
        return Math.PI * 2 * (double)rpm / (60.0 * gearRatio * finalDriveRatio);
    }

    public static double translationalVelocity(double wheelAngVelocity, double wheelRadius) {
        return wheelAngVelocity * wheelRadius;
    }

    public static Vec3d getAngularVelocityOfNoSlipWheel(Vec3d carSpeed, double wheelRadius) {
        double x = carSpeed.field_72450_a / (Math.PI * 2 * wheelRadius);
        double y = carSpeed.field_72448_b / (Math.PI * 2 * wheelRadius);
        double z = carSpeed.field_72449_c / (Math.PI * 2 * wheelRadius);
        return new Vec3d(x, y, z);
    }

    public static double getSlipRatio(double wheelAngularVelocity, double wheelRadius, double speed) {
        return (wheelAngularVelocity * wheelRadius - speed) / speed;
    }

    public static double pacejkaLong(double tireLoad, double slip, double shape, double peak, double curvature, double stiffness) {
        double F = tireLoad * peak * Math.sin(shape * Math.atan(stiffness * slip - curvature * (stiffness * slip - Math.atan(stiffness * slip))));
        return F;
    }

    public static double inertiaOfACylinder(double mass, double radius) {
        return mass * Math.pow(radius, 2.0) / 2.0;
    }

    public static double doubleRadiusOfLSTurn(double wheelBase, double steeringAngle) {
        return wheelBase / Math.sin(steeringAngle);
    }

    public static double carTurnRate(Vec3d speed, double turnRadius) {
        return speed.func_72433_c() / turnRadius;
    }

    public static Vec3d getActualLongitudinalForce(Vec3d nLongForce, double loadOnWheel) {
        return nLongForce.func_186678_a(loadOnWheel);
    }

    public static Vec3d longitudinalForce(Vec3d slipRatio, double tractionConstant) {
        return slipRatio.func_186678_a(tractionConstant);
    }

    public static Vec3d tractionTorque(Vec3d tractionForce, double wheelRadius) {
        return tractionForce.func_186678_a(wheelRadius);
    }

    public static Vec3d getTotalTorqueOnAxel(Vec3d driveTorque, Vec3d tractionTorqueOne, Vec3d tractionTorqueTwo, Vec3d brakeTorque) {
        return driveTorque.func_178787_e(tractionTorqueTwo).func_178787_e(tractionTorqueTwo).func_178787_e(brakeTorque);
    }

    public static double slipAngleFront(double latMag, double longMag, double angularVelocity, double disToAxel, double steeringAngle) {
        return Math.atan((latMag + angularVelocity * disToAxel) / longMag) - steeringAngle * Math.signum(longMag);
    }

    public static double slipAngleRear(double latMag, double longMag, double angularVelocity, double disToAxel) {
        return Math.atan((latMag - angularVelocity * disToAxel) / longMag);
    }
}

