/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.collisions;

import com.paneedah.weaponlib.vehicle.collisions.GJKResult;
import com.paneedah.weaponlib.vehicle.collisions.OreintedBB;
import com.paneedah.weaponlib.vehicle.collisions.RigidBody;
import com.paneedah.weaponlib.vehicle.collisions.Simplex;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.util.math.Vec3d;

public class OBBCollider {
    public static int gjkMaxAttempts = 64;
    public static int epaMaxAttempts = 128;
    public static float epsilon = 1.0E-5f;

    public static MKV CSOSupport(OreintedBB a, OreintedBB b, Vec3d dir) {
        Vec3d support = a.support(dir).func_178788_d(b.support(dir.func_186678_a(-1.0)));
        return new MKV(support, dir);
    }

    public static GJKResult areColliding(OreintedBB one, OreintedBB two) {
        GJKResult result = new GJKResult();
        Simplex simplex = new Simplex();
        Vec3d direction = new Vec3d(0.0, 0.0, 1.0);
        MKV support = OBBCollider.CSOSupport(one, two, direction);
        simplex.addPoint(support);
        direction = support.v.func_186678_a(-1.0);
        block6: for (int x = 0; x < gjkMaxAttempts; ++x) {
            support = OBBCollider.CSOSupport(one, two, direction);
            if (support.v.func_72430_b(direction) < 0.0) {
                result.status = GJKResult.Status.SEPARATED;
                return result;
            }
            simplex.addPoint(support);
            switch (simplex.getSize()) {
                case 0: 
                case 1: {
                    continue block6;
                }
                case 2: {
                    Vec3d ab = simplex.points[1].v.func_178788_d(simplex.points[0].v);
                    Vec3d ao = simplex.points[0].v.func_186678_a(-1.0);
                    if (ab.func_72430_b(ao) > 0.0) {
                        direction = ab.func_72431_c(ao).func_72431_c(ab);
                        continue block6;
                    }
                    simplex.points[1] = null;
                    --simplex.size;
                    direction = ao;
                    continue block6;
                }
                case 3: {
                    Vec3d ab = simplex.points[1].v.func_178788_d(simplex.points[0].v);
                    Vec3d ao = simplex.points[0].v.func_186678_a(-1.0);
                    Vec3d ac = simplex.points[2].v.func_178788_d(simplex.points[0].v);
                    Vec3d abc = ab.func_72431_c(ac);
                    direction = OBBCollider.checkTriangleCase(simplex, ab, ac, abc, ao);
                    continue block6;
                }
                case 4: {
                    Vec3d ab = simplex.points[1].v.func_178788_d(simplex.points[0].v);
                    Vec3d ao = simplex.points[0].v.func_186678_a(-1.0);
                    Vec3d ac = simplex.points[2].v.func_178788_d(simplex.points[0].v);
                    Vec3d ad = simplex.points[3].v.func_178788_d(simplex.points[0].v);
                    Vec3d tetraCheck = OBBCollider.checkTetrahedralCase(simplex, ab, ac, ad, ao);
                    if (tetraCheck == null) {
                        OBBCollider.runEPA(result, simplex, one, two);
                        return result;
                    }
                    direction = tetraCheck;
                }
            }
        }
        System.out.println("GJK Failure " + simplex.getSize());
        result.status = GJKResult.Status.FAILED;
        return result;
    }

    public static Vec3d localSupport(RigidBody body, OreintedBB c, Vec3d worldDir) {
        double margin = 0.0;
        if (body != null) {
            Vec3d localDir = body.globalToLocalVec(worldDir);
            if (margin != 0.0) {
                localDir = localDir.func_72432_b();
                return body.localToGlobalPos(c.support(localDir).func_178787_e(localDir.func_186678_a(margin)));
            }
            return body.localToGlobalPos(c.support(localDir));
        }
        if (margin != 0.0) {
            worldDir = worldDir.func_72432_b();
            return c.support(worldDir).func_178787_e(worldDir.func_186678_a(margin));
        }
        return c.support(worldDir);
    }

    public static Vec3d checkTetrahedralCase(Simplex simp, Vec3d ab, Vec3d ac, Vec3d ad, Vec3d ao) {
        if (ab.func_72431_c(ac).func_72430_b(ao) > 0.0) {
            simp.points[3] = null;
            --simp.size;
            return OBBCollider.checkTriangleCase(simp, ab, ac, ab.func_72431_c(ac), ao);
        }
        if (ac.func_72431_c(ad).func_72430_b(ao) > 0.0) {
            simp.points[1] = simp.points[2];
            simp.points[2] = simp.points[3];
            simp.points[3] = null;
            --simp.size;
            return OBBCollider.checkTriangleCase(simp, ac, ad, ac.func_72431_c(ad), ao);
        }
        if (ad.func_72431_c(ab).func_72430_b(ao) > 0.0) {
            simp.points[2] = simp.points[1];
            simp.points[1] = simp.points[3];
            simp.points[3] = null;
            --simp.size;
            return OBBCollider.checkTriangleCase(simp, ad, ab, ad.func_72431_c(ab), ao);
        }
        return null;
    }

    public static Vec3d checkTriangleCase(Simplex simp, Vec3d ab, Vec3d ac, Vec3d abc, Vec3d ao) {
        Vec3d direction = Vec3d.field_186680_a;
        if (abc.func_72431_c(ac).func_72430_b(ao) > 0.0) {
            if (ac.func_72430_b(ao) > 0.0) {
                simp.points[1] = simp.points[2];
                simp.points[2] = null;
                --simp.size;
                return ac.func_72431_c(ao).func_72431_c(ac);
            }
            return OBBCollider.specialTriangleCase(simp, ab, ac, abc, ao);
        }
        if (ab.func_72431_c(abc).func_72430_b(ao) > 0.0) {
            return OBBCollider.specialTriangleCase(simp, ab, ac, abc, ao);
        }
        if (abc.func_72430_b(ao) > 0.0) {
            return abc;
        }
        MKV temp = simp.points[2];
        simp.points[2] = simp.points[1];
        simp.points[1] = temp;
        return abc.func_186678_a(-1.0);
    }

    public static Vec3d specialTriangleCase(Simplex simp, Vec3d ab, Vec3d ac, Vec3d abc, Vec3d ao) {
        if (ab.func_72430_b(ao) > 0.0) {
            simp.points[2] = null;
            --simp.size;
            return ab.func_72431_c(ao).func_72431_c(ab);
        }
        simp.points[1] = null;
        simp.points[2] = null;
        simp.size -= 2;
        return ao;
    }

    public static void runEPA(GJKResult result, Simplex simplex, OreintedBB one, OreintedBB two) {
        ArrayList<MKV[]> faces = new ArrayList<MKV[]>();
        ArrayList<MKV[]> edges = new ArrayList<MKV[]>();
        faces.add(OBBCollider.generateFace(simplex.points[0], simplex.points[1], simplex.points[2]));
        faces.add(OBBCollider.generateFace(simplex.points[0], simplex.points[2], simplex.points[3]));
        faces.add(OBBCollider.generateFace(simplex.points[0], simplex.points[3], simplex.points[1]));
        faces.add(OBBCollider.generateFace(simplex.points[1], simplex.points[2], simplex.points[3]));
        for (int r = 0; r < epaMaxAttempts; ++r) {
            MKV[] closestFace = null;
            float startingMin = Float.MAX_VALUE;
            for (MKV[] face : faces) {
                float dist = OBBCollider.originToPlane(face);
                if (!(dist < startingMin)) continue;
                closestFace = face;
                startingMin = dist;
            }
            MKV support = OBBCollider.CSOSupport(one, two, closestFace[3].v);
            if (OBBCollider.distanceToPlane(closestFace, support.v) < epsilon) {
                result.status = GJKResult.Status.COLLIDING;
                Vec3d spV = OBBCollider.planeProjectOrigin(closestFace);
                result.separationVector = spV.func_72432_b();
                result.penetrationDepth = spV.func_72433_c();
                Vec3d[][] com = new Vec3d[2][3];
                for (int s = 0; s < 3; s = (int)((short)(s + 1))) {
                    com[0][s] = one.support(closestFace[s].u);
                    com[1][s] = two.support(closestFace[s].u.func_186678_a(-1.0));
                }
                Vec3d baryCoords = OBBCollider.calculateBarycentric(closestFace, spV);
                Vec3d cA = new Vec3d(com[0][0].field_72450_a * baryCoords.field_72450_a + com[0][1].field_72450_a * baryCoords.field_72448_b + com[0][2].field_72450_a * baryCoords.field_72449_c, com[0][0].field_72448_b * baryCoords.field_72450_a + com[0][1].field_72448_b * baryCoords.field_72448_b + com[0][2].field_72448_b * baryCoords.field_72449_c, com[0][0].field_72449_c * baryCoords.field_72450_a + com[0][1].field_72449_c * baryCoords.field_72448_b + com[0][2].field_72449_c * baryCoords.field_72449_c);
                Vec3d cB = new Vec3d(com[1][0].field_72450_a * baryCoords.field_72450_a + com[1][1].field_72450_a * baryCoords.field_72448_b + com[1][2].field_72450_a * baryCoords.field_72449_c, com[1][0].field_72448_b * baryCoords.field_72450_a + com[1][1].field_72448_b * baryCoords.field_72448_b + com[1][2].field_72448_b * baryCoords.field_72449_c, com[1][0].field_72449_c * baryCoords.field_72450_a + com[1][1].field_72449_c * baryCoords.field_72448_b + com[1][2].field_72449_c * baryCoords.field_72449_c);
                result.contactPointA = cA;
                result.contactPointB = cB;
                return;
            }
            Iterator faceItr = faces.iterator();
            while (faceItr.hasNext()) {
                MKV[] face = (MKV[])faceItr.next();
                Vec3d normal = face[3].v;
                if (!(normal.func_72430_b(support.v.func_178788_d(face[0].v)) > 0.0)) continue;
                faceItr.remove();
                MKV[] edgeOne = new MKV[]{face[1], face[0]};
                MKV[] edgeTwo = new MKV[]{face[2], face[1]};
                MKV[] edgeThree = new MKV[]{face[0], face[2]};
                if (OBBCollider.isEdgeUnique(edges, edgeOne)) {
                    edges.add(OBBCollider.reverseEdge(edgeOne));
                }
                if (OBBCollider.isEdgeUnique(edges, edgeTwo)) {
                    edges.add(OBBCollider.reverseEdge(edgeTwo));
                }
                if (!OBBCollider.isEdgeUnique(edges, edgeThree)) continue;
                edges.add(OBBCollider.reverseEdge(edgeThree));
            }
            for (MKV[] edge : edges) {
                faces.add(OBBCollider.generateFace(edge[0], edge[1], support));
            }
            edges.clear();
        }
        System.out.println("Failed");
        result.status = GJKResult.Status.FAILED;
    }

    public static Vec3d calculateBarycentric(MKV[] face, Vec3d point) {
        float u = (float)face[1].v.func_178788_d(point).func_72431_c(face[2].v.func_178788_d(point)).func_72433_c();
        float v = (float)face[0].v.func_178788_d(point).func_72431_c(face[2].v.func_178788_d(point)).func_72433_c();
        float w = (float)face[0].v.func_178788_d(point).func_72431_c(face[1].v.func_178788_d(point)).func_72433_c();
        float uvw = u + v + w;
        return new Vec3d((double)u, (double)v, (double)w).func_186678_a((double)(1.0f / uvw));
    }

    public static Vec3d planeProjectOrigin(MKV[] face) {
        Vec3d point = face[0].v.func_186678_a(-1.0);
        double dot = face[3].v.func_72430_b(point);
        return face[3].v.func_186678_a(dot).func_186678_a(-1.0);
    }

    public static MKV[] reverseEdge(MKV[] edge) {
        return new MKV[]{edge[1], edge[0]};
    }

    public static MKV[] makeEdge(MKV one, MKV two) {
        return new MKV[]{one, two};
    }

    public static boolean isEdgeUnique(ArrayList<MKV[]> edgeList, MKV[] edge) {
        Iterator<MKV[]> edgeItr = edgeList.iterator();
        while (edgeItr.hasNext()) {
            MKV[] toCompare = edgeItr.next();
            if (edge[0] != toCompare[0] || edge[1] != toCompare[1]) continue;
            edgeItr.remove();
            return false;
        }
        return true;
    }

    public static MKV[] generateFace(MKV a, MKV b, MKV c) {
        MKV[] face = new MKV[4];
        Vec3d ab = b.v.func_178788_d(a.v);
        Vec3d ac = c.v.func_178788_d(a.v);
        Vec3d ao = a.v.func_186678_a(-1.0);
        Vec3d normalVec = ab.func_72431_c(ac).func_72432_b();
        face = normalVec.func_72430_b(ao) < 0.0 ? new MKV[]{a, b, c, new MKV(normalVec, null)} : new MKV[]{a, c, b, new MKV(normalVec.func_186678_a(-1.0), null)};
        return face;
    }

    public static float distanceToPlane(MKV[] face, Vec3d point) {
        double dot = face[3].v.func_72430_b(point.func_178788_d(face[0].v));
        Vec3d proj = face[3].v.func_186678_a(dot);
        return (float)proj.func_189985_c();
    }

    public static float originToPlane(MKV[] face) {
        double dot = face[0].v.func_72430_b(face[3].v);
        Vec3d proj = face[3].v.func_186678_a(dot);
        return (float)proj.func_189985_c();
    }

    public static class MKV {
        Vec3d v;
        Vec3d u;

        public MKV(Vec3d pos, Vec3d dir) {
            this.v = pos;
            this.u = dir;
        }
    }
}

