/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle;

public class SimpleAnimationTimer {
    private int time = 0;
    private int maxTime;
    private boolean isDone = false;
    private boolean shouldLoop = false;

    public SimpleAnimationTimer(int maxTime, boolean loop) {
        this.maxTime = maxTime;
        this.shouldLoop = loop;
    }

    public void setMaxTime(int max) {
        this.maxTime = this.maxTime;
    }

    public void setLoop(boolean shouldLoop) {
        this.shouldLoop = shouldLoop;
    }

    public void tick() {
        if (this.shouldLoop) {
            if (this.isDone) {
                this.reset();
            }
        } else if (this.isDone) {
            return;
        }
        ++this.time;
        if (this.time >= this.maxTime) {
            this.isDone = true;
            this.time = this.maxTime;
        }
    }

    public boolean isComplete() {
        return this.isDone;
    }

    public void reset() {
        this.isDone = false;
        this.time = 0;
    }

    public double getLinearProgress() {
        return (double)this.time / (double)this.maxTime;
    }

    public double getSmoothStepProgress() {
        float mu2 = (float)((1.0 - Math.cos(this.getLinearProgress() * Math.PI)) / 2.0);
        return mu2;
    }

    public double smoothInterpDouble(double start, double end) {
        return start + (end - start) * this.getSmoothStepProgress();
    }
}

