/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.animation.MatrixHelper;
import com.paneedah.weaponlib.debug.DebugRenderer;
import com.paneedah.weaponlib.vehicle.EntityVehicle;
import com.paneedah.weaponlib.vehicle.PartRenderContext;
import com.paneedah.weaponlib.vehicle.StatefulRenderer;
import com.paneedah.weaponlib.vehicle.VehicleRenderableState;
import com.paneedah.weaponlib.vehicle.collisions.GJKResult;
import com.paneedah.weaponlib.vehicle.collisions.OBBCollider;
import com.paneedah.weaponlib.vehicle.collisions.OreintedBB;
import com.paneedah.weaponlib.vehicle.collisions.RigidBody;
import com.paneedah.weaponlib.vehicle.jimphysics.InterpolationKit;
import com.paneedah.weaponlib.vehicle.jimphysics.solver.SuspensionSolver;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3d;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

public class RenderVehicle2
extends Render<Entity> {
    public static final ResourceLocation VEHICLE_SHADOW = new ResourceLocation("mwc:textures/entity/vehicleshadow.png");
    private static ThreadLocal<Matrix4f> cameraTransformMatrix = new ThreadLocal();
    private static ResourceLocation field_110782_f;
    private StatefulRenderer<VehicleRenderableState> mainRenderer;
    private VehicleRenderableState currentRenderableState;
    public static Matrix4f tm;
    public static SuspensionSolver susSolve;
    public RigidBody bruhBody = null;

    public RenderVehicle2(StatefulRenderer<VehicleRenderableState> mainRenderer) {
        super(ClientProxy.MC.func_175598_ae());
        this.field_76989_e = 0.5f;
        this.mainRenderer = mainRenderer;
    }

    public void rigidBodyTest(EntityVehicle v) {
        try {
            DebugRenderer.setupBasicRender();
            Vec3d playerPos = ClientProxy.MC.field_71439_g.func_174791_d();
            GL11.glTranslated((double)(-playerPos.field_72450_a), (double)(-playerPos.field_72448_b), (double)(-playerPos.field_72449_c));
            Vec3d posVec = v.func_174791_d();
            if (this.bruhBody == null) {
                this.bruhBody = new RigidBody(v.field_70170_p, posVec.field_72450_a, posVec.field_72448_b + 10.0, posVec.field_72449_c);
                OreintedBB obb = new OreintedBB(new AxisAlignedBB(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0));
                obb.setupPhysically(175.0);
                this.bruhBody.addColliders(obb);
            }
            this.bruhBody.minecraftTimestep();
            Vec3d p = this.bruhBody.position;
            Vec3d adjP = v.func_174791_d().func_178788_d(p);
            GL11.glTranslated((double)p.field_72450_a, (double)p.field_72448_b, (double)p.field_72449_c);
            this.bruhBody.colliders.get(0).renderOBB();
            DebugRenderer.destructBasicRender();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("fuck!");
        }
    }

    public void OBBTest() {
        DebugRenderer.setupBasicRender();
        GL11.glTranslated((double)0.0, (double)-5.0, (double)0.0);
        OreintedBB ob2 = new OreintedBB(new AxisAlignedBB(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0));
        ob2.move(1.0, 2.1, 0.0);
        ob2.rotate(Math.toRadians(0.0), Math.toRadians(0.0), Math.toRadians(45.0));
        OreintedBB ob = new OreintedBB(new AxisAlignedBB(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0));
        ob.rotate(Math.toRadians(0.0), Math.toRadians(0.0), Math.toRadians(15.0));
        GJKResult result = OBBCollider.areColliding(ob, ob2);
        if (result.status == GJKResult.Status.COLLIDING) {
            Vec3d sepVec = result.separationVector.func_186678_a(result.penetrationDepth);
            ob2.move(sepVec.field_72450_a, sepVec.field_72448_b, sepVec.field_72449_c);
            DebugRenderer.renderPoint(result.contactPointA, new Vec3d(0.0, 0.0, 1.0));
            DebugRenderer.renderPoint(result.contactPointB, new Vec3d(0.0, 0.0, 1.0));
        }
        ob.renderOBB();
        ob2.renderOBB();
        DebugRenderer.destructBasicRender();
    }

    public void renderPlane(Vec3d[] list) {
        boolean red = true;
        boolean blue = false;
        boolean green = false;
        boolean alpha = true;
        DebugRenderer.setupBasicRender();
        DebugRenderer.renderLine(list[0], list[1], new Vec3d(1.0, 0.0, 0.0));
        DebugRenderer.renderLine(list[1], list[3], new Vec3d(1.0, 0.0, 0.0));
        DebugRenderer.renderLine(list[3], list[2], new Vec3d(1.0, 0.0, 0.0));
        DebugRenderer.renderLine(list[0], list[2], new Vec3d(1.0, 0.0, 0.0));
        DebugRenderer.destructBasicRender();
    }

    public void renderVehicle(EntityVehicle entityVehicle, double posX, double posY, double posZ, float rotationYaw, float par9) {
        boolean isPlayerRiding;
        Vec3d endLift;
        Vec3d startLift;
        RayTraceResult rtr;
        int renderPass = MinecraftForgeClient.getRenderPass();
        GL11.glPushMatrix();
        DebugRenderer.setupBasicRender();
        GL11.glTranslatef((float)((float)posX), (float)((float)posY), (float)((float)posZ));
        double sr = entityVehicle.getSolver().rearAxel.leftWheel.slipRatio;
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (ClientProxy.MC.func_175598_ae().func_178634_b()) {
            entityVehicle.oreintedBoundingBox.renderOBB();
        }
        DebugRenderer.destructBasicRender();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.invertCameraTransform();
        EntityVehicle v = entityVehicle;
        float pt = ClientProxy.MC.func_184121_ak();
        GL11.glTranslatef((float)((float)posX), (float)((float)posY), (float)((float)posZ));
        float muRoll = (float)((1.0 - Math.cos((double)ClientProxy.MC.func_184121_ak() * Math.PI)) / 2.0);
        float roll = entityVehicle.prevRotationRollH + entityVehicle.prevRotationRoll + (entityVehicle.rotationRoll + entityVehicle.rotationRollH - (entityVehicle.prevRotationRoll + entityVehicle.prevRotationRollH)) * muRoll;
        GL11.glRotatef((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        if (ClientProxy.MC.field_71474_y.field_74320_O == 0) {
            GL11.glRotatef((float)roll, (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GL11.glRotatef((float)roll, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        float mu2 = ClientProxy.MC.func_184121_ak();
        float interpPitch = entityVehicle.field_70127_C + (entityVehicle.field_70125_A - entityVehicle.field_70127_C) * mu2;
        if (ClientProxy.MC.field_71474_y.field_74320_O != 0) {
            GL11.glRotatef((float)interpPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GL11.glRotatef((float)interpPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (ClientProxy.MC.field_71474_y.field_74320_O == 0 || entityVehicle.field_70122_E || entityVehicle.field_70125_A > 3.0f) {
            // empty if block
        }
        if ((rtr = entityVehicle.field_70170_p.func_147447_a(startLift = InterpolationKit.interpolatedEntityPosition(entityVehicle), endLift = startLift.func_178788_d(new Vec3d(0.0, 10.0, 0.0).func_178789_a((float)Math.toRadians(entityVehicle.field_70125_A)).func_178785_b((float)Math.toRadians(-rotationYaw))), false, true, false)) != null) {
            entityVehicle.prevLiftOffset = entityVehicle.liftOffset;
            entityVehicle.liftOffset = (float)rtr.field_72307_f.func_178788_d(startLift).func_72433_c();
        }
        if (renderPass == 0) {
            for (Entity pass : entityVehicle.func_184188_bt()) {
                if (ClientProxy.MC.field_71474_y.field_74320_O == 0 && pass == ClientProxy.MC.field_71439_g) continue;
                GL11.glPushMatrix();
                GL11.glScaled((double)0.95, (double)0.95, (double)0.95);
                int i = entityVehicle.func_184188_bt().indexOf(pass);
                Vec3d seatOffset = entityVehicle.getConfiguration().getSeatAtIndex(i).getSeatPosition();
                GL11.glTranslated((double)(-seatOffset.field_72450_a), (double)seatOffset.field_72448_b, (double)(-seatOffset.field_72449_c));
                if (!(pass instanceof EntityPlayer)) {
                    ClientProxy.MC.func_175598_ae().func_188391_a(pass, 0.0, 0.0, 0.0, -pass.field_70177_z, ClientProxy.MC.func_184121_ak(), true);
                } else {
                    EntityPlayer player = (EntityPlayer)pass;
                    RenderManager rManager = ClientProxy.MC.func_175598_ae();
                    Render render = rManager.func_78713_a(pass);
                    player.field_70177_z += entityVehicle.deltaRotation;
                    player.func_70034_d(player.func_70079_am() + entityVehicle.deltaRotation);
                    entityVehicle.applyYawToEntity((Entity)player);
                    player.field_184619_aG = 39.0f;
                    float aPH = player.field_70125_A;
                    float apPH = player.field_70127_C;
                    float aY = player.field_70177_z;
                    float apY = player.field_70126_B;
                    float aYO = player.field_70761_aq;
                    float apYO = player.field_70760_ar;
                    player.field_70759_as = 180.0f;
                    player.field_70125_A = 0.0f;
                    player.field_70127_C = 0.0f;
                    player.field_70177_z = 180.0f;
                    player.field_70126_B = 180.0f;
                    player.field_70761_aq = 180.0f;
                    player.field_70760_ar = 180.0f;
                    render.func_76986_a((Entity)player, 0.0, 0.0, 0.0, 180.0f, ClientProxy.MC.func_184121_ak());
                    player.field_70761_aq = aYO;
                    player.field_70760_ar = apYO;
                    player.field_70125_A = aPH;
                    player.field_70127_C = apPH;
                    player.field_70177_z = aY;
                    player.field_70126_B = apY;
                    player.field_184619_aG = 89.0f;
                }
                GL11.glPopMatrix();
            }
        }
        float f4 = 0.75f;
        GL11.glScalef((float)f4, (float)f4, (float)f4);
        GL11.glScalef((float)(0.6f / f4), (float)(0.6f / f4), (float)(0.6f / f4));
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        VehicleRenderableState renderState = null;
        switch (entityVehicle.getState()) {
            case OFF: 
            case IDLE: {
                renderState = VehicleRenderableState.IDLE;
                break;
            }
            case STARTING_TO_DRIVE: {
                renderState = VehicleRenderableState.PREPARED_TO_DRIVE;
                break;
            }
            case STOPPING: {
                renderState = VehicleRenderableState.STOPPING;
                break;
            }
            case DRIVING: {
                renderState = VehicleRenderableState.DRIVING;
                break;
            }
            case STARTING_TO_SHIFT: {
                renderState = VehicleRenderableState.STARTING_SHIFT;
                break;
            }
            case SHIFTING: {
                renderState = VehicleRenderableState.SHIFTING;
                break;
            }
            case FINISHING_SHIFT: {
                renderState = VehicleRenderableState.FINISHING_SHIFT;
            }
        }
        PartRenderContext<VehicleRenderableState> context = new PartRenderContext<VehicleRenderableState>();
        context.setState(renderState);
        context.setEntity(entityVehicle);
        context.setScale(0.0625f);
        this.mainRenderer.render(context);
        EntityPlayerSP player = ClientProxy.MC.field_71439_g;
        int gameView = ClientProxy.MC.field_71474_y.field_74320_O;
        boolean isRidingVehicle = isPlayerRiding = player.func_184218_aH();
        if (isRidingVehicle) {
            isRidingVehicle = player.func_184187_bx() instanceof EntityVehicle;
        }
        if (entityVehicle.isBraking && (gameView != 0 || !isRidingVehicle || (EntityVehicle)player.func_184187_bx() != entityVehicle)) {
            GlStateManager.func_179147_l();
            GL11.glScaled((double)1.0001, (double)1.0001, (double)1.0001);
            GlStateManager.func_179112_b((int)770, (int)1);
            ResourceLocation loc = new ResourceLocation("mwc:textures/entity/audis4lights.png");
            context.renderAlternateTexture(loc);
            this.mainRenderer.render(context);
            GlStateManager.func_179084_k();
        }
        ResourceLocation loc = new ResourceLocation("mwc:textures/entity/suspensionblue.png");
        ClientProxy.MC.func_110434_K().func_110577_a(loc);
        GL11.glPopMatrix();
        this.field_76989_e = 0.1f;
    }

    public void func_76979_b(Entity entityIn, double x, double y, double z, float yaw, float partialTicks) {
        double d0;
        float f;
        if (this.field_76990_c.field_78733_k != null && this.field_76990_c.field_78733_k.field_181151_V && this.field_76989_e > 0.0f && !entityIn.func_82150_aj() && this.field_76990_c.func_178627_a() && (f = (float)((1.0 - (d0 = this.field_76990_c.func_78714_a(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v)) / 256.0) * (double)this.field_76987_f)) > 0.0f) {
            this.func_76975_c(entityIn, x, y, z, f, partialTicks);
        }
    }

    public void func_76975_c(Entity entityIn, double x, double y, double z, float yaw, float partialTicks) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.field_76990_c.field_78724_e.func_110577_a(VEHICLE_SHADOW);
        World world = entityIn.field_70170_p;
        GlStateManager.func_179132_a((boolean)false);
        float f = this.field_76989_e;
        if (entityIn instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entityIn;
            f *= entityliving.func_70603_bj();
            if (entityliving.func_70631_g_()) {
                f *= 0.5f;
            }
        }
        double d5 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d0 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d1 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        int i = MathHelper.func_76128_c((double)(d5 - (double)f));
        int j = MathHelper.func_76128_c((double)(d5 + (double)f));
        int k = MathHelper.func_76128_c((double)(d0 - (double)f));
        int l = MathHelper.func_76128_c((double)d0);
        int i1 = MathHelper.func_76128_c((double)(d1 - (double)f));
        int j1 = MathHelper.func_76128_c((double)(d1 + (double)f));
        double d2 = x - d5;
        double d3 = y - d0;
        double d4 = z - d1;
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)new BlockPos(i, k, i1), (BlockPos)new BlockPos(j, l, j1))) {
            IBlockState iblockstate = world.func_180495_p(blockpos.func_177977_b());
            if (iblockstate.func_185901_i() == EnumBlockRenderType.INVISIBLE || world.func_175671_l(blockpos) <= 3) continue;
            this.renderShadowSingle(entityIn, iblockstate, x, y, z, blockpos, 0.7f, f, d2, d3, d4);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GL11.glPopMatrix();
    }

    private void renderShadowSingle(Entity e, IBlockState state, double p_188299_2_, double p_188299_4_, double p_188299_6_, BlockPos pos, float p_188299_9_, float p_188299_10_, double p_188299_11_, double p_188299_13_, double p_188299_15_) {
    }

    public static Vector3d matrixToEuler(Matrix3f rotation) {
        double z;
        double y;
        double x;
        boolean singular;
        double sy = Math.sqrt(rotation.m00 * rotation.m00 + rotation.m10 * rotation.m10);
        boolean bl = singular = sy < 1.0E-6;
        if (!singular) {
            x = Math.atan2(rotation.m21, rotation.m22);
            y = Math.atan2(-rotation.m20, sy);
            z = Math.atan2(rotation.m10, rotation.m00);
        } else {
            x = Math.atan2(-rotation.m12, rotation.m11);
            y = Math.atan2(-rotation.m20, sy);
            z = 0.0;
        }
        return new Vector3d(x, y, z);
    }

    private void invertCameraTransform() {
        Matrix4f currentTransformMatrix = cameraTransformMatrix.get();
        if (currentTransformMatrix != null) {
            Matrix4f inverse = Matrix4f.invert((Matrix4f)currentTransformMatrix, null);
            Matrix4f currentMatrix = MatrixHelper.captureMatrix();
            Matrix4f composite = Matrix4f.mul((Matrix4f)inverse, (Matrix4f)currentMatrix, null);
            MatrixHelper.loadMatrix(composite);
        }
    }

    public static void captureCameraTransform(Matrix4f transformMatrix) {
        cameraTransformMatrix.set(transformMatrix);
    }

    protected ResourceLocation func_110775_a(Entity par1Entity) {
        return null;
    }

    public void func_76986_a(Entity par1Entity, double par2, double par4, double par6, float par8, float par9) {
        this.renderVehicle((EntityVehicle)par1Entity, par2, par4, par6, par8, par9);
    }

    static {
        tm = new Matrix4f();
        susSolve = new SuspensionSolver(271.0, 1.0);
    }
}

