/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.animation.DebugPositioner;
import com.paneedah.weaponlib.animation.MultipartPositioning;
import com.paneedah.weaponlib.animation.MultipartRenderStateManager;
import com.paneedah.weaponlib.vehicle.EntityVehicle;
import com.paneedah.weaponlib.vehicle.PartContainer;
import com.paneedah.weaponlib.vehicle.PartRenderContext;
import com.paneedah.weaponlib.vehicle.StatefulRenderer;
import com.paneedah.weaponlib.vehicle.VehiclePart;
import com.paneedah.weaponlib.vehicle.VehicleState;
import com.paneedah.weaponlib.vehicle.jimphysics.InterpolationKit;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

final class HierarchicalPartRenderer<Part, State>
implements StatefulRenderer<State> {
    private StatefulRenderer<State> modelRenderer;
    private ResourceLocation textureResource;
    private Part part;
    protected Map<Part, HierarchicalPartRenderer<Part, State>> partRenderers;
    protected Supplier<MultipartRenderStateManager<State, SinglePart, PartRenderContext<State>>> stateManagerSupplier;
    private BiConsumer<MultipartRenderStateManager<State, SinglePart, PartRenderContext<State>>, PartRenderContext<State>> stateSetter;
    private Function<PartRenderContext<State>, Float> currentProgressProvider;
    private Map<Entity, MultipartRenderStateManager<State, SinglePart, PartRenderContext<State>>> stateManagers = new HashMap<Entity, MultipartRenderStateManager<State, SinglePart, PartRenderContext<State>>>();

    protected HierarchicalPartRenderer(Part part, StatefulRenderer<State> modelRenderer, ResourceLocation textureResource, Map<Part, HierarchicalPartRenderer<Part, State>> partRenderers, Supplier<MultipartRenderStateManager<State, SinglePart, PartRenderContext<State>>> stateManagerSupplier, BiConsumer<MultipartRenderStateManager<State, SinglePart, PartRenderContext<State>>, PartRenderContext<State>> stateSetter, Function<PartRenderContext<State>, Float> currentProgressProvider) {
        this.part = part;
        this.modelRenderer = modelRenderer;
        this.textureResource = textureResource;
        this.partRenderers = partRenderers;
        this.stateManagerSupplier = stateManagerSupplier;
        this.stateSetter = stateSetter;
        this.currentProgressProvider = currentProgressProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(PartRenderContext<State> context) {
        MultipartRenderStateManager stateManager = this.stateManagers.computeIfAbsent(context.getEntity(), e -> this.stateManagerSupplier.get());
        this.stateSetter.accept(stateManager, context);
        MultipartPositioning multipartPositioning = stateManager.nextPositioning();
        MultipartPositioning.Positioner<SinglePart, PartRenderContext<State>> positioner = multipartPositioning.getPositioner();
        context.setProgress(this.currentProgressProvider.apply(context).floatValue());
        if (context.shouldRenderAlternateTexture()) {
            ClientProxy.MC.func_110434_K().func_110577_a(context.getAlternateTexture());
        } else {
            ClientProxy.MC.func_110434_K().func_110577_a(this.textureResource);
        }
        GL11.glPushMatrix();
        try {
            boolean shiftState;
            EntityVehicle v = (EntityVehicle)context.getEntity();
            VehicleState state = v.getState();
            positioner.position(SinglePart.MAIN, context);
            if (DebugPositioner.isDebugModeEnabled()) {
                DebugPositioner.position(this.part, context);
            }
            int pass = MinecraftForgeClient.getRenderPass();
            double susRoll = InterpolationKit.interpolateValue(v.getSolver().prevSuspensionRoll, v.getSolver().suspensionRoll, ClientProxy.MC.func_184121_ak());
            double susPitch = InterpolationKit.interpolateValue(v.getSolver().prevSuspensionPitch, v.getSolver().suspensionPitch, ClientProxy.MC.func_184121_ak());
            if (pass == 0 && this.part != VehiclePart.WINDOWS) {
                if (this.part == VehiclePart.MAIN) {
                    GL11.glRotated((double)susRoll, (double)0.0, (double)0.0, (double)1.0);
                    GL11.glRotated((double)susPitch, (double)1.0, (double)0.0, (double)0.0);
                    this.modelRenderer.render(context);
                    GL11.glRotated((double)(-susPitch), (double)1.0, (double)0.0, (double)0.0);
                    GL11.glRotated((double)(-susRoll), (double)0.0, (double)0.0, (double)1.0);
                } else {
                    this.modelRenderer.render(context);
                }
            } else if (pass == 1 && this.part == VehiclePart.WINDOWS) {
                if (this.part == VehiclePart.WINDOWS) {
                    GlStateManager.func_179147_l();
                    float transparency = 0.5f;
                    if (ClientProxy.MC.field_71474_y.field_74320_O == 0) {
                        transparency = 0.2f;
                    }
                    GlStateManager.func_179131_c((float)0.1f, (float)0.1f, (float)0.15f, (float)transparency);
                }
                this.modelRenderer.render(context);
            }
            boolean bl = shiftState = state == VehicleState.STARTING_TO_SHIFT || state == VehicleState.SHIFTING || state == VehicleState.FINISHING_SHIFT;
            if (this.part instanceof PartContainer) {
                for (Object renderablePart : ((PartContainer)this.part).getChildParts()) {
                    HierarchicalPartRenderer<Part, State> partRenderer = this.partRenderers.get(renderablePart);
                    if (partRenderer == null || v.getConfiguration().performShiftAnimation() && (!v.getConfiguration().shiftWithRight() ? renderablePart == VehiclePart.LEFT_HAND && (this.part == VehiclePart.MAIN && !shiftState || this.part == VehiclePart.STEERING_WHEEL && shiftState) : renderablePart == VehiclePart.RIGHT_HAND && (this.part == VehiclePart.MAIN && !shiftState || this.part == VehiclePart.STEERING_WHEEL && shiftState))) continue;
                    if (renderablePart == VehiclePart.RIGHT_HAND && (!v.getConfiguration().shiftWithRight() || !v.getConfiguration().performShiftAnimation()) && this.part == VehiclePart.MAIN || renderablePart == VehiclePart.LEFT_HAND && (v.getConfiguration().shiftWithRight() || !v.getConfiguration().performShiftAnimation()) && this.part == VehiclePart.MAIN) continue;
                    partRenderer.render(context);
                }
            }
        }
        finally {
            GL11.glPopMatrix();
        }
    }

    static enum SinglePart {
        MAIN;

    }
}

