/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.state;

import com.paneedah.mwc.network.TypeRegistry;
import com.paneedah.mwc.network.UniversalObject;
import com.paneedah.weaponlib.state.ManagedState;
import io.netty.buffer.ByteBuf;

public class Permit<S extends ManagedState<S>>
extends UniversalObject {
    protected S state;
    protected Status status;
    protected long timestamp;

    public Permit() {
        this.status = Status.UNKNOWN;
    }

    public Permit(S state) {
        this.state = state;
        this.status = Status.REQUESTED;
        this.timestamp = System.currentTimeMillis();
    }

    public S getState() {
        return this.state;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void read(ByteBuf byteBuf) {
        super.read(byteBuf);
        this.timestamp = byteBuf.readLong();
        this.status = Status.values()[byteBuf.readInt()];
        this.state = (ManagedState)TypeRegistry.getINSTANCE().fromBytes(byteBuf);
    }

    @Override
    public void write(ByteBuf byteBuf) {
        super.write(byteBuf);
        byteBuf.writeLong(this.timestamp);
        byteBuf.writeInt(this.status.ordinal());
        TypeRegistry.getINSTANCE().toBytes(this.state, byteBuf);
    }

    static {
        TypeRegistry.getINSTANCE().register(Permit.class);
    }

    public static enum Status {
        REQUESTED,
        GRANTED,
        DENIED,
        UNKNOWN;

    }
}

