/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render.bgl;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.utils.MWCUtil;
import com.paneedah.weaponlib.animation.AnimationModeProcessor;
import com.paneedah.weaponlib.animation.ClientValueRepo;
import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.particle.ParticleFancyRain;
import com.paneedah.weaponlib.render.Bloom;
import com.paneedah.weaponlib.render.DepthTexture;
import com.paneedah.weaponlib.render.HDRFramebuffer;
import com.paneedah.weaponlib.render.Shaders;
import com.paneedah.weaponlib.render.bgl.GLCompatible;
import com.paneedah.weaponlib.render.bgl.LightManager;
import com.paneedah.weaponlib.render.bgl.weather.ModernWeatherRenderer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.ParticleRain;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;
import org.lwjgl.util.vector.Matrix4f;

public class PostProcessPipeline {
    private static int width = -1;
    private static int height = -1;
    public static final ResourceLocation HEAT_DISTORTION = new ResourceLocation("mwc", "textures/maps/heatdistortion.png");
    public static final ResourceLocation CLOUD_SPRITE = new ResourceLocation("mwc", "textures/maps/cloudsprite.png");
    public static final ResourceLocation RAIN_DROP_TEXTURE = new ResourceLocation("mwc", "textures/maps/raindrop.png");
    public static final ResourceLocation SNOW_FLAKE_TEXTURE = new ResourceLocation("mwc", "textures/maps/snowflake.png");
    private static final FloatBuffer projectionBuffer = BufferUtils.createFloatBuffer((int)16);
    private static final FloatBuffer modelViewBuffer = BufferUtils.createFloatBuffer((int)16);
    private static final FloatBuffer PROJECTION_MATRIX_BUFFER = BufferUtils.createFloatBuffer((int)16);
    private static final FloatBuffer MODELVIEW_MATRIX_BUFFER = BufferUtils.createFloatBuffer((int)16);
    private static final LightManager lightManager = new LightManager();
    public static Framebuffer distortionBuffer;
    public static Framebuffer rainBuffer;
    public static Framebuffer secondaryWorldBuffer;
    private static ArrayList<DistortionPoint> distortionList;
    private static int fauxColorTexture;
    private static DepthTexture scopeDepthTexture;
    private static DepthTexture normalDepthTexture;
    private static IRenderHandler originalWeatherRenderer;
    private static boolean isOriginalWeatherRendererDirty;
    private static final ModernWeatherRenderer modernWeatherRenderer;
    private static final float ALPHA_MULTIPLIER_DISTORTION = 0.5f;
    private static final int MAX_RAINDROPS_ON_SCREEN = 16;
    private static final float BASE_FOG_INTENSITY = 0.2f;
    private static final float[] BASE_FOG_COLOR;
    public static float[][] rainDrops;
    public static long inRainTimestamp;
    private static boolean rainKeepAlive;

    public static void createDistortionPoint(float x, float y, float z, float size, float life) {
        distortionList.add(new DistortionPoint(x, y, z, size, life));
    }

    public static LightManager getLightManager() {
        return lightManager;
    }

    public static ModernWeatherRenderer getWeatherRenderer() {
        return modernWeatherRenderer;
    }

    public static void setWorldElements() {
        IRenderHandler currentWeatherRenderer = ClientProxy.MC.field_71441_e.field_73011_w.getWeatherRenderer();
        if (isOriginalWeatherRendererDirty || currentWeatherRenderer != modernWeatherRenderer && currentWeatherRenderer != originalWeatherRenderer) {
            originalWeatherRenderer = currentWeatherRenderer;
            isOriginalWeatherRendererDirty = false;
        }
        if (ModernConfigManager.enableFancyRainAndSnow) {
            ClientProxy.MC.field_71441_e.field_73011_w.setWeatherRenderer((IRenderHandler)modernWeatherRenderer);
            ClientProxy.MC.field_71452_i.func_178929_a(EnumParticleTypes.WATER_DROP.func_179348_c(), (IParticleFactory)new ParticleFancyRain.Factory());
        } else {
            ClientProxy.MC.field_71441_e.field_73011_w.setWeatherRenderer(originalWeatherRenderer);
            ClientProxy.MC.field_71452_i.func_178929_a(EnumParticleTypes.WATER_DROP.func_179348_c(), (IParticleFactory)new ParticleRain.Factory());
        }
    }

    public static void fillGLBuffers() {
        Matrix4f modelViewMatrix = new Matrix4f();
        Matrix4f projectionMatrix = new Matrix4f();
        modelViewMatrix.load(MODELVIEW_MATRIX_BUFFER);
        projectionMatrix.load(PROJECTION_MATRIX_BUFFER);
        modelViewMatrix.invert();
        projectionMatrix.invert();
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
        projectionMatrix.store(PROJECTION_MATRIX_BUFFER);
        modelViewMatrix.store(MODELVIEW_MATRIX_BUFFER);
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
    }

    public static boolean shouldDoFog() {
        return ModernConfigManager.enableAllShaders && ModernConfigManager.enableWorldShaders && PostProcessPipeline.getFogIntensity() != 0.0f;
    }

    public static void recreateDepthFramebuffer() {
        if (normalDepthTexture == null) {
            normalDepthTexture = new DepthTexture(width, height);
        }
        normalDepthTexture.recreateBuffer(width, height);
    }

    public static void blitScopeDepthTexture(Framebuffer buffer) {
        if (scopeDepthTexture == null) {
            scopeDepthTexture = new DepthTexture(buffer.field_147621_c, buffer.field_147618_d);
        }
        scopeDepthTexture.recreateBuffer(buffer.field_147621_c, buffer.field_147618_d);
        scopeDepthTexture.blitOn(buffer, true);
    }

    public static DepthTexture getScopeDepthTexture() {
        return scopeDepthTexture;
    }

    public static void blitDepth() {
        Framebuffer buffer = ClientProxy.MC.func_147110_a();
        if (normalDepthTexture == null) {
            normalDepthTexture = new DepthTexture(buffer.field_147621_c, buffer.field_147618_d);
        }
        normalDepthTexture.blitOn(buffer, true);
    }

    public static boolean shouldRecreateFramebuffer() {
        if (width == -1 || height == -1) {
            return true;
        }
        return ClientProxy.MC.field_71443_c != width || ClientProxy.MC.field_71440_d != height;
    }

    public static void recreateFramebuffers() {
        width = ClientProxy.MC.field_71443_c;
        height = ClientProxy.MC.field_71440_d;
        PostProcessPipeline.recreateDepthFramebuffer();
        if (distortionBuffer != null) {
            distortionBuffer.func_147608_a();
        }
        distortionBuffer = new Framebuffer(width, height, true);
        if (rainBuffer != null) {
            rainBuffer.func_147608_a();
        }
        rainBuffer = new Framebuffer(width, height, false);
        if (secondaryWorldBuffer != null) {
            secondaryWorldBuffer.func_147608_a();
        }
        secondaryWorldBuffer = new HDRFramebuffer(width, height, true);
    }

    public static Vec3d mat4Transform(Vec3d vec, Matrix4f mat) {
        if (mat != null) {
            double x = (double)mat.m00 * vec.field_72450_a + (double)mat.m10 * vec.field_72448_b + (double)mat.m20 * vec.field_72449_c + (double)mat.m30;
            double y = (double)mat.m01 * vec.field_72450_a + (double)mat.m11 * vec.field_72448_b + (double)mat.m21 * vec.field_72449_c + (double)mat.m31;
            double z = (double)mat.m02 * vec.field_72450_a + (double)mat.m12 * vec.field_72448_b + (double)mat.m22 * vec.field_72449_c + (double)mat.m32;
            return new Vec3d(x, y, z);
        }
        return vec;
    }

    public static void setupDistortionBufferEffects() {
        if (PostProcessPipeline.shouldRecreateFramebuffer()) {
            PostProcessPipeline.recreateFramebuffers();
        }
        distortionBuffer.func_147614_f();
        distortionList.removeIf(s -> (float)(System.currentTimeMillis() - s.getBirthTime()) > s.getLife());
        for (DistortionPoint dp : distortionList) {
            dp.update();
        }
        Vec3d playerPos = ClientProxy.MC.field_71439_g.func_174791_d();
        distortionList.sort((a, b) -> {
            double distA = new Vec3d((double)a.getX(), (double)a.getY(), (double)a.getZ()).func_178788_d(playerPos).func_72433_c();
            double distB = new Vec3d((double)b.getX(), (double)b.getY(), (double)b.getZ()).func_178788_d(playerPos).func_72433_c();
            return (int)(Math.round(distB) - Math.round(distA));
        });
        Vec3d iVec = MWCUtil.getInterpolatedPlayerPos();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-iVec.field_72450_a), (double)(-iVec.field_72448_b), (double)(-iVec.field_72449_c));
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        ClientProxy.MC.func_110434_K().func_110577_a(CLOUD_SPRITE);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)false);
        modelViewBuffer.rewind();
        projectionBuffer.rewind();
        GL11.glGetFloat((int)2982, (FloatBuffer)modelViewBuffer);
        GL11.glGetFloat((int)2983, (FloatBuffer)projectionBuffer);
        modelViewBuffer.rewind();
        projectionBuffer.rewind();
        Matrix4f modelViewMatrix = new Matrix4f();
        Matrix4f projectionMatrix = new Matrix4f();
        modelViewMatrix.load(modelViewBuffer);
        projectionMatrix.load(projectionBuffer);
        Matrix4f viewProjection = new Matrix4f();
        Matrix4f.mul((Matrix4f)projectionMatrix, (Matrix4f)modelViewMatrix, (Matrix4f)viewProjection);
        modelViewMatrix.m30 = 0.0f;
        modelViewMatrix.m31 = 0.0f;
        modelViewMatrix.m32 = 0.0f;
        modelViewMatrix.invert();
        Shaders.billboard.use();
        Shaders.billboard.uniform1i("depthTex", 6);
        Shaders.billboard.uniform2f("viewportSize", width, height);
        GlStateManager.func_179098_w();
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (DistortionPoint dp : distortionList) {
            Vec3d pos = new Vec3d((double)dp.getX(), (double)dp.getY(), (double)dp.getZ());
            Vec3d v1 = PostProcessPipeline.mat4Transform(new Vec3d((double)(-dp.getSize()), (double)(-dp.getSize()), 0.0), modelViewMatrix).func_178787_e(pos);
            Vec3d v2 = PostProcessPipeline.mat4Transform(new Vec3d((double)(-dp.getSize()), (double)dp.getSize(), 0.0), modelViewMatrix).func_178787_e(pos);
            Vec3d v3 = PostProcessPipeline.mat4Transform(new Vec3d((double)dp.getSize(), (double)dp.getSize(), 0.0), modelViewMatrix).func_178787_e(pos);
            Vec3d v4 = PostProcessPipeline.mat4Transform(new Vec3d((double)dp.getSize(), (double)(-dp.getSize()), 0.0), modelViewMatrix).func_178787_e(pos);
            bb.func_181662_b(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, dp.getAlpha() * 0.5f).func_181675_d();
            bb.func_181662_b(v2.field_72450_a, v2.field_72448_b, v2.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, dp.getAlpha() * 0.5f).func_181675_d();
            bb.func_181662_b(v3.field_72450_a, v3.field_72448_b, v3.field_72449_c).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, dp.getAlpha() * 0.5f).func_181675_d();
            bb.func_181662_b(v4.field_72450_a, v4.field_72448_b, v4.field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, dp.getAlpha() * 0.5f).func_181675_d();
        }
        t.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        ClientProxy.MC.func_147110_a().func_147610_a(false);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179121_F();
        Shaders.billboard.release();
    }

    public static void captureMatricesIntoBuffers() {
        GL11.glGetFloat((int)2982, (FloatBuffer)MODELVIEW_MATRIX_BUFFER);
        GL11.glGetFloat((int)2983, (FloatBuffer)PROJECTION_MATRIX_BUFFER);
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
    }

    public static float getFogIntensity() {
        if (ClientProxy.MC.field_71441_e == null) {
            return 0.0f;
        }
        return 0.2f * ClientProxy.MC.field_71441_e.func_72867_j(ClientProxy.MC.func_184121_ak());
    }

    public static float[] getBaseFogColor() {
        return BASE_FOG_COLOR;
    }

    public static void doWorldProcessing() {
        if (!ModernConfigManager.enableWorldShaders) {
            return;
        }
        if (PostProcessPipeline.shouldRecreateFramebuffer()) {
            PostProcessPipeline.recreateFramebuffers();
        }
        secondaryWorldBuffer.func_147610_a(false);
        GlStateManager.func_179138_g((int)33990);
        GlStateManager.func_179144_i((int)normalDepthTexture.getTexture());
        GlStateManager.func_179138_g((int)33984);
        PostProcessPipeline.fillGLBuffers();
        OpenGlHelper.func_153171_g((int)GLCompatible.GL_READ_FRAMEBUFFER, (int)ClientProxy.MC.func_147110_a().field_147616_f);
        OpenGlHelper.func_153171_g((int)GLCompatible.GL_DRAW_FRAMEBUFFER, (int)PostProcessPipeline.secondaryWorldBuffer.field_147616_f);
        GLCompatible.glBlitFramebuffer(0, 0, width, height, 0, 0, width, height, 16384, 9728);
        Shaders.postWorld.use();
        Shaders.postWorld.uniform1i("depthBuf", 6);
        Shaders.postWorld.uniform1f("fogIntensity", PostProcessPipeline.getFogIntensity());
        Shaders.postWorld.uniform3f("baseFogColor", PostProcessPipeline.getBaseFogColor()[0], PostProcessPipeline.getBaseFogColor()[1], PostProcessPipeline.getBaseFogColor()[2]);
        lightManager.updateUniforms(Shaders.postWorld);
        lightManager.update();
        Vec3d interpolatedPosition = MWCUtil.getInterpolatedPlayerPos();
        Shaders.postWorld.uniform3f("cameraPosition", (float)interpolatedPosition.field_72450_a, (float)interpolatedPosition.field_72448_b, (float)interpolatedPosition.field_72449_c);
        Shaders.postWorld.sendMatrix4AsUniform("inverseViewMatrix", false, MODELVIEW_MATRIX_BUFFER);
        Shaders.postWorld.sendMatrix4AsUniform("inverseProjectionMatrix", false, PROJECTION_MATRIX_BUFFER);
        OpenGlHelper.func_153171_g((int)GLCompatible.GL_DRAW_FRAMEBUFFER, (int)ClientProxy.MC.func_147110_a().field_147616_f);
        secondaryWorldBuffer.func_147615_c(ClientProxy.MC.field_71443_c, ClientProxy.MC.field_71440_d);
        Shaders.postWorld.release();
        ClientProxy.MC.func_147110_a().func_147610_a(false);
        GL11.glEnable((int)2929);
        if (ModernConfigManager.enableAllShaders && ModernConfigManager.onScreenRainAndSnow) {
            PostProcessPipeline.drawRainBuffer();
        }
    }

    public static void prepareRainBuffer() {
        rainBuffer.func_147614_f();
        rainBuffer.func_147610_a(false);
        GlStateManager.func_179094_E();
        ScaledResolution scaledresolution = new ScaledResolution(ClientProxy.MC);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
    }

    public static void drawRainBuffer() {
        float rainStrength = ClientProxy.MC.field_71441_e.func_72867_j(ClientProxy.MC.func_184121_ak());
        boolean isRain = ModernWeatherRenderer.isRainingOrSnowing(ClientProxy.MC.field_71439_g.func_180425_c());
        if ((double)rainStrength == 0.0 && !rainKeepAlive) {
            return;
        }
        Biome playerBiome = ClientProxy.MC.field_71441_e.func_180494_b(ClientProxy.MC.field_71439_g.func_180425_c());
        int playerHeight = ClientProxy.MC.field_71441_e.func_189649_b(ClientProxy.MC.field_71439_g.func_180425_c().func_177958_n(), ClientProxy.MC.field_71439_g.func_180425_c().func_177952_p());
        if ((double)rainStrength != 0.0 && (double)ClientProxy.MC.field_71439_g.func_70047_e() + ClientProxy.MC.field_71439_g.field_70163_u > (double)playerHeight && (isRain && playerBiome.func_76738_d() || !isRain && playerBiome.func_76746_c())) {
            if (inRainTimestamp == -1L) {
                inRainTimestamp = System.currentTimeMillis();
            }
            long currentTime = (int)Math.min(16.0 * ((double)(System.currentTimeMillis() - inRainTimestamp) / 2000.0) * (double)rainStrength, 16.0);
            int i = 0;
            while ((long)i < currentTime) {
                if (rainDrops[i][7] == 0.0f) {
                    float velocity = 0.0f;
                    if (isRain && Math.random() < 0.3) {
                        velocity = (float)(Math.random() * 20.0);
                    }
                    PostProcessPipeline.rainDrops[i] = new float[]{(float)Math.random() * 600.0f, (float)Math.random() * 250.0f, 0.0f, velocity, 0.0f, (float)Math.random() * 25.0f + 30.0f, 0.0f, (float)Math.random() * 10.0f, 0.0f, isRain ? 1.0f : 0.0f};
                }
                ++i;
            }
        } else {
            inRainTimestamp = -1L;
        }
        PostProcessPipeline.prepareRainBuffer();
        rainKeepAlive = false;
        double dt = 0.05;
        for (float[] raindrop : rainDrops) {
            if (raindrop[7] == 0.0f) continue;
            rainKeepAlive = true;
            if (raindrop[9] == 1.0f) {
                ClientProxy.MC.func_110434_K().func_110577_a(RAIN_DROP_TEXTURE);
            } else {
                ClientProxy.MC.func_110434_K().func_110577_a(SNOW_FLAKE_TEXTURE);
            }
            float lifeDivisor = 64.0f;
            if (raindrop[6] < raindrop[7] / lifeDivisor) {
                raindrop[4] = raindrop[5] * (raindrop[6] / (raindrop[7] / lifeDivisor));
            }
            raindrop[6] = raindrop[6] + 0.01f;
            if (raindrop[6] > raindrop[7]) {
                raindrop[7] = 0.0f;
            }
            raindrop[2] = (float)((double)raindrop[2] * 0.9999);
            raindrop[3] = (float)((double)raindrop[3] * 0.992);
            float vertical = (float)((double)raindrop[3] * dt);
            raindrop[0] = (float)((double)raindrop[0] + (double)raindrop[2] * dt);
            raindrop[1] = raindrop[1] + vertical;
            raindrop[8] = raindrop[8] + vertical;
            float alphaFade = 1.0f;
            if (raindrop[6] > raindrop[7] / 2.0f) {
                alphaFade = 1.0f - (raindrop[6] - raindrop[7] / 2.0f) / (raindrop[7] / 2.0f);
            }
            PostProcessPipeline.drawRaindrop(raindrop[0], raindrop[1], raindrop[4], raindrop[8], alphaFade);
        }
        PostProcessPipeline.endRainBufferRender();
    }

    public static void drawRaindrop(double x, double y, double size, double stretch, float alpha) {
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        GlStateManager.func_179129_p();
        double halfSize = size / 2.0;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        bb.func_181668_a(5, DefaultVertexFormats.field_181707_g);
        bb.func_181662_b(x - halfSize, y - stretch, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        bb.func_181662_b(x - halfSize, y + halfSize, 0.0).func_187315_a(0.0, 0.5).func_181675_d();
        bb.func_181662_b(x + halfSize, y - stretch, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bb.func_181662_b(x + halfSize, y - stretch, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bb.func_181662_b(x + halfSize, y + halfSize, 0.0).func_187315_a(1.0, 0.5).func_181675_d();
        bb.func_181662_b(x - halfSize, y + halfSize, 0.0).func_187315_a(0.0, 0.5).func_181675_d();
        bb.func_181662_b(x - halfSize, y + halfSize, 0.0).func_187315_a(0.0, 0.5).func_181675_d();
        bb.func_181662_b(x + halfSize, y + halfSize, 0.0).func_187315_a(1.0, 0.5).func_181675_d();
        bb.func_181662_b(x - halfSize, y + size, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bb.func_181662_b(x + halfSize, y + halfSize, 0.0).func_187315_a(1.0, 0.5).func_181675_d();
        bb.func_181662_b(x - halfSize, y + size, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bb.func_181662_b(x + halfSize, y + size, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        t.func_78381_a();
    }

    public static void endRainBufferRender() {
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        float fpt = ClientProxy.MC.field_71460_t.field_78530_s;
        float fovModValue = ClientProxy.MC.field_71460_t.func_78481_a(ClientProxy.MC.func_184121_ak(), false);
        Project.gluPerspective((float)fovModValue, (float)((float)ClientProxy.MC.field_71443_c / (float)ClientProxy.MC.field_71440_d), (float)0.05f, (float)(fpt * 2.0f));
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179121_F();
        ClientProxy.MC.func_147110_a().func_147610_a(false);
    }

    public static void doPostProcess() {
        if (!ModernConfigManager.enableScreenShaders) {
            return;
        }
        if (ModernConfigManager.bloomEffect) {
            Bloom.doBloom();
        }
        if (AnimationModeProcessor.getInstance().getFPSMode()) {
            return;
        }
        if (PostProcessPipeline.shouldRecreateFramebuffer()) {
            PostProcessPipeline.recreateFramebuffers();
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        boolean isRain = ClientProxy.MC.field_71441_e.func_72959_q().func_76939_a((float)ClientProxy.MC.field_71439_g.func_180425_c().func_177958_n(), ClientProxy.MC.field_71439_g.func_180425_c().func_177952_p()) >= 0.15f;
        GlStateManager.func_179138_g((int)33987);
        GlStateManager.func_179144_i((int)PostProcessPipeline.rainBuffer.field_147617_g);
        GlStateManager.func_179138_g((int)33989);
        GlStateManager.func_179144_i((int)PostProcessPipeline.distortionBuffer.field_147617_g);
        GlStateManager.func_179138_g((int)33988);
        ClientProxy.MC.func_110434_K().func_110577_a(HEAT_DISTORTION);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GlStateManager.func_179138_g((int)33984);
        Shaders.post.use();
        Shaders.post.uniform1i("rainBuf", 3);
        Shaders.post.uniform1i("distortionTex", 4);
        Shaders.post.uniform1i("distortionBuffer", 5);
        Shaders.post.uniform2f("windowSize", 1.0f / (float)ClientProxy.MC.field_71443_c, 1.0f / (float)ClientProxy.MC.field_71440_d);
        Shaders.post.boolean1b("isSnow", !isRain);
        Shaders.post.uniform1f("timer", ClientValueRepo.TICKER.getLerpedFloat());
        Shaders.post.boolean1b("enableFilmGrain", ModernConfigManager.filmGrain);
        Shaders.post.uniform1f("mdf", (float)ModernConfigManager.filmGrainIntensity);
        Shaders.post.boolean1b("onScreenLiquids", ModernConfigManager.onScreenRainAndSnow);
        Framebuffer boof = ClientProxy.MC.func_147110_a();
        Bloom.renderFboTriangle(boof, boof.field_147621_c, boof.field_147618_d);
        Shaders.post.release();
    }

    static {
        distortionList = new ArrayList();
        fauxColorTexture = -1;
        originalWeatherRenderer = null;
        isOriginalWeatherRendererDirty = true;
        modernWeatherRenderer = new ModernWeatherRenderer();
        BASE_FOG_COLOR = new float[]{0.6f, 0.6f, 0.6f};
        rainDrops = new float[64][9];
        inRainTimestamp = System.currentTimeMillis();
        rainKeepAlive = false;
    }

    public static class DistortionPoint {
        private float x;
        private float y;
        private float z;
        private float size;
        private float life;
        private float alpha;
        private long creationTime;

        public DistortionPoint(float x, float y, float z, float size, float life) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.size = size;
            this.life = life;
            this.creationTime = System.currentTimeMillis();
        }

        public void update() {
            this.alpha = 1.0f - (float)(System.currentTimeMillis() - this.creationTime) / this.life;
        }

        public float getAlpha() {
            return this.alpha;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }

        public float getSize() {
            return this.size;
        }

        public float getLife() {
            return this.life;
        }

        public long getBirthTime() {
            return this.creationTime;
        }
    }
}

