/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureUtil;
import org.lwjgl.BufferUtils;

public class ImageCaptureUtil {
    private static IntBuffer pixelBuffer = null;
    private static int[] pixelValues = null;

    public static BufferedImage captureImage(int image, int width, int height, AffineTransform affine) {
        int i = width * height;
        if (pixelBuffer == null || pixelBuffer.capacity() < i) {
            pixelBuffer = BufferUtils.createIntBuffer((int)i);
            pixelValues = new int[i];
        }
        GlStateManager.func_187425_g((int)3333, (int)1);
        GlStateManager.func_187425_g((int)3317, (int)1);
        pixelBuffer.clear();
        if (OpenGlHelper.func_148822_b()) {
            GlStateManager.func_179144_i((int)image);
            GlStateManager.func_187433_a((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
        } else {
            GlStateManager.func_187413_a((int)0, (int)0, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
        }
        pixelBuffer.get(pixelValues);
        TextureUtil.func_147953_a((int[])pixelValues, (int)width, (int)height);
        BufferedImage bufferedimage = new BufferedImage(width, height, 2);
        bufferedimage.setRGB(0, 0, width, height, pixelValues, 0, width);
        if (affine != null) {
            return ImageCaptureUtil.transformImage(bufferedimage, affine);
        }
        return bufferedimage;
    }

    public static BufferedImage transformImage(BufferedImage img, AffineTransform transform) {
        BufferedImage newImage = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        Graphics2D g = newImage.createGraphics();
        g.transform(transform);
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return newImage;
    }

    public static void saveImageToDisk(File file, BufferedImage img) {
        try {
            ImageIO.write((RenderedImage)img, "png", file);
        }
        catch (IOException e) {
            System.err.println("Could not save buffered image to disk!");
        }
    }
}

