/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render;

import com.paneedah.weaponlib.render.WavefrontModel;
import com.paneedah.weaponlib.render.bgl.GLCompatible;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL15;

public class GLModelBuilder {
    private static final int FLOAT_SIZE = 4;
    private static final int INT_SIZE = 4;

    public static int createStaticBuffer(int floatCount) {
        int vbo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vbo);
        GL15.glBufferData((int)34962, (long)(floatCount * 4), (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
        return vbo;
    }

    public static int createElementBuffer(int floatcount) {
        int ebo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34963, (int)ebo);
        GL15.glBufferData((int)34963, (long)(floatcount * 4), (int)35044);
        return ebo;
    }

    public static void unbindElementBuffer() {
        GL15.glBindBuffer((int)34963, (int)0);
    }

    public static int createVAO() {
        int vaoID = GLCompatible.glGenVertexArrays();
        GLCompatible.glBindVertexArray(vaoID);
        return vaoID;
    }

    public static int buildVBO(ArrayList<WavefrontModel.Vertex> vertexes) {
        int vbo = GL15.glGenBuffers();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)(vertexes.size() * 8));
        for (WavefrontModel.Vertex v : vertexes) {
            floatBuffer.put(v.pos);
            floatBuffer.put(new float[]{v.texCoord[0], -v.texCoord[1]});
            floatBuffer.put(v.normal);
        }
        floatBuffer.rewind();
        GL15.glBindBuffer((int)34962, (int)vbo);
        GL15.glBufferData((int)34962, (FloatBuffer)floatBuffer, (int)35044);
        return vbo;
    }

    public static void fillBuffer(DoubleBuffer nioBuffer, double[][] buf) {
        for (double[] sub : buf) {
            nioBuffer.put(sub);
        }
        nioBuffer.rewind();
    }

    public static void fillBuffer(FloatBuffer nioBuffer, float[][] buf) {
        for (float[] sub : buf) {
            nioBuffer.put(sub);
        }
        nioBuffer.rewind();
    }

    public static void unbindVAO() {
        GLCompatible.glBindVertexArray(0);
    }
}

