/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render;

import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.render.Dloom;
import com.paneedah.weaponlib.render.Shaders;
import com.paneedah.weaponlib.render.bgl.GLCompatible;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL20;

public class Bloom {
    private static final Logger LOGGER = LogManager.getLogger(Bloom.class);
    public static final Minecraft MC = Minecraft.func_71410_x();
    public static int width = Bloom.MC.field_71443_c;
    public static int height = Bloom.MC.field_71440_d;
    public static boolean hasLoaded = false;
    public static Framebuffer[] buffers;
    public static Framebuffer data;
    public static boolean multisample;
    public static int multisampleFBO;
    public static int multiampleTexFBO;
    public static int mRes;
    public static int msaaDepthTex;

    public static int getLayers() {
        return ModernConfigManager.bloomLayers;
    }

    public static void setupBloom() {
        width = Bloom.MC.field_71443_c;
        height = Bloom.MC.field_71440_d;
        hasLoaded = true;
        LOGGER.debug("Recreating Bloom FBOs at ({} x {})", (Object)width, (Object)height);
        Bloom.recreateFramebuffers();
        Dloom.height = -1;
    }

    public static boolean shouldRecreateFBOs() {
        return Bloom.MC.field_71443_c != width || Bloom.MC.field_71440_d != height || !hasLoaded;
    }

    public static boolean bloomNotAvaliable() {
        return data == null;
    }

    public static void doBloom() {
        if (Bloom.shouldRecreateFBOs()) {
            Bloom.setupBloom();
        }
        Bloom.renderHDRToBuffer();
        Bloom.use();
    }

    public static void bindBloomBuffer() {
        if (Bloom.bloomNotAvaliable()) {
            return;
        }
        data.func_147610_a(false);
    }

    public static void recreateFramebuffers() {
        int width = Bloom.MC.field_71443_c;
        int height = Bloom.MC.field_71440_d;
        if (buffers != null) {
            for (Framebuffer f : buffers) {
                f.func_147608_a();
            }
        }
        if (data != null) {
            data.func_147608_a();
        }
        data = new Framebuffer(width, height, true);
        data.func_147612_c();
        GL11.glTexImage2D((int)3553, (int)0, (int)GLCompatible.GL_RGBA16F, (int)width, (int)height, (int)0, (int)6408, (int)5123, (IntBuffer)null);
        data.func_147610_a(false);
        OpenGlHelper.func_153176_h((int)GLCompatible.GL_RENDERBUFFER, (int)Bloom.MC.func_147110_a().field_147624_h);
        OpenGlHelper.func_153190_b((int)GLCompatible.GL_FRAMEBUFFER, (int)GLCompatible.GL_DEPTH_ATTACHMENT, (int)GLCompatible.GL_RENDERBUFFER, (int)Bloom.MC.func_147110_a().field_147624_h);
        data.func_147607_a(9729);
        data.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        data.func_147614_f();
        Bloom.checkFramebufer(Bloom.data.field_147616_f);
        buffers = new Framebuffer[Bloom.getLayers()];
        float bW = width;
        float bH = height;
        for (int i = 0; i < Bloom.getLayers(); ++i) {
            Bloom.buffers[i] = new Framebuffer((int)bW, (int)bH, false);
            buffers[i].func_147612_c();
            GL11.glTexImage2D((int)3553, (int)0, (int)GLCompatible.GL_RGBA16F, (int)((int)bW), (int)((int)bH), (int)0, (int)6408, (int)5123, (IntBuffer)null);
            buffers[i].func_147607_a(9729);
            buffers[i].func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
            if (i < 1) {
                bW *= 0.25f;
                bH *= 0.25f;
                continue;
            }
            bW *= 0.5f;
            bH *= 0.5f;
        }
        LOGGER.debug("Refreshed Bloom buffer succesfully!");
    }

    public static void checkFramebufer(int buf) {
        int i = OpenGlHelper.func_153167_i((int)OpenGlHelper.field_153198_e);
        if (i != OpenGlHelper.field_153202_i) {
            if (i == OpenGlHelper.field_153203_j) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
            }
            if (i == OpenGlHelper.field_153204_k) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
            }
            if (i == OpenGlHelper.field_153205_l) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
            }
            if (i == OpenGlHelper.field_153206_m) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
            }
            throw new RuntimeException("glCheckFramebufferStatus returned unknown status:" + i);
        }
    }

    public static void renderHDRToBuffer() {
        GlStateManager.func_179138_g((int)33988);
        GlStateManager.func_179144_i((int)Minecraft.func_71410_x().func_147110_a().field_147617_g);
        GlStateManager.func_179138_g((int)33984);
        data.func_147610_a(false);
        GlStateManager.func_179147_l();
        Shaders.bloomTest.use();
        Shaders.bloomTest.uniform1i("real", 4);
        Bloom.renderFboTriangle(data, Bloom.data.field_147621_c, Bloom.data.field_147618_d);
        Shaders.bloomTest.release();
        GlStateManager.func_179084_k();
    }

    public static void renderFboTriangle(Framebuffer buf) {
        Bloom.renderFboTriangle(buf, buf.field_147621_c, buf.field_147618_d);
    }

    public static void renderFboTriangle(Framebuffer buf, int width, int height) {
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179083_b((int)0, (int)0, (int)width, (int)height);
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179118_c();
        GlStateManager.func_179142_g();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buf.func_147612_c();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(4, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(-1.0, -1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(3.0, -1.0, 0.0).func_187315_a(2.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(-1.0, 3.0, 0.0).func_187315_a(0.0, 2.0).func_181675_d();
        tessellator.func_78381_a();
        buf.func_147606_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public static void runDownsampler() {
        buffers[0].func_147610_a(true);
        Shaders.downsample.use();
        GL20.glUniform2f((int)GL20.glGetUniformLocation((int)Shaders.downsample.getShaderId(), (CharSequence)"texel"), (float)(1.0f / (float)Bloom.data.field_147622_a), (float)(1.0f / (float)Bloom.data.field_147620_b));
        Bloom.renderFboTriangle(data, Bloom.buffers[0].field_147621_c, Bloom.buffers[0].field_147618_d);
        for (int i = 1; i < Bloom.getLayers(); ++i) {
            buffers[i].func_147610_a(true);
            GL20.glUniform2f((int)GL20.glGetUniformLocation((int)Shaders.downsample.getShaderId(), (CharSequence)"texel"), (float)(1.0f / (float)Bloom.buffers[i - 1].field_147622_a), (float)(1.0f / (float)Bloom.buffers[i - 1].field_147620_b));
            Bloom.renderFboTriangle(buffers[i - 1], Bloom.buffers[i].field_147621_c, Bloom.buffers[i].field_147618_d);
        }
        Shaders.downsample.release();
    }

    public static void use() {
        Bloom.runDownsampler();
        GlStateManager.func_179147_l();
        for (int i = Bloom.getLayers() - 1; i >= 0; --i) {
            int tHeight;
            int tWidth;
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            buffers[i].func_147610_a(true);
            Shaders.upsample.use();
            GL20.glUniform2f((int)GL20.glGetUniformLocation((int)Shaders.upsample.getShaderId(), (CharSequence)"fragmentSize"), (float)(1.0f / (float)Bloom.buffers[i].field_147621_c), (float)(1.0f / (float)Bloom.buffers[i].field_147618_d));
            if (i == 0) {
                Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
                tWidth = Minecraft.func_71410_x().func_147110_a().field_147621_c;
                tHeight = Minecraft.func_71410_x().func_147110_a().field_147618_d;
            } else {
                GlStateManager.func_187398_d((int)32776);
                buffers[i - 1].func_147610_a(true);
                tWidth = Bloom.buffers[i - 1].field_147621_c;
                tHeight = Bloom.buffers[i - 1].field_147618_d;
            }
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            Bloom.renderFboTriangle(buffers[i], tWidth, tHeight);
            GL14.glBlendEquation((int)32774);
        }
        GL20.glUseProgram((int)0);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        data.func_147610_a(true);
        GlStateManager.func_179082_a((float)Bloom.data.field_147625_i[0], (float)Bloom.data.field_147625_i[1], (float)Bloom.data.field_147625_i[2], (float)Bloom.data.field_147625_i[3]);
        GlStateManager.func_179086_m((int)16384);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
        GlStateManager.func_179141_d();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    public static void bindMultisample() {
        GLCompatible.glBindFramebuffer(OpenGlHelper.field_153198_e, multisampleFBO);
    }

    public static void bindMinecraft() {
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
    }

    public static int getWidthTimesHeight() {
        return Minecraft.func_71410_x().field_71443_c * Minecraft.func_71410_x().field_71440_d;
    }

    public static void setupMultisampleBuffer() {
        if (GLCompatible.isLoaded && GLCompatible.multisampleType == -1) {
            return;
        }
        if (multisample && Bloom.getWidthTimesHeight() == mRes) {
            return;
        }
        mRes = Bloom.getWidthTimesHeight();
        multisampleFBO = GLCompatible.glGenFramebuffers();
        GLCompatible.glBindFramebuffer(GLCompatible.GL_FRAMEBUFFER, multisampleFBO);
        multiampleTexFBO = GL11.glGenTextures();
        int width = Minecraft.func_71410_x().field_71443_c;
        int height = Minecraft.func_71410_x().field_71440_d;
        GL11.glBindTexture((int)GLCompatible.GL_TEXTURE_2D_MULTISAMPLE, (int)multiampleTexFBO);
        GLCompatible.glTexImage2DMultisample(GLCompatible.GL_TEXTURE_2D_MULTISAMPLE, 4, 32856, width, height, false);
        GLCompatible.glFramebufferTexture2D(GLCompatible.GL_FRAMEBUFFER, GLCompatible.GL_COLOR_ATTACHMENT0, GLCompatible.GL_TEXTURE_2D_MULTISAMPLE, multiampleTexFBO, 0);
        GlStateManager.func_179126_j();
        msaaDepthTex = GL11.glGenTextures();
        GL11.glBindTexture((int)GLCompatible.GL_TEXTURE_2D_MULTISAMPLE, (int)msaaDepthTex);
        GLCompatible.glTexImage2DMultisample(GLCompatible.GL_TEXTURE_2D_MULTISAMPLE, 4, 33190, width, height, false);
        GLCompatible.glFramebufferTexture2D(GLCompatible.GL_FRAMEBUFFER, 36096, GLCompatible.GL_TEXTURE_2D_MULTISAMPLE, msaaDepthTex, 0);
        multisample = true;
    }

    public static void initializeMultisample(Framebuffer initial) {
        if (GLCompatible.isLoaded && GLCompatible.multisampleType == -1) {
            return;
        }
        int gWidth = initial.field_147621_c;
        int gHeight = initial.field_147618_d;
        Bloom.setupMultisampleBuffer();
        GlStateManager.func_179126_j();
        GLCompatible.glBindFramebuffer(GLCompatible.GL_READ_FRAMEBUFFER, initial.field_147616_f);
        GLCompatible.glBindFramebuffer(GLCompatible.GL_DRAW_FRAMEBUFFER, multisampleFBO);
        GLCompatible.glBlitFramebuffer(0, 0, gWidth, gHeight, 0, 0, gWidth, gHeight, 16384, 9728);
        GLCompatible.glBlitFramebuffer(0, 0, gWidth, gHeight, 0, 0, gWidth, gHeight, 256, 9728);
        Bloom.bindMultisample();
    }

    public static void initializeMultisample() {
        Bloom.initializeMultisample(Minecraft.func_71410_x().func_147110_a());
    }

    public static void unapplyMultisample() {
        Bloom.unapplyMultisample(Minecraft.func_71410_x().func_147110_a());
    }

    public static void unapplyMultisample(Framebuffer initial) {
        if (GLCompatible.isLoaded && GLCompatible.multisampleType == -1) {
            return;
        }
        int gWidth = initial.field_147621_c;
        int gHeight = initial.field_147618_d;
        GLCompatible.glBindFramebuffer(GLCompatible.GL_READ_FRAMEBUFFER, multisampleFBO);
        GLCompatible.glBindFramebuffer(GLCompatible.GL_DRAW_FRAMEBUFFER, initial.field_147616_f);
        GLCompatible.glBlitFramebuffer(0, 0, gWidth, gHeight, 0, 0, gWidth, gHeight, 16384, 9728);
    }

    static {
        multisample = false;
        multisampleFBO = 0;
        multiampleTexFBO = 0;
        mRes = 0;
        msaaDepthTex = 0;
    }
}

