/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.perspective;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.ClientModContext;
import com.paneedah.weaponlib.RenderContext;
import com.paneedah.weaponlib.compatibility.CompatibleWorldRenderer;
import com.paneedah.weaponlib.compatibility.MWCParticleManager;
import com.paneedah.weaponlib.perspective.PerspectiveManager;
import com.paneedah.weaponlib.shader.DynamicShaderContext;
import com.paneedah.weaponlib.shader.DynamicShaderGroupManager;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public abstract class Perspective<S> {
    protected ClientModContext modContext;
    protected Framebuffer framebuffer;
    protected int width;
    protected int height;
    protected CompatibleWorldRenderer entityRenderer;
    protected MWCParticleManager effectRenderer;
    protected DynamicShaderGroupManager shaderGroupManager;

    public void activate(ClientModContext modContext, PerspectiveManager manager) {
        this.modContext = modContext;
        if (this.framebuffer == null) {
            this.framebuffer = new Framebuffer(this.width, this.height, true);
            this.framebuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.entityRenderer = manager.getEntityRenderer();
        this.effectRenderer = manager.getEffectRenderer();
        this.shaderGroupManager = new DynamicShaderGroupManager();
        if (this.shaderGroupManager.hasActiveGroups()) {
            System.err.println("!!! Active shader groups found !!!");
        }
    }

    public void deactivate(ClientModContext modContext) {
        int originalFramebufferId = GlStateManager.func_187397_v((int)36006);
        this.framebuffer.func_147608_a();
        this.shaderGroupManager.removeAllShaders(new DynamicShaderContext(null, (Object)this.entityRenderer, null, 0.0f));
        if (OpenGlHelper.func_148822_b()) {
            OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)originalFramebufferId);
            GlStateManager.func_179083_b((int)0, (int)0, (int)ClientProxy.MC.func_147110_a().field_147621_c, (int)ClientProxy.MC.func_147110_a().field_147618_d);
        }
    }

    public float getBrightness(RenderContext<S> context) {
        return 1.0f;
    }

    public int getTexture(RenderContext<S> context) {
        return this.framebuffer != null ? this.framebuffer.field_147617_g : -1;
    }

    public Framebuffer getFramebuffer() {
        return this.framebuffer;
    }

    public abstract void update(TickEvent.RenderTickEvent var1);
}

